/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.ExternalParticipant;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.RdbParticipantStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.server.impl.DBPool;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ParticipantStorage {
    private static final ParticipantStorage SINGLETON = new RdbParticipantStorage();

    protected ParticipantStorage() {
    }

    public static ParticipantStorage getInstance() {
        return SINGLETON;
    }

    protected abstract Map<Integer, Set<InternalParticipant>> selectInternal(Context var1, Connection var2, int[] var3, StorageType var4) throws OXException;

    final Set<InternalParticipant> selectInternal(Context ctx, Connection con, int taskId, StorageType type) throws OXException {
        Set<InternalParticipant> parts = this.selectInternal(ctx, con, new int[]{taskId}, type).get(taskId);
        if (null == parts) {
            parts = Collections.emptySet();
        }
        return parts;
    }

    final InternalParticipant selectInternal(Context ctx, Connection con, int taskId, int userId, StorageType type) throws OXException {
        return ParticipantStorage.getParticipant(this.selectInternal(ctx, con, taskId, type), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final InternalParticipant selectInternal(Context ctx, int taskId, int userId, StorageType type) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            InternalParticipant internalParticipant = this.selectInternal(ctx, con, taskId, userId, type);
            return internalParticipant;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    abstract void updateInternal(Context var1, Connection var2, int var3, Set<InternalParticipant> var4, StorageType var5) throws OXException;

    final void updateInternal(Context ctx, Connection con, int taskId, InternalParticipant participant, StorageType type) throws OXException {
        HashSet<InternalParticipant> participants = new HashSet<InternalParticipant>(1, 1.0f);
        participants.add(participant);
        this.updateInternal(ctx, con, taskId, participants, type);
    }

    abstract void deleteInternal(Context var1, Connection var2, int var3, int[] var4, StorageType var5, boolean var6) throws OXException;

    final void deleteInternal(Context ctx, Connection con, int taskId, int userId, StorageType type, boolean check) throws OXException {
        this.deleteInternal(ctx, con, taskId, new int[]{userId}, type, check);
    }

    final void deleteInternal(Context ctx, Connection con, int taskId, Set<InternalParticipant> parts, StorageType type, boolean check) throws OXException {
        int[] partIds = new int[parts.size()];
        Iterator<InternalParticipant> iter = parts.iterator();
        for (int i = 0; i < partIds.length; ++i) {
            partIds[i] = iter.next().getIdentifier();
        }
        this.deleteInternal(ctx, con, taskId, partIds, type, check);
    }

    abstract int[] findTasksWithGroup(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    abstract int[] findTasksWithParticipant(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    protected abstract Map<Integer, Set<ExternalParticipant>> selectExternal(Context var1, Connection var2, int[] var3, StorageType var4) throws OXException;

    final Set<ExternalParticipant> selectExternal(Context ctx, Connection con, int taskId, StorageType type) throws OXException {
        Set<ExternalParticipant> parts = this.selectExternal(ctx, con, new int[]{taskId}, type).get(taskId);
        if (null == parts) {
            parts = Collections.emptySet();
        }
        return parts;
    }

    abstract void deleteExternal(Context var1, Connection var2, int var3, String[] var4, StorageType var5, boolean var6) throws OXException;

    void deleteParticipants(Context ctx, Connection con, int taskId, Set<TaskParticipant> participants, StorageType type, boolean sanityCheck) throws OXException {
        if (null == participants || participants.size() == 0) {
            return;
        }
        this.deleteInternal(ctx, con, taskId, ParticipantStorage.extractInternal(participants), type, sanityCheck);
        this.deleteExternal(ctx, con, taskId, ParticipantStorage.extractExternal(participants), type, sanityCheck);
    }

    final void deleteExternal(Context ctx, Connection con, int taskId, Set<ExternalParticipant> parts, StorageType type, boolean check) throws OXException {
        String[] addresses = new String[parts.size()];
        Iterator<ExternalParticipant> iter = parts.iterator();
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = iter.next().getMail();
        }
        this.deleteExternal(ctx, con, taskId, addresses, type, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<TaskParticipant> selectParticipants(Context ctx, int taskId, StorageType type) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            Set<TaskParticipant> set = this.selectParticipants(ctx, con, taskId, type);
            return set;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    final Set<TaskParticipant> selectParticipants(Context ctx, Connection con, int taskId, StorageType type) throws OXException {
        HashSet<TaskParticipant> retval = new HashSet<TaskParticipant>();
        retval.addAll(this.selectInternal(ctx, con, taskId, type));
        retval.addAll(this.selectExternal(ctx, con, taskId, type));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<Integer, Set<TaskParticipant>> selectParticipants(Context ctx, int[] tasks2, StorageType type) throws OXException {
        Set parts;
        Map<Integer, Set<ExternalParticipant>> externals;
        Map<Integer, Set<InternalParticipant>> internals;
        Connection con = DBPool.pickup(ctx);
        try {
            internals = this.selectInternal(ctx, con, tasks2, type);
            externals = this.selectExternal(ctx, con, tasks2, type);
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
        HashMap<Integer, Set<TaskParticipant>> retval = new HashMap<Integer, Set<TaskParticipant>>();
        for (Map.Entry<Integer, Set<InternalParticipant>> entry : internals.entrySet()) {
            parts = (HashSet)retval.get(entry.getKey());
            if (null == parts) {
                parts = new HashSet();
                retval.put(entry.getKey(), parts);
            }
            parts.addAll(entry.getValue());
        }
        for (Map.Entry<Integer, Set<TaskParticipant>> entry : externals.entrySet()) {
            parts = (Set)retval.get(entry.getKey());
            if (null == parts) {
                parts = new HashSet();
                retval.put(entry.getKey(), parts);
            }
            parts.addAll(entry.getValue());
        }
        return retval;
    }

    final Map<Integer, Set<TaskParticipant>> selectParticipants(Context ctx, int[] tasks2, StorageType type, Connection con) throws OXException {
        Set parts;
        Map<Integer, Set<InternalParticipant>> internals = this.selectInternal(ctx, con, tasks2, type);
        Map<Integer, Set<ExternalParticipant>> externals = this.selectExternal(ctx, con, tasks2, type);
        HashMap<Integer, Set<TaskParticipant>> retval = new HashMap<Integer, Set<TaskParticipant>>();
        for (Map.Entry<Integer, Set<InternalParticipant>> entry : internals.entrySet()) {
            parts = (HashSet)retval.get(entry.getKey());
            if (null == parts) {
                parts = new HashSet();
                retval.put(entry.getKey(), parts);
            }
            parts.addAll(entry.getValue());
        }
        for (Map.Entry<Integer, Set<TaskParticipant>> entry : externals.entrySet()) {
            parts = (Set)retval.get(entry.getKey());
            if (null == parts) {
                parts = new HashSet();
                retval.put(entry.getKey(), parts);
            }
            parts.addAll(entry.getValue());
        }
        return retval;
    }

    public void insertParticipants(Context ctx, Connection con, int taskId, Set<TaskParticipant> participants, StorageType type) throws OXException {
        Set<InternalParticipant> internals = ParticipantStorage.extractInternal(participants);
        Set<ExternalParticipant> externals = ParticipantStorage.extractExternal(participants);
        this.insertInternals(ctx, con, taskId, internals, type);
        this.insertExternals(ctx, con, taskId, externals, type);
    }

    public abstract void insertInternals(Context var1, Connection var2, int var3, Set<InternalParticipant> var4, StorageType var5) throws OXException;

    public abstract void insertExternals(Context var1, Connection var2, int var3, Set<ExternalParticipant> var4, StorageType var5) throws OXException;

    public static final Set<ExternalParticipant> extractExternal(Set<TaskParticipant> participants) {
        HashSet<ExternalParticipant> retval = new HashSet<ExternalParticipant>();
        for (TaskParticipant participant : participants) {
            if (TaskParticipant.Type.EXTERNAL != participant.getType()) continue;
            retval.add((ExternalParticipant)participant);
        }
        return retval;
    }

    public static Set<InternalParticipant> extractInternal(Set<TaskParticipant> participants) {
        HashSet<InternalParticipant> retval = new HashSet<InternalParticipant>();
        for (TaskParticipant participant : participants) {
            if (TaskParticipant.Type.INTERNAL != participant.getType()) continue;
            retval.add((InternalParticipant)participant);
        }
        return retval;
    }

    static InternalParticipant getParticipant(Set<InternalParticipant> participants, int userId) {
        InternalParticipant retval = null;
        for (InternalParticipant participant : participants) {
            if (participant.getIdentifier() != userId) continue;
            retval = participant;
            break;
        }
        return retval;
    }
}

