/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.TaskParticipant;
import java.util.Collections;
import java.util.Set;

public class InternalParticipant
extends TaskParticipant {
    static final Set<InternalParticipant> EMPTY_INTERNAL = Collections.emptySet();
    private final UserParticipant user;
    private Integer groupId;

    public InternalParticipant(UserParticipant user, Integer groupId) {
        this.user = user;
        this.groupId = groupId;
    }

    @Override
    TaskParticipant.Type getType() {
        return TaskParticipant.Type.INTERNAL;
    }

    public int getIdentifier() {
        return this.user.getIdentifier();
    }

    Integer getGroupId() {
        return this.groupId;
    }

    int getFolderId() {
        return this.user.getPersonalFolderId();
    }

    final void setFolderId(int folderId) {
        this.user.setPersonalFolderId(folderId);
    }

    final void setConfirm(int confirm) {
        this.user.setConfirm(confirm);
    }

    int getConfirm() {
        return this.user.getConfirm();
    }

    public String getConfirmMessage() {
        return this.user.getConfirmMessage();
    }

    final void setConfirmMessage(String confirmMessage) {
        this.user.setConfirmMessage(confirmMessage);
    }

    public int hashCode() {
        return this.getIdentifier();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InternalParticipant)) {
            return false;
        }
        return this.getIdentifier() == ((InternalParticipant)obj).getIdentifier();
    }

    UserParticipant getUser() {
        return this.user;
    }

    public String toString() {
        return "TaskParticipant: " + this.getIdentifier() + ", Group: " + this.groupId + ", Folder: " + this.getFolderId();
    }

    void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }
}

