/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.session.Session;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class SendAddress
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "sendaddress"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandler(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                UserSettingMail settings = UserSettingMailStorage.getInstance().getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    setting.setSingleValue(settings.getSendAddr());
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                try {
                    QuotedInternetAddress aliasToCheck;
                    boolean found;
                    HashSet<InternetAddress> allAliases;
                    String[] aliases = user.getAliases();
                    if (aliases == null) {
                        allAliases = new HashSet<InternetAddress>(4);
                    } else {
                        allAliases = new HashSet(aliases.length + 3);
                        for (String alias : aliases) {
                            allAliases.add(new QuotedInternetAddress(alias, false));
                        }
                    }
                    if (MailProperties.getInstance().isSupportMsisdnAddresses()) {
                        MsisdnUtility.addMsisdnAddress(allAliases, session);
                    }
                    allAliases.add(new QuotedInternetAddress(user.getMail(), false));
                    UserSettingMailStorage storage = UserSettingMailStorage.getInstance();
                    UserSettingMail settings = storage.getUserSettingMail(user.getId(), ctx);
                    allAliases.add(new QuotedInternetAddress(settings.getSendAddr(), false));
                    String newAlias = setting.getSingleValue().toString();
                    int pos = newAlias.indexOf(47);
                    String checkAlias = newAlias;
                    if (pos > 0) {
                        checkAlias = checkAlias.substring(0, pos);
                    }
                    if (!(found = allAliases.contains((Object)(aliasToCheck = new QuotedInternetAddress(checkAlias, false))))) {
                        throw SettingExceptionCodes.INVALID_VALUE.create(newAlias, setting.getName());
                    }
                    UserSettingMail settings2 = storage.getUserSettingMail(user.getId(), ctx);
                    if (null != settings2) {
                        settings2.setSendAddr(newAlias);
                        storage.saveUserSettingMail(settings2, user.getId(), ctx);
                    }
                }
                catch (AddressException e) {
                    throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                }
            }

            @Override
            public int getId() {
                return -1;
            }
        };
    }
}

