/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.session.Session;

public final class AvailableModules
implements PreferencesItemService {
    private static final String NAME = "availableModules";

    @Override
    public String[] getPath() {
        return new String[]{NAME};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                Setting[] modules = ConfigTree.getInstance().getSettingByPath("modules").getElements();
                SettingStorage sStor = SettingStorage.getInstance(session, ctx, user, userConfig);
                for (Setting module : modules) {
                    Object tmp;
                    Setting enabled = module.getElement("module");
                    if (null != enabled) {
                        sStor.readValues(enabled);
                        tmp = enabled.getSingleValue();
                        if (tmp == null || !Boolean.parseBoolean(tmp.toString())) continue;
                        setting.addMultiValue(module.getName());
                        continue;
                    }
                    if (!module.isLeaf()) {
                        setting.addMultiValue(module.getName());
                        continue;
                    }
                    sStor.readValues(module);
                    tmp = module.getSingleValue();
                    if (null == tmp || !Boolean.parseBoolean(tmp.toString())) continue;
                    setting.addMultiValue(module.getName());
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }
        };
    }
}

