/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.links;

import com.openexchange.api2.LinkSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.tools.session.ServerSession;

public class CopyLinksForChangeExceptions
implements CalendarListener {
    private final LinkSQLInterface links;

    public CopyLinksForChangeExceptions(LinkSQLInterface links2) {
        this.links = links2;
    }

    @Override
    public void createdChangeExceptionInRecurringAppointment(Appointment master, Appointment changeException, int inFolder, ServerSession session) throws OXException {
        int userId = session.getUserId();
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(userId, session.getContext());
        int[] groups = userConfig.getGroups();
        LinkObject[] loadedLinks = this.links.getLinksOfObject(master.getObjectID(), 1, master.getParentFolderID(), userId, groups, session);
        if (loadedLinks == null) {
            return;
        }
        int folderId = changeException.getParentFolderID();
        if (folderId == 0) {
            folderId = inFolder;
        }
        for (LinkObject loadedLink : loadedLinks) {
            LinkObject copy = new LinkObject();
            copy.setFirstFolder(folderId);
            copy.setFirstType(1);
            copy.setFirstId(changeException.getObjectID());
            copy.setSecondFolder(loadedLink.getSecondFolder());
            copy.setSecondType(loadedLink.getSecondType());
            copy.setSecondId(loadedLink.getSecondId());
            copy.setContext(loadedLink.getContectId());
            this.links.saveLink(copy, userId, groups, session);
        }
    }
}

