/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.InfostoreValidator;

public class InvalidCharactersValidator
implements InfostoreValidator {
    @Override
    public DocumentMetadataValidation validate(DocumentMetadata metadata) {
        DocumentMetadataValidation validation = new DocumentMetadataValidation();
        GetSwitch get = new GetSwitch(metadata);
        for (Metadata field : Metadata.VALUES_ARRAY) {
            String error;
            Object value = field.doSwitch(get);
            if (value == null || !(value instanceof String) || null == (error = this.check((String)value))) continue;
            validation.setError(field, error);
        }
        validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_CHARACTERS.create());
        return validation;
    }

    public String check(String string) {
        return Check.containsInvalidChars(string);
    }

    @Override
    public String getName() {
        return "InvalidCharactersValidator";
    }
}

