/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.ReuseReadConProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Quota;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreTimedResult;
import com.openexchange.groupware.infostore.database.InfostoreFilenameReservation;
import com.openexchange.groupware.infostore.database.InfostoreFilenameReserver;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.CheckSizeSwitch;
import com.openexchange.groupware.infostore.database.impl.CreateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.CreateVersionAction;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.infostore.database.impl.DeleteDocumentAction;
import com.openexchange.groupware.infostore.database.impl.DeleteVersionAction;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreIterator;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.database.impl.ReplaceDocumentIntoDelTableAction;
import com.openexchange.groupware.infostore.database.impl.SelectForUpdateFilenameReserver;
import com.openexchange.groupware.infostore.database.impl.UpdateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.UpdateVersionAction;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.groupware.infostore.validation.FilenamesMayNotContainSlashesValidator;
import com.openexchange.groupware.infostore.validation.InvalidCharactersValidator;
import com.openexchange.groupware.infostore.validation.ValidationChain;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.infostore.webdav.TouchInfoitemsWithExpiredLocksListener;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.quota.Quota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.quota.QuotaService;
import com.openexchange.quota.QuotaType;
import com.openexchange.quota.Resource;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.file.AppendFileAction;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.SaveFileAction;
import com.openexchange.tools.iterator.CombinedSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SessionHolder;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InfostoreFacadeImpl
extends DBService
implements InfostoreFacade {
    private static final ValidationChain VALIDATION = new ValidationChain();
    private static final InfostoreFilenameReserver filenameReserver;
    static final org.apache.commons.logging.Log LOG;
    private static final boolean INDEXING_ENABLED = false;
    public static final InfostoreQueryCatalog QUERIES;
    private final DatabaseImpl db = new DatabaseImpl();
    protected InfostoreSecurity security = new InfostoreSecurityImpl();
    private final EntityLockManager lockManager = new EntityLockManagerImpl("infostore_lock");
    private final ThreadLocal<List<String>> fileIdRemoveList = new ThreadLocal();
    private final ThreadLocal<Context> ctxHolder = new ThreadLocal();
    private final TouchInfoitemsWithExpiredLocksListener expiredLocksListener = new TouchInfoitemsWithExpiredLocksListener(null, this);
    private static final Pattern IS_NUMBERED_WITH_EXTENSION;
    private static final Pattern IS_NUMBERED;

    public InfostoreFacadeImpl() {
        this.lockManager.addExpiryListener(this.expiredLocksListener);
    }

    public InfostoreFacadeImpl(DBProvider provider) {
        this();
        this.setProvider(provider);
    }

    public void setSecurity(InfostoreSecurity security) {
        this.security = security;
        if (null != this.getProvider()) {
            this.setProvider(this.getProvider());
        }
    }

    @Override
    public boolean exists(int id, int version2, ServerSession session) throws OXException {
        try {
            return this.security.getInfostorePermission(id, session.getContext(), session.getUser(), session.getUserPermissionBits()).canReadObject();
        }
        catch (OXException x) {
            if (InfostoreExceptionCodes.NOT_EXIST.equals(x)) {
                return false;
            }
            throw x;
        }
    }

    @Override
    public DocumentMetadata getDocumentMetadata(int id, int version2, ServerSession session) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, session.getContext(), session.getUser(), session.getUserPermissionBits());
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        List<Lock> locks = this.lockManager.findLocks(id, session.getContext(), session.getUser());
        HashMap<Integer, List<Lock>> allLocks = new HashMap<Integer, List<Lock>>();
        allLocks.put(id, locks);
        return this.addNumberOfVersions(this.addLocked(this.load(id, version2, session.getContext()), allLocks, session.getContext(), session.getUser()), session.getContext());
    }

    DocumentMetadata load(int id, int version2, Context ctx) throws OXException {
        InfostoreIterator iter = InfostoreIterator.loadDocumentIterator(id, version2, this.getProvider(), ctx);
        if (!iter.hasNext()) {
            throw InfostoreExceptionCodes.DOCUMENT_NOT_EXIST.create();
        }
        DocumentMetadata dm = iter.next();
        iter.close();
        return dm;
    }

    @Override
    public void saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, ServerSession session) throws OXException {
        this.saveDocument(document, null, sequenceNumber, session);
    }

    @Override
    public void saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, Metadata[] modifiedColumns, ServerSession session) throws OXException {
        this.saveDocument(document, null, sequenceNumber, modifiedColumns, session);
    }

    @Override
    public InputStream getDocument(int id, int version2, ServerSession session) throws OXException {
        return this.getDocument(id, version2, 0L, -1L, session);
    }

    @Override
    public InputStream getDocument(int id, int version2, long offset, long length, ServerSession session) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, session.getContext(), session.getUser(), session.getUserPermissionBits());
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        DocumentMetadata dm = this.load(id, version2, session.getContext());
        QuotaFileStorage fs = this.getFileStorage(session.getContext());
        if (dm.getFilestoreLocation() == null) {
            return Streams.newByteArrayInputStream((byte[])new byte[0]);
        }
        if (0L == offset && -1L == length) {
            return ((FileStorage)fs).getFile(dm.getFilestoreLocation());
        }
        return ((FileStorage)fs).getFile(dm.getFilestoreLocation(), offset, length);
    }

    @Override
    public void lock(int id, long diff, ServerSession session) throws OXException {
        Context context = session.getContext();
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.WRITE_PERMS_FOR_LOCK_MISSING.create();
        }
        DocumentMetadata document = this.checkWriteLock(id, session);
        if (this.lockManager.isLocked(document.getId(), session.getContext(), InfostoreFacadeImpl.getUser(session))) {
            return;
        }
        long timeout = 0L;
        timeout = timeout == -1L ? -1L : diff;
        this.lockManager.lock(id, timeout, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, session.getUserlogin(), context, InfostoreFacadeImpl.getUser(session));
        this.touch(id, session);
    }

    @Override
    public void unlock(int id, ServerSession session) throws OXException {
        Context context = session.getContext();
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.WRITE_PERMS_FOR_UNLOCK_MISSING.create();
        }
        this.checkMayUnlock(id, session);
        this.lockManager.removeAll(id, context, InfostoreFacadeImpl.getUser(session));
        this.touch(id, session);
    }

    @Override
    public void touch(int id, ServerSession sessionObj) throws OXException {
        try {
            Context context = sessionObj.getContext();
            DocumentMetadata oldDocument = this.load(id, -1, context);
            DocumentMetadataImpl document = new DocumentMetadataImpl(oldDocument);
            document.setLastModified(new Date());
            document.setModifiedBy(sessionObj.getUserId());
            UpdateDocumentAction updateDocument = new UpdateDocumentAction();
            updateDocument.setContext(context);
            updateDocument.setDocuments(Arrays.asList(document));
            updateDocument.setModified(Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL);
            updateDocument.setOldDocuments(Arrays.asList(oldDocument));
            updateDocument.setProvider(this);
            updateDocument.setQueryCatalog(QUERIES);
            updateDocument.setTimestamp(oldDocument.getSequenceNumber());
            this.perform(updateDocument, true);
            UpdateVersionAction updateVersion = new UpdateVersionAction();
            updateVersion.setContext(context);
            updateVersion.setDocuments(Arrays.asList(document));
            updateVersion.setModified(Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL);
            updateVersion.setOldDocuments(Arrays.asList(oldDocument));
            updateVersion.setProvider(this);
            updateVersion.setQueryCatalog(QUERIES);
            updateVersion.setTimestamp(oldDocument.getSequenceNumber());
            this.perform(updateVersion, true);
        }
        catch (OXException x) {
            throw x;
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public com.openexchange.file.storage.Quota getFileQuota(ServerSession session) throws OXException {
        Quota quota;
        long limit = -1L;
        long usage = -1L;
        QuotaService quotaService = ServerServiceRegistry.getInstance().getService(QuotaService.class);
        if (null != quotaService && null != (quota = quotaService.getQuotaFor(Resource.INFOSTORE_FILES, (Session)session)) && -1L != (limit = quota.getQuota(QuotaType.AMOUNT))) {
            usage = this.getUsedQuota(session.getContext());
        }
        return new com.openexchange.file.storage.Quota(limit, usage, Quota.Type.FILE);
    }

    @Override
    public com.openexchange.file.storage.Quota getStorageQuota(ServerSession session) throws OXException {
        long limit = -1L;
        long usage = -1L;
        try {
            limit = this.getFileStorage(session.getContext()).getQuota();
        }
        catch (OXException e) {
            LOG.warn((Object)("Error getting file storage quota for context " + session.getContextId()), (Throwable)e);
        }
        if (-1L != limit) {
            usage = this.getFileStorage(session.getContext()).getUsage();
        }
        return new com.openexchange.file.storage.Quota(limit, usage, Quota.Type.STORAGE);
    }

    private Delta<DocumentMetadata> addLocked(Delta<DocumentMetadata> delta, Map<Integer, List<Lock>> locks, Context ctx, User user) throws OXException {
        try {
            return new LockDelta(delta, locks, ctx, user);
        }
        catch (OXException e) {
            throw InfostoreExceptionCodes.ITERATE_FAILED.create(e, new Object[0]);
        }
    }

    private Delta<DocumentMetadata> addNumberOfVersions(Delta<DocumentMetadata> delta, Context ctx) throws OXException {
        try {
            return new NumberOfVersionsDelta(delta, ctx);
        }
        catch (OXException e) {
            throw InfostoreExceptionCodes.ITERATE_FAILED.create(e, new Object[0]);
        }
    }

    private TimedResult<DocumentMetadata> addNumberOfVersions(TimedResult<DocumentMetadata> tr, Context ctx) throws OXException {
        return new NumberOfVersionsTimedResult(tr, ctx);
    }

    private TimedResult<DocumentMetadata> addLocked(TimedResult<DocumentMetadata> tr, Context ctx, User user) throws OXException {
        try {
            return new LockTimedResult(tr, ctx, user);
        }
        catch (OXException e) {
            throw InfostoreExceptionCodes.ITERATE_FAILED.create(e, new Object[0]);
        }
    }

    private DocumentMetadata addNumberOfVersions(final DocumentMetadata document, Context ctx) throws OXException {
        try {
            return this.performQuery(ctx, QUERIES.getNumberOfVersionsQueryForOneDocument(), new ResultProcessor<DocumentMetadata>(){

                @Override
                public DocumentMetadata process(ResultSet rs) throws SQLException {
                    if (!rs.next()) {
                        LOG.error((Object)"Infoitem disappeared when trying to count versions");
                        return document;
                    }
                    int numberOfVersions = rs.getInt(1);
                    document.setNumberOfVersions(--numberOfVersions);
                    return document;
                }
            }, document.getId(), ctx.getContextId());
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw InfostoreExceptionCodes.NUMBER_OF_VERSIONS_FAILED.create(e, Autoboxing.I((int)document.getId()), Autoboxing.I((int)ctx.getContextId()), QUERIES.getNumberOfVersionsQueryForOneDocument());
        }
    }

    private DocumentMetadata addLocked(DocumentMetadata document, Map<Integer, List<Lock>> allLocks, Context ctx, User user) throws OXException {
        List<Lock> locks = null;
        locks = allLocks != null ? allLocks.get(document.getId()) : this.lockManager.findLocks(document.getId(), ctx, user);
        if (locks == null) {
            locks = Collections.emptyList();
        }
        long max = 0L;
        for (Lock l : locks) {
            if (l.getTimeout() <= max) continue;
            max = l.getTimeout();
        }
        if (max > 0L) {
            document.setLockedUntil(new Date(System.currentTimeMillis() + max));
        }
        return document;
    }

    SearchIterator<DocumentMetadata> numberOfVersionsIterator(SearchIterator<?> iter, Context ctx) throws OXException {
        ArrayList<DocumentMetadata> list = new ArrayList<DocumentMetadata>();
        while (iter.hasNext()) {
            DocumentMetadata m = (DocumentMetadata)iter.next();
            list.add(m);
        }
        for (DocumentMetadata m : list) {
            this.addNumberOfVersions(m, ctx);
        }
        return new SearchIteratorAdapter(list.iterator());
    }

    SearchIterator<DocumentMetadata> lockedUntilIterator(SearchIterator<?> iter, Map<Integer, List<Lock>> locks, Context ctx, User user) throws OXException {
        ArrayList<DocumentMetadata> list = new ArrayList<DocumentMetadata>();
        while (iter.hasNext()) {
            DocumentMetadata m = (DocumentMetadata)iter.next();
            list.add(m);
        }
        for (DocumentMetadata m : list) {
            this.addLocked(m, locks, ctx, user);
        }
        return new SearchIteratorAdapter(list.iterator());
    }

    private DocumentMetadata checkWriteLock(int id, ServerSession session) throws OXException {
        DocumentMetadata document = this.load(id, -1, session.getContext());
        this.checkWriteLock(document, session);
        return document;
    }

    private void checkWriteLock(DocumentMetadata document, ServerSession session) throws OXException {
        if (document.getModifiedBy() == session.getUserId()) {
            return;
        }
        if (this.lockManager.isLocked(document.getId(), session.getContext(), InfostoreFacadeImpl.getUser(session))) {
            throw InfostoreExceptionCodes.ALREADY_LOCKED.create();
        }
    }

    private void checkMayUnlock(int id, ServerSession session) throws OXException {
        DocumentMetadata document = this.load(id, -1, session.getContext());
        if (document.getCreatedBy() == session.getUserId() || document.getModifiedBy() == session.getUserId()) {
            return;
        }
        List<Lock> locks = this.lockManager.findLocks(id, session.getContext(), InfostoreFacadeImpl.getUser(session));
        if (locks.size() > 0) {
            throw InfostoreExceptionCodes.LOCKED_BY_ANOTHER.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, ServerSession session) throws OXException {
        Context context = session.getContext();
        this.security.checkFolderId(document.getFolderId(), context);
        boolean wasCreation = false;
        if (document.getId() == -1) {
            long used;
            Quota quota;
            long quotaValue;
            wasCreation = true;
            EffectivePermission isperm = this.security.getFolderPermission(document.getFolderId(), context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
            if (!isperm.canCreateObjects()) {
                throw InfostoreExceptionCodes.NO_CREATE_PERMISSION.create();
            }
            QuotaService quotaService = ServerServiceRegistry.getInstance().getService(QuotaService.class);
            if (null != quotaService && (quotaValue = (quota = quotaService.getQuotaFor(Resource.INFOSTORE_FILES, (Session)session)).getQuota(QuotaType.AMOUNT)) > 0L && (used = this.getUsedQuota(context)) > 0L && used >= quotaValue) {
                throw QuotaExceptionCodes.QUOTA_EXCEEDED.create();
            }
            this.setDefaults(document);
            VALIDATION.validate(document);
            CheckSizeSwitch.checkSizes(document, this.getProvider(), context);
            boolean titleAlso = document.getFileName() != null && document.getTitle() != null && document.getFileName().equals(document.getTitle());
            InfostoreFilenameReservation reservation = this.reserve(document.getFileName(), document.getFolderId(), document.getId(), context, true);
            document.setFileName(reservation.getFilename());
            if (titleAlso) {
                document.setTitle(reservation.getFilename());
            }
            try {
                Connection writeCon = null;
                try {
                    this.startDBTransaction();
                    writeCon = this.getWriteConnection(context);
                    document.setId(this.getId(context, writeCon));
                    this.commitDBTransaction();
                }
                catch (SQLException e) {
                    throw InfostoreExceptionCodes.NEW_ID_FAILED.create(e, new Object[0]);
                }
                finally {
                    this.releaseWriteConnection(context, writeCon);
                    this.finishDBTransaction();
                }
                Date now = new Date();
                if (null == document.getLastModified()) {
                    document.setLastModified(now);
                }
                if (null == document.getCreationDate()) {
                    document.setCreationDate(now);
                }
                document.setCreatedBy(session.getUserId());
                document.setModifiedBy(session.getUserId());
                if (null != data) {
                    document.setVersion(1);
                } else {
                    document.setVersion(0);
                }
                CreateDocumentAction createAction = new CreateDocumentAction();
                createAction.setContext(context);
                createAction.setDocuments(Arrays.asList(document));
                createAction.setProvider(this);
                createAction.setQueryCatalog(QUERIES);
                this.perform(createAction, true);
                DocumentMetadataImpl version0 = new DocumentMetadataImpl(document);
                version0.setFileName(null);
                version0.setFileSize(0L);
                version0.setFileMD5Sum(null);
                version0.setFileMIMEType(null);
                version0.setVersion(0);
                version0.setFilestoreLocation(null);
                CreateVersionAction createVersionAction = new CreateVersionAction();
                createVersionAction.setContext(context);
                createVersionAction.setDocuments(Arrays.asList(version0));
                createVersionAction.setProvider(this);
                createVersionAction.setQueryCatalog(QUERIES);
                this.perform(createVersionAction, true);
                if (data != null) {
                    SaveFileAction saveFile = new SaveFileAction(this.getFileStorage(context), data, document.getFileSize());
                    this.perform(saveFile, false);
                    document.setVersion(1);
                    document.setFilestoreLocation(saveFile.getFileStorageID());
                    document.setFileMD5Sum(saveFile.getChecksum());
                    document.setFileSize(saveFile.getByteCount());
                    createVersionAction = new CreateVersionAction();
                    createVersionAction.setContext(context);
                    createVersionAction.setDocuments(Arrays.asList(document));
                    createVersionAction.setProvider(this);
                    createVersionAction.setQueryCatalog(QUERIES);
                    this.perform(createVersionAction, true);
                }
                this.indexDocument(context, session.getUserId(), document.getId(), -1L, wasCreation);
            }
            finally {
                if (reservation != null) {
                    reservation.destroySilently();
                }
            }
        }
        this.saveDocument(document, data, sequenceNumber, this.nonNull(document), session);
    }

    private long getUsedQuota(Context context) throws OXException {
        long l;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(context);
            stmt = readCon.prepareStatement("SELECT COUNT(id) from infostore where cid=?");
            stmt.setLong(1, context.getContextId());
            rs = stmt.executeQuery();
            l = rs.next() ? rs.getLong(1) : -1L;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                if (null != readCon) {
                    this.releaseReadConnection(context, readCon);
                }
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (null != readCon) {
            this.releaseReadConnection(context, readCon);
        }
        return l;
    }

    private void setDefaults(DocumentMetadata document) {
        if (document.getTitle() == null || "".equals(document.getTitle())) {
            document.setTitle(document.getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T performQuery(Context ctx, String query, ResultProcessor<T> rsp, Object ... args) throws SQLException, OXException {
        T t;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            rs = stmt.executeQuery();
            t = rsp.process(rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            if (readCon != null) {
                this.releaseReadConnection(ctx, readCon);
            }
            throw throwable;
        }
        this.close(stmt, rs);
        if (readCon != null) {
            this.releaseReadConnection(ctx, readCon);
        }
        return t;
    }

    private int getNextVersionNumberForInfostoreObject(int cid, int infostore_id, Connection con) throws SQLException {
        int delVersion;
        int retval = 0;
        PreparedStatement stmt = con.prepareStatement("SELECT MAX(version_number) FROM infostore_document WHERE cid=? AND infostore_id=?");
        stmt.setInt(1, cid);
        stmt.setInt(2, infostore_id);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            retval = result.getInt(1);
        }
        result.close();
        stmt.close();
        stmt = con.prepareStatement("SELECT MAX(version_number) FROM del_infostore_document WHERE cid=? AND infostore_id=?");
        stmt.setInt(1, cid);
        stmt.setInt(2, infostore_id);
        result = stmt.executeQuery();
        if (result.next() && (delVersion = result.getInt(1)) > retval) {
            retval = delVersion;
        }
        result.close();
        stmt.close();
        return retval + 1;
    }

    private InfostoreFilenameReservation reserve(String filename, long folderId, int id, Context ctx, boolean adjust) throws OXException {
        return this.reserve(filename, folderId, id, ctx, adjust ? 0 : -1);
    }

    private InfostoreFilenameReservation reserve(String filename, long folderId, int id, Context ctx, int count) throws OXException {
        InfostoreFilenameReservation reservation = null;
        try {
            reservation = filenameReserver.reserveFilename(filename, folderId, id, ctx, this);
            if (reservation == null) {
                if (count == -1) {
                    throw InfostoreExceptionCodes.FILENAME_NOT_UNIQUE.create(filename, "");
                }
                int cnt = count;
                InfostoreFilenameReservation r = this.reserve(this.enhance(filename, ++cnt), folderId, id, ctx, cnt);
                r.setWasAdjusted(true);
                return r;
            }
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, "");
        }
        return reservation;
    }

    private String enhance(String filename, int c) {
        StringBuilder stringBuilder = new StringBuilder(filename);
        Matcher matcher = IS_NUMBERED_WITH_EXTENSION.matcher(filename);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            stringBuilder.replace(start, end - 1, "(" + c + ")");
            return stringBuilder.toString();
        }
        matcher = IS_NUMBERED.matcher(filename);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            stringBuilder.replace(start, end, "(" + c + ")");
            return stringBuilder.toString();
        }
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            index = filename.length();
        }
        stringBuilder.insert(index, "(" + c + ")");
        return stringBuilder.toString();
    }

    protected QuotaFileStorage getFileStorage(Context ctx) throws OXException {
        return QuotaFileStorage.getInstance(FilestoreStorage.createURI(ctx), ctx);
    }

    private Metadata[] nonNull(DocumentMetadata document) {
        ArrayList<Metadata> nonNull = new ArrayList<Metadata>();
        GetSwitch get = new GetSwitch(document);
        for (Metadata metadata : Metadata.HTTPAPI_VALUES) {
            if (null == metadata.doSwitch(get)) continue;
            nonNull.add(metadata);
        }
        return nonNull.toArray(new Metadata[nonNull.size()]);
    }

    @Override
    public void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, ServerSession session) throws OXException {
        this.saveDocument(document, data, sequenceNumber, modifiedColumns, false, session);
    }

    @Override
    public void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, boolean ignoreVersion, ServerSession session) throws OXException {
        this.saveDocument(document, data, sequenceNumber, modifiedColumns, ignoreVersion, -1L, session);
    }

    @Override
    public void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, long offset, ServerSession session) throws OXException {
        this.saveDocument(document, data, sequenceNumber, modifiedColumns, true, offset, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, boolean ignoreVersion, long offset, ServerSession session) throws OXException {
        if (!(0L >= offset || -1 != document.getId() && ignoreVersion)) {
            throw InfostoreExceptionCodes.NO_OFFSET_FOR_NEW_VERSIONS.create();
        }
        if (document.getId() == -1) {
            this.saveDocument(document, data, sequenceNumber, session);
            this.indexDocument(session.getContext(), session.getUserId(), document.getId(), -1L, true);
            return;
        }
        Context context = session.getContext();
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(document.getId(), context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.NO_WRITE_PERMISSION.create();
        }
        if (Arrays.asList(modifiedColumns).contains(Metadata.FOLDER_ID_LITERAL) && document.getFolderId() != -1L && infoPerm.getObject().getFolderId() != document.getFolderId()) {
            this.security.checkFolderId(document.getFolderId(), context);
            EffectivePermission isperm = this.security.getFolderPermission(document.getFolderId(), context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
            if (!isperm.canCreateObjects()) {
                throw InfostoreExceptionCodes.NO_TARGET_CREATE_PERMISSION.create();
            }
            if (!infoPerm.canDeleteObject()) {
                throw InfostoreExceptionCodes.NO_SOURCE_DELETE_PERMISSION.create();
            }
        }
        CheckSizeSwitch.checkSizes(document, this.getProvider(), context);
        DocumentMetadata oldDocument = this.checkWriteLock(document.getId(), session);
        Metadata[] modifiedCols = modifiedColumns;
        HashSet<Metadata> updatedCols = new HashSet<Metadata>(Arrays.asList(modifiedCols));
        if (!updatedCols.contains(Metadata.LAST_MODIFIED_LITERAL)) {
            document.setLastModified(new Date());
        }
        document.setModifiedBy(session.getUserId());
        VALIDATION.validate(document);
        updatedCols.add(Metadata.LAST_MODIFIED_LITERAL);
        updatedCols.add(Metadata.MODIFIED_BY_LITERAL);
        ArrayList<InfostoreFilenameReservation> reservations = new ArrayList<InfostoreFilenameReservation>(2);
        try {
            if (updatedCols.contains(Metadata.VERSION_LITERAL)) {
                String fname = this.load(document.getId(), document.getVersion(), context).getFileName();
                if (!updatedCols.contains(Metadata.FILENAME_LITERAL)) {
                    updatedCols.add(Metadata.FILENAME_LITERAL);
                    document.setFileName(fname);
                }
            }
            String oldFileName = oldDocument.getFileName();
            if (updatedCols.contains(Metadata.FOLDER_ID_LITERAL) && oldDocument.getFolderId() != document.getFolderId()) {
                String fileName = null != document.getFileName() ? document.getFileName() : oldFileName;
                InfostoreFilenameReservation reservation = this.reserve(fileName, document.getFolderId(), oldDocument.getId(), context, true);
                reservations.add(reservation);
                document.setFileName(reservation.getFilename());
                updatedCols.add(Metadata.FILENAME_LITERAL);
            } else if (updatedCols.contains(Metadata.FILENAME_LITERAL) && null != document.getFileName() && !document.getFileName().equals(oldFileName)) {
                InfostoreFilenameReservation reservation = this.reserve(document.getFileName(), oldDocument.getFolderId(), oldDocument.getId(), context, true);
                reservations.add(reservation);
                document.setFileName(reservation.getFilename());
                updatedCols.add(Metadata.FILENAME_LITERAL);
            }
            String oldTitle = oldDocument.getTitle();
            if (!updatedCols.contains(Metadata.TITLE_LITERAL) && oldFileName != null && oldTitle != null && oldFileName.equals(oldTitle)) {
                String fileName = document.getFileName();
                if (null == fileName) {
                    document.setTitle(oldFileName);
                    document.setFileName(oldFileName);
                    updatedCols.add(Metadata.FILENAME_LITERAL);
                } else {
                    document.setTitle(fileName);
                }
                updatedCols.add(Metadata.TITLE_LITERAL);
            }
            modifiedCols = updatedCols.toArray(new Metadata[updatedCols.size()]);
            if (data != null) {
                AbstractDocumentListAction action;
                QuotaFileStorage qfs = this.getFileStorage(context);
                if (0L < offset) {
                    AppendFileAction appendFile = new AppendFileAction(qfs, data, oldDocument.getFilestoreLocation(), document.getFileSize(), offset);
                    this.perform(appendFile, false);
                    document.setFilestoreLocation(oldDocument.getFilestoreLocation());
                    document.setFileSize(appendFile.getByteCount() + offset);
                    document.setFileMD5Sum(null);
                    updatedCols.addAll(Arrays.asList(Metadata.FILE_MD5SUM_LITERAL, Metadata.FILE_SIZE_LITERAL));
                } else {
                    SaveFileAction saveFile = new SaveFileAction(qfs, data, document.getFileSize());
                    this.perform(saveFile, false);
                    document.setFilestoreLocation(saveFile.getFileStorageID());
                    document.setFileSize(saveFile.getByteCount());
                    document.setFileMD5Sum(saveFile.getChecksum());
                    updatedCols.addAll(Arrays.asList(Metadata.FILE_MD5SUM_LITERAL, Metadata.FILE_SIZE_LITERAL, Metadata.FILESTORE_LOCATION_LITERAL));
                }
                GetSwitch get = new GetSwitch(oldDocument);
                SetSwitch set = new SetSwitch(document);
                HashSet<Metadata> alreadySet = new HashSet<Metadata>(Arrays.asList(modifiedCols));
                for (Metadata m : Arrays.asList(Metadata.DESCRIPTION_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL)) {
                    if (alreadySet.contains(m)) continue;
                    set.setValue(m.doSwitch(get));
                    m.doSwitch(set);
                }
                document.setCreatedBy(session.getUserId());
                if (!updatedCols.contains(Metadata.CREATION_DATE_LITERAL)) {
                    document.setCreationDate(new Date());
                }
                if (ignoreVersion) {
                    document.setVersion(oldDocument.getVersion());
                    updatedCols.add(Metadata.VERSION_LITERAL);
                    updatedCols.add(Metadata.FILESTORE_LOCATION_LITERAL);
                    UpdateVersionAction updateVersionAction = new UpdateVersionAction();
                    updateVersionAction.setContext(context);
                    updateVersionAction.setDocuments(Arrays.asList(document));
                    updateVersionAction.setOldDocuments(Arrays.asList(oldDocument));
                    updateVersionAction.setProvider(this);
                    updateVersionAction.setQueryCatalog(QUERIES);
                    updateVersionAction.setModified(updatedCols.toArray(new Metadata[updatedCols.size()]));
                    updateVersionAction.setTimestamp(sequenceNumber);
                    if (0L >= offset) {
                        this.removeFile(context, oldDocument.getFilestoreLocation());
                    }
                    action = updateVersionAction;
                } else {
                    Connection con = null;
                    try {
                        con = this.getReadConnection(context);
                        document.setVersion(this.getNextVersionNumberForInfostoreObject(context.getContextId(), document.getId(), con));
                        updatedCols.add(Metadata.VERSION_LITERAL);
                    }
                    catch (SQLException e) {
                        LOG.error((Object)"SQLException: ", (Throwable)e);
                    }
                    finally {
                        this.releaseReadConnection(context, con);
                    }
                    CreateVersionAction createVersionAction = new CreateVersionAction();
                    createVersionAction.setContext(context);
                    createVersionAction.setDocuments(Arrays.asList(document));
                    createVersionAction.setProvider(this);
                    createVersionAction.setQueryCatalog(QUERIES);
                    action = createVersionAction;
                }
                this.perform(action, true);
            } else if (QUERIES.updateVersion(modifiedCols)) {
                if (!updatedCols.contains(Metadata.VERSION_LITERAL)) {
                    document.setVersion(oldDocument.getVersion());
                }
                UpdateVersionAction updateVersionAction = new UpdateVersionAction();
                updateVersionAction.setContext(context);
                updateVersionAction.setDocuments(Arrays.asList(document));
                updateVersionAction.setOldDocuments(Arrays.asList(oldDocument));
                updateVersionAction.setProvider(this);
                updateVersionAction.setQueryCatalog(QUERIES);
                updateVersionAction.setModified(modifiedCols);
                updateVersionAction.setTimestamp(sequenceNumber);
                this.perform(updateVersionAction, true);
            }
            modifiedCols = updatedCols.toArray(new Metadata[updatedCols.size()]);
            if (QUERIES.updateDocument(modifiedCols)) {
                UpdateDocumentAction updateAction = new UpdateDocumentAction();
                updateAction.setContext(context);
                updateAction.setDocuments(Arrays.asList(document));
                updateAction.setOldDocuments(Arrays.asList(oldDocument));
                updateAction.setProvider(this);
                updateAction.setQueryCatalog(QUERIES);
                updateAction.setModified(modifiedCols);
                updateAction.setTimestamp(Long.MAX_VALUE);
                this.perform(updateAction, true);
            }
            if (updatedCols.contains(Metadata.FOLDER_ID_LITERAL) && oldDocument.getFolderId() != document.getFolderId()) {
                DocumentMetadataImpl tombstoneDocument = new DocumentMetadataImpl(oldDocument);
                tombstoneDocument.setLastModified(document.getLastModified());
                tombstoneDocument.setModifiedBy(document.getModifiedBy());
                ReplaceDocumentIntoDelTableAction tombstoneAction = new ReplaceDocumentIntoDelTableAction();
                tombstoneAction.setContext(context);
                tombstoneAction.setDocuments(Arrays.asList(tombstoneDocument));
                tombstoneAction.setProvider(this);
                tombstoneAction.setQueryCatalog(QUERIES);
                this.perform(tombstoneAction, true);
            }
            long indexFolderId = document.getFolderId() == oldDocument.getFolderId() ? -1L : oldDocument.getFolderId();
            this.indexDocument(context, session.getUserId(), oldDocument.getId(), indexFolderId, false);
        }
        finally {
            for (InfostoreFilenameReservation infostoreFilenameReservation : reservations) {
                infostoreFilenameReservation.destroySilently();
            }
        }
    }

    @Override
    public void removeDocument(long folderId, long date, ServerSession session) throws OXException {
        ReuseReadConProvider reuseProvider = new ReuseReadConProvider(this.getProvider());
        List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere("infostore.folder_id = " + folderId, Metadata.VALUES_ARRAY, reuseProvider, session.getContext()).asList();
        List<DocumentMetadata> allDocuments = InfostoreIterator.allDocumentsWhere("infostore.folder_id = " + folderId, Metadata.VALUES_ARRAY, reuseProvider, session.getContext()).asList();
        this.removeDocuments(allDocuments, allVersions, date, session, null);
    }

    protected void removeDocuments(List<DocumentMetadata> allDocuments, List<DocumentMetadata> allVersions, long date, ServerSession sessionObj, List<DocumentMetadata> rejected) throws OXException {
        ArrayList<DocumentMetadata> delDocs = new ArrayList<DocumentMetadata>();
        ArrayList<DocumentMetadata> delVers = new ArrayList<DocumentMetadata>();
        HashSet<Integer> rejectedIds = new HashSet<Integer>();
        Date now = new Date();
        for (DocumentMetadata m : allDocuments) {
            if (m.getSequenceNumber() > date) {
                if (rejected == null) {
                    throw InfostoreExceptionCodes.NOT_ALL_DELETED.create();
                }
                rejected.add(m);
                rejectedIds.add(m.getId());
                continue;
            }
            this.checkWriteLock(m, sessionObj);
            m.setLastModified(now);
            delDocs.add(m);
        }
        Context context = sessionObj.getContext();
        ReplaceDocumentIntoDelTableAction replaceIntoDel = new ReplaceDocumentIntoDelTableAction();
        replaceIntoDel.setContext(context);
        replaceIntoDel.setDocuments(delDocs);
        replaceIntoDel.setProvider(this);
        replaceIntoDel.setQueryCatalog(QUERIES);
        this.perform(replaceIntoDel, true);
        ArrayList<String> filestoreLocations = new ArrayList<String>(allVersions.size());
        for (DocumentMetadata m : allVersions) {
            if (rejectedIds.contains(m.getId())) continue;
            delVers.add(m);
            m.setLastModified(now);
            if (null == m.getFilestoreLocation()) continue;
            filestoreLocations.add(m.getFilestoreLocation());
        }
        this.removeFiles(context, filestoreLocations);
        DeleteDocumentAction deleteDocument = new DeleteDocumentAction();
        deleteDocument.setContext(context);
        deleteDocument.setDocuments(delDocs);
        deleteDocument.setProvider(this);
        deleteDocument.setQueryCatalog(QUERIES);
        this.perform(deleteDocument, true);
        this.removeFromIndex(context, sessionObj.getUserId(), delDocs);
        this.removeFromIndex(context, sessionObj.getUserId(), delVers);
    }

    private void removeFile(Context context, String filestoreLocation) throws OXException {
        if (filestoreLocation == null) {
            return;
        }
        if (this.fileIdRemoveList.get() != null) {
            this.fileIdRemoveList.get().add(filestoreLocation);
            this.ctxHolder.set(context);
        } else {
            QuotaFileStorage qfs = this.getFileStorage(context);
            qfs.deleteFile(filestoreLocation);
        }
    }

    private void removeFiles(Context context, List<String> filestoreLocations) throws OXException {
        if (null != filestoreLocations && 0 < filestoreLocations.size()) {
            List<String> removeList = this.fileIdRemoveList.get();
            if (null != removeList) {
                removeList.addAll(filestoreLocations);
                this.ctxHolder.set(context);
            } else {
                this.getFileStorage(context).deleteFiles(filestoreLocations.toArray(new String[filestoreLocations.size()]));
            }
        }
    }

    @Override
    public int[] removeDocument(int[] ids, long date, ServerSession session) throws OXException {
        StringBuilder sIds = new StringBuilder().append('(');
        for (int i : ids) {
            sIds.append(i).append(',');
        }
        sIds.setLength(sIds.length() - 1);
        sIds.append(')');
        List<DocumentMetadata> allVersions = null;
        List<DocumentMetadata> allDocuments = null;
        Context context = session.getContext();
        ReuseReadConProvider reuseProvider = new ReuseReadConProvider(this.getProvider());
        try {
            allVersions = InfostoreIterator.allVersionsWhere("infostore.id IN " + sIds.toString(), Metadata.VALUES_ARRAY, reuseProvider, context).asList();
            allDocuments = InfostoreIterator.allDocumentsWhere("infostore.id IN " + sIds.toString(), Metadata.VALUES_ARRAY, reuseProvider, context).asList();
        }
        catch (OXException x) {
            throw x;
        }
        catch (Throwable t) {
            LOG.error((Object)"Unexpected Error:", t);
        }
        ArrayList<DocumentMetadata> rejected = new ArrayList<DocumentMetadata>();
        HashSet rejectedIds = new HashSet();
        HashSet<Integer> idSet = new HashSet<Integer>();
        for (int i : ids) {
            idSet.add(i);
        }
        TLongObjectHashMap perms = new TLongObjectHashMap();
        ArrayList<DocumentMetadata> toDeleteDocs = new ArrayList<DocumentMetadata>();
        ArrayList<DocumentMetadata> toDeleteVersions = new ArrayList<DocumentMetadata>();
        if (allDocuments != null) {
            for (DocumentMetadata m : allDocuments) {
                EffectiveInfostorePermission infoPerm;
                idSet.remove(m.getId());
                EffectivePermission p = (EffectivePermission)perms.get(m.getFolderId());
                if (p == null) {
                    p = this.security.getFolderPermission(m.getFolderId(), context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
                    perms.put(m.getFolderId(), (Object)p);
                }
                if (!(infoPerm = new EffectiveInfostorePermission(p, m, InfostoreFacadeImpl.getUser(session))).canDeleteObject()) {
                    throw InfostoreExceptionCodes.NO_DELETE_PERMISSION.create();
                }
                toDeleteDocs.add(m);
            }
        }
        if (allVersions != null) {
            for (DocumentMetadata m : allVersions) {
                if (rejectedIds.contains(m.getId())) continue;
                toDeleteVersions.add(m);
            }
        }
        this.removeDocuments(toDeleteDocs, toDeleteVersions, date, session, rejected);
        int[] nd = new int[rejected.size() + idSet.size()];
        int i = 0;
        for (DocumentMetadata rej : rejected) {
            nd[i++] = rej.getId();
        }
        Iterator i$ = idSet.iterator();
        while (i$.hasNext()) {
            int notFound = (Integer)i$.next();
            nd[i++] = notFound;
        }
        return nd;
    }

    @Override
    public int[] removeVersion(int id, int[] versionIds, ServerSession session) throws OXException {
        if (versionIds.length <= 0) {
            return versionIds;
        }
        Context context = session.getContext();
        DocumentMetadata metadata = this.load(id, -1, context);
        try {
            this.checkWriteLock(metadata, session);
        }
        catch (OXException x) {
            return versionIds;
        }
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(metadata, context, InfostoreFacadeImpl.getUser(session), session.getUserPermissionBits());
        if (!infoPerm.canDeleteObject()) {
            throw InfostoreExceptionCodes.NO_DELETE_PERMISSION_FOR_VERSION.create();
        }
        StringBuilder versions = new StringBuilder().append('(');
        HashSet<Integer> versionSet = new HashSet<Integer>();
        for (int v : versionIds) {
            versions.append(v).append(',');
            versionSet.add(v);
        }
        versions.setLength(versions.length() - 1);
        versions.append(')');
        List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere("infostore_document.infostore_id = " + id + " AND infostore_document.version_number IN " + versions.toString() + " and infostore_document.version_number != 0 ", Metadata.VALUES_ARRAY, this, context).asList();
        Date now = new Date();
        boolean removeCurrent = false;
        for (DocumentMetadata v : allVersions) {
            if (v.getVersion() == metadata.getVersion()) {
                removeCurrent = true;
            }
            versionSet.remove(v.getVersion());
            v.setLastModified(now);
            this.removeFile(context, v.getFilestoreLocation());
        }
        DocumentMetadataImpl update = new DocumentMetadataImpl(metadata);
        update.setLastModified(now);
        update.setModifiedBy(session.getUserId());
        HashSet<Metadata> updatedFields = new HashSet<Metadata>();
        updatedFields.add(Metadata.LAST_MODIFIED_LITERAL);
        updatedFields.add(Metadata.MODIFIED_BY_LITERAL);
        if (removeCurrent) {
            DocumentMetadata oldVersion0 = this.load(id, 0, context);
            DocumentMetadataImpl version0 = new DocumentMetadataImpl(metadata);
            version0.setVersion(0);
            version0.setFileMIMEType("");
            UpdateVersionAction updateVersion = new UpdateVersionAction();
            updateVersion.setContext(context);
            updateVersion.setDocuments(Arrays.asList(version0));
            updateVersion.setModified(Metadata.DESCRIPTION_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.FILE_MIMETYPE_LITERAL);
            updateVersion.setOldDocuments(Arrays.asList(oldVersion0));
            updateVersion.setProvider(this);
            updateVersion.setQueryCatalog(QUERIES);
            updateVersion.setTimestamp(Long.MAX_VALUE);
            this.perform(updateVersion, true);
            update.setVersion(this.db.getMaxActiveVersion(metadata.getId(), context, allVersions));
            updatedFields.add(Metadata.VERSION_LITERAL);
        }
        if (removeCurrent) {
            InfostoreFilenameReservation reservation = this.reserve((metadata = this.load(metadata.getId(), update.getVersion(), context)).getFileName(), metadata.getFolderId(), metadata.getId(), context, true);
            if (reservation.wasAdjusted()) {
                update.setFileName(reservation.getFilename());
                updatedFields.add(Metadata.FILENAME_LITERAL);
            }
            if (metadata.getTitle().equals(metadata.getFileName())) {
                update.setTitle(update.getFileName());
                updatedFields.add(Metadata.TITLE_LITERAL);
            }
        }
        UpdateDocumentAction updateDocument = new UpdateDocumentAction();
        updateDocument.setContext(context);
        updateDocument.setDocuments(Arrays.asList(update));
        updateDocument.setModified(updatedFields.toArray(new Metadata[updatedFields.size()]));
        updateDocument.setOldDocuments(Arrays.asList(metadata));
        updateDocument.setProvider(this);
        updateDocument.setQueryCatalog(QUERIES);
        updateDocument.setTimestamp(Long.MAX_VALUE);
        this.perform(updateDocument, true);
        DeleteVersionAction deleteVersion = new DeleteVersionAction();
        deleteVersion.setContext(context);
        deleteVersion.setDocuments(allVersions);
        deleteVersion.setProvider(this);
        deleteVersion.setQueryCatalog(QUERIES);
        this.perform(deleteVersion, true);
        int[] retval = new int[versionSet.size()];
        int i = 0;
        for (Integer integer : versionSet) {
            retval[i++] = integer;
        }
        if (removeCurrent) {
            this.removeFromIndex(context, session.getUserId(), Collections.singletonList(metadata));
            this.indexDocument(context, session.getUserId(), id, -1L, true);
        }
        return retval;
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, ServerSession session) throws OXException {
        return this.getDocuments(folderId, Metadata.HTTPAPI_VALUES_ARRAY, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, ServerSession session) throws OXException {
        return this.getDocuments(folderId, columns, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Metadata sort, int order, ServerSession session) throws OXException {
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        boolean onlyOwn = false;
        EffectivePermission isperm = this.security.getFolderPermission(folderId, session.getContext(), session.getUser(), session.getUserPermissionBits());
        if (isperm.getReadPermission() == 0) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (isperm.getReadPermission() == 2) {
            onlyOwn = true;
        }
        boolean addLocked = false;
        boolean addNumberOfVersions = false;
        for (Metadata m : cols) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                addLocked = true;
                break;
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            addNumberOfVersions = true;
            break;
        }
        InfostoreIterator iter = null;
        iter = onlyOwn ? InfostoreIterator.documentsByCreator(folderId, session.getUser().getId(), cols, sort, order, this.getProvider(), session.getContext()) : InfostoreIterator.documents(folderId, cols, sort, order, this.getProvider(), session.getContext());
        TimedResult<DocumentMetadata> tr = new TimedResult<DocumentMetadata>((SearchIterator<DocumentMetadata>)iter);
        if (addLocked) {
            tr = this.addLocked(tr, session.getContext(), session.getUser());
        }
        if (addNumberOfVersions) {
            tr = this.addNumberOfVersions(tr, session.getContext());
        }
        return tr;
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, ServerSession session) throws OXException {
        return this.getVersions(id, Metadata.HTTPAPI_VALUES_ARRAY, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, ServerSession session) throws OXException {
        return this.getVersions(id, columns, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, Metadata sort, int order, ServerSession session) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, session.getContext(), session.getUser(), session.getUserPermissionBits());
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        boolean addLocked = false;
        for (Metadata m : columns) {
            if (m != Metadata.LOCKED_UNTIL_LITERAL) continue;
            addLocked = true;
            break;
        }
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        InfostoreIterator iter = InfostoreIterator.versions(id, cols, sort, order, this.getProvider(), session.getContext());
        InfostoreTimedResult tr = new InfostoreTimedResult(iter);
        if (addLocked) {
            return this.addLocked((TimedResult<DocumentMetadata>)tr, session.getContext(), session.getUser());
        }
        return tr;
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(int[] ids, Metadata[] columns, ServerSession session) throws OXException {
        try {
            this.security.injectInfostorePermissions(ids, session.getContext(), session.getUser(), session.getUserPermissionBits(), null, new Injector<Object, EffectiveInfostorePermission>(){

                @Override
                public Object inject(Object list, EffectiveInfostorePermission element) {
                    if (!element.canReadObject()) {
                        throw new NotAllowed(element.getObjectID());
                    }
                    return list;
                }
            });
        }
        catch (NotAllowed na) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        InfostoreIterator iter = InfostoreIterator.list(ids, cols, this.getProvider(), session.getContext());
        TimedResult<DocumentMetadata> tr = new TimedResult<DocumentMetadata>((SearchIterator<DocumentMetadata>)iter);
        for (Metadata m : cols) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                tr = this.addLocked(tr, session.getContext(), session.getUser());
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            tr = this.addNumberOfVersions(tr, session.getContext());
        }
        return tr;
    }

    @Override
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, boolean ignoreDeleted, ServerSession session) throws OXException {
        return this.getDelta(folderId, updateSince, columns, null, 0, ignoreDeleted, session);
    }

    @Override
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, Metadata sort, int order, boolean ignoreDeleted, ServerSession session) throws OXException {
        boolean onlyOwn = false;
        EffectivePermission isperm = this.security.getFolderPermission(folderId, session.getContext(), session.getUser(), session.getUserPermissionBits());
        if (isperm.getReadPermission() == 0) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (isperm.getReadPermission() == 2) {
            onlyOwn = true;
        }
        boolean addLocked = false;
        boolean addNumberOfVersions = false;
        for (Metadata m : columns) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                addLocked = true;
                break;
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            addNumberOfVersions = true;
            break;
        }
        Map<Integer, List<Lock>> locks = this.loadLocksInFolderAndExpireOldLocks(folderId, session.getContext(), session.getUser());
        ReuseReadConProvider reuse = new ReuseReadConProvider(this.getProvider());
        InfostoreIterator newIter = null;
        InfostoreIterator modIter = null;
        InfostoreIterator delIter = null;
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        if (onlyOwn) {
            newIter = InfostoreIterator.newDocumentsByCreator(folderId, session.getUser().getId(), cols, sort, order, updateSince, reuse, session.getContext());
            modIter = InfostoreIterator.modifiedDocumentsByCreator(folderId, session.getUser().getId(), cols, sort, order, updateSince, reuse, session.getContext());
            if (!ignoreDeleted) {
                delIter = InfostoreIterator.deletedDocumentsByCreator(folderId, session.getUser().getId(), sort, order, updateSince, reuse, session.getContext());
            }
        } else {
            newIter = InfostoreIterator.newDocuments(folderId, cols, sort, order, updateSince, reuse, session.getContext());
            modIter = InfostoreIterator.modifiedDocuments(folderId, cols, sort, order, updateSince, reuse, session.getContext());
            if (!ignoreDeleted) {
                delIter = InfostoreIterator.deletedDocuments(folderId, sort, order, updateSince, reuse, session.getContext());
            }
        }
        Object it = ignoreDeleted ? SearchIteratorAdapter.emptyIterator() : delIter;
        Delta<DocumentMetadata> delta = new Delta<DocumentMetadata>((SearchIterator)newIter, (SearchIterator)modIter, it, System.currentTimeMillis());
        if (addLocked) {
            delta = this.addLocked(delta, locks, session.getContext(), session.getUser());
        }
        if (addNumberOfVersions) {
            delta = this.addNumberOfVersions(delta, session.getContext());
        }
        return delta;
    }

    @Override
    public Map<Long, Long> getSequenceNumbers(List<Long> folderIds, boolean versionsOnly, ServerSession session) throws OXException {
        if (0 == folderIds.size()) {
            return Collections.emptyMap();
        }
        final HashMap<Long, Long> sequenceNumbers = new HashMap<Long, Long>(folderIds.size());
        try {
            this.performQuery(session.getContext(), QUERIES.getFolderSequenceNumbersQuery(folderIds, versionsOnly, true, session.getContext().getContextId()), new ResultProcessor<Void>(){

                @Override
                public Void process(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        sequenceNumbers.put(rs.getLong(1), rs.getLong(2));
                    }
                    return null;
                }
            }, new Object[0]);
            this.performQuery(session.getContext(), QUERIES.getFolderSequenceNumbersQuery(folderIds, versionsOnly, false, session.getContext().getContextId()), new ResultProcessor<Void>(){

                @Override
                public Void process(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        Long folderID = rs.getLong(1);
                        long sequenceNumber = rs.getLong(2);
                        if (sequenceNumbers.containsKey(folderID) && (Long)sequenceNumbers.get(folderID) >= sequenceNumber) continue;
                        sequenceNumbers.put(folderID, sequenceNumber);
                    }
                    return null;
                }
            }, new Object[0]);
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        return sequenceNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, List<Lock>> loadLocksInFolderAndExpireOldLocks(long folderId, Context ctx, User user) throws OXException {
        HashMap<Integer, List<Lock>> locks = new HashMap<Integer, List<Lock>>();
        InfostoreIterator documents = InfostoreIterator.documents(folderId, new Metadata[]{Metadata.ID_LITERAL}, null, -1, this.getProvider(), ctx);
        try {
            while (documents.hasNext()) {
                DocumentMetadata document = documents.next();
                this.lockManager.findLocks(document.getId(), ctx, user);
            }
        }
        finally {
            documents.close();
        }
        return locks;
    }

    @Override
    public int countDocuments(long folderId, ServerSession session) throws OXException {
        boolean onlyOwn = false;
        EffectivePermission isperm = this.security.getFolderPermission(folderId, session.getContext(), session.getUser(), session.getUserPermissionBits());
        if (!isperm.canReadAllObjects() && !isperm.canReadOwnObjects()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (isperm.canReadOwnObjects()) {
            onlyOwn = true;
        }
        return this.db.countDocuments(folderId, onlyOwn, session.getContext(), session.getUser());
    }

    @Override
    public boolean hasFolderForeignObjects(long folderId, ServerSession session) throws OXException {
        return this.db.hasFolderForeignObjects(folderId, session.getContext(), session.getUser());
    }

    @Override
    public boolean isFolderEmpty(long folderId, Context ctx) throws OXException {
        return this.db.isFolderEmpty(folderId, ctx);
    }

    @Override
    public void removeUser(int userId, Context ctx, ServerSession session) throws OXException {
        this.db.removeUser(userId, ctx, session, this.lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getId(Context context, Connection writeCon) throws SQLException {
        boolean autoCommit = writeCon.getAutoCommit();
        if (autoCommit) {
            writeCon.setAutoCommit(false);
        }
        try {
            int n = IDGenerator.getId(context, 137, writeCon);
            return n;
        }
        finally {
            if (autoCommit) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
    }

    private Metadata[] addLastModifiedIfNeeded(Metadata[] columns) {
        for (Metadata metadata : columns) {
            if (metadata != Metadata.LAST_MODIFIED_LITERAL && metadata != Metadata.LAST_MODIFIED_UTC_LITERAL) continue;
            return columns;
        }
        Metadata[] copy = new Metadata[columns.length + 1];
        int i = 0;
        for (Metadata metadata : columns) {
            copy[i++] = metadata;
        }
        copy[i] = Metadata.LAST_MODIFIED_UTC_LITERAL;
        return copy;
    }

    public InfostoreSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void commit() throws OXException {
        this.db.commit();
        ServiceMethod.COMMIT.callUnsafe(this.security, new Object[0]);
        this.lockManager.commit();
        List<String> filesToRemove = this.fileIdRemoveList.get();
        if (null != filesToRemove && 0 < filesToRemove.size()) {
            this.getFileStorage(this.ctxHolder.get()).deleteFiles(filesToRemove.toArray(new String[filesToRemove.size()]));
        }
        super.commit();
    }

    @Override
    public void finish() throws OXException {
        this.fileIdRemoveList.set(null);
        this.ctxHolder.set(null);
        this.db.finish();
        ServiceMethod.FINISH.callUnsafe(this.security, new Object[0]);
        super.finish();
    }

    @Override
    public void rollback() throws OXException {
        this.db.rollback();
        ServiceMethod.ROLLBACK.callUnsafe(this.security, new Object[0]);
        this.lockManager.rollback();
        super.rollback();
    }

    @Override
    public void setRequestTransactional(boolean transactional) {
        this.db.setRequestTransactional(transactional);
        ServiceMethod.SET_REQUEST_TRANSACTIONAL.call(this.security, transactional);
        this.lockManager.setRequestTransactional(transactional);
        super.setRequestTransactional(transactional);
    }

    @Override
    public void setTransactional(boolean transactional) {
        this.lockManager.setTransactional(transactional);
    }

    @Override
    public void startTransaction() throws OXException {
        this.fileIdRemoveList.set(new ArrayList());
        this.ctxHolder.set(null);
        this.db.startTransaction();
        ServiceMethod.START_TRANSACTION.callUnsafe(this.security, new Object[0]);
        this.lockManager.startTransaction();
        super.startTransaction();
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        this.db.setProvider(provider);
        ServiceMethod.SET_PROVIDER.call(this.security, provider);
        ServiceMethod.SET_PROVIDER.call(this.lockManager, provider);
    }

    private static final UserConfiguration getUserConfiguration(ServerSession session) {
        return session.getUserConfiguration();
    }

    private static final User getUser(ServerSession session) {
        return session.getUser();
    }

    @Override
    public void setSessionHolder(SessionHolder sessionHolder) {
        this.expiredLocksListener.setSessionHolder(sessionHolder);
    }

    private void removeFromIndex(Context context, int userId, List<DocumentMetadata> documents) {
    }

    private void indexDocument(Context context, int userId, int id, long origFolderId, boolean isCreation) {
    }

    static {
        VALIDATION.add(new InvalidCharactersValidator());
        VALIDATION.add(new FilenamesMayNotContainSlashesValidator());
        filenameReserver = new SelectForUpdateFilenameReserver();
        LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreFacadeImpl.class));
        QUERIES = new InfostoreQueryCatalog();
        IS_NUMBERED_WITH_EXTENSION = Pattern.compile("\\(\\d+\\)\\.");
        IS_NUMBERED = Pattern.compile("\\(\\d+\\)$");
    }

    private static interface ResultProcessor<T> {
        public T process(ResultSet var1) throws SQLException;
    }

    private final class NumberOfVersionsDelta
    implements Delta<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> newIter;
        private final SearchIterator<DocumentMetadata> modified;
        private SearchIterator<DocumentMetadata> deleted;

        public NumberOfVersionsDelta(Delta<DocumentMetadata> delegate, Context ctx) throws OXException {
            SearchIterator deleted = delegate.getDeleted();
            if (null != deleted) {
                this.deleted = InfostoreFacadeImpl.this.numberOfVersionsIterator(deleted, ctx);
            }
            this.modified = InfostoreFacadeImpl.this.numberOfVersionsIterator(delegate.getModified(), ctx);
            this.newIter = InfostoreFacadeImpl.this.numberOfVersionsIterator(delegate.getNew(), ctx);
            this.sequenceNumber = delegate.sequenceNumber();
        }

        public SearchIterator<DocumentMetadata> getDeleted() {
            return this.deleted;
        }

        public SearchIterator<DocumentMetadata> getModified() {
            return this.modified;
        }

        public SearchIterator<DocumentMetadata> getNew() {
            return this.newIter;
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return new CombinedSearchIterator(new SearchIterator[]{this.newIter, this.modified});
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public void close() throws OXException {
            this.newIter.close();
            this.modified.close();
            this.deleted.close();
        }
    }

    private final class LockDelta
    implements Delta<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> newIter;
        private final SearchIterator<DocumentMetadata> modified;
        private SearchIterator<DocumentMetadata> deleted;

        public LockDelta(Delta<DocumentMetadata> delegate, Map<Integer, List<Lock>> locks, Context ctx, User user) throws OXException {
            SearchIterator deleted = delegate.getDeleted();
            if (null != deleted) {
                this.deleted = InfostoreFacadeImpl.this.lockedUntilIterator(deleted, locks, ctx, user);
            }
            this.modified = InfostoreFacadeImpl.this.lockedUntilIterator(delegate.getModified(), locks, ctx, user);
            this.newIter = InfostoreFacadeImpl.this.lockedUntilIterator(delegate.getNew(), locks, ctx, user);
            this.sequenceNumber = delegate.sequenceNumber();
        }

        public SearchIterator<DocumentMetadata> getDeleted() {
            return this.deleted;
        }

        public SearchIterator<DocumentMetadata> getModified() {
            return this.modified;
        }

        public SearchIterator<DocumentMetadata> getNew() {
            return this.newIter;
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return new CombinedSearchIterator(new SearchIterator[]{this.newIter, this.modified});
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public void close() throws OXException {
            this.newIter.close();
            this.modified.close();
            this.deleted.close();
        }
    }

    private final class LockTimedResult
    implements TimedResult<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> results;

        public LockTimedResult(TimedResult<DocumentMetadata> delegate, Context ctx, User user) throws OXException {
            this.sequenceNumber = delegate.sequenceNumber();
            this.results = InfostoreFacadeImpl.this.lockedUntilIterator(delegate.results(), null, ctx, user);
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return this.results;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }
    }

    private final class NumberOfVersionsTimedResult
    implements TimedResult<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> results;

        public NumberOfVersionsTimedResult(TimedResult<DocumentMetadata> delegate, Context ctx) throws OXException {
            this.sequenceNumber = delegate.sequenceNumber();
            this.results = InfostoreFacadeImpl.this.numberOfVersionsIterator(delegate.results(), ctx);
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return this.results;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }
    }

    private static enum ServiceMethod {
        COMMIT,
        FINISH,
        ROLLBACK,
        SET_REQUEST_TRANSACTIONAL,
        START_TRANSACTION,
        SET_PROVIDER;


        public void call(Object o, Object ... args) {
            if (!(o instanceof DBService)) {
                return;
            }
            DBService service = (DBService)o;
            switch (this) {
                default: {
                    return;
                }
                case SET_REQUEST_TRANSACTIONAL: {
                    service.setRequestTransactional((Boolean)args[0]);
                    break;
                }
                case SET_PROVIDER: {
                    service.setProvider((DBProvider)args[0]);
                }
            }
        }

        public void callUnsafe(Object o, Object ... args) throws OXException {
            if (!(o instanceof DBService)) {
                return;
            }
            DBService service = (DBService)o;
            switch (this) {
                default: {
                    this.call(o, args);
                    break;
                }
                case COMMIT: {
                    service.commit();
                    break;
                }
                case FINISH: {
                    service.finish();
                    break;
                }
                case ROLLBACK: {
                    service.rollback();
                    break;
                }
                case START_TRANSACTION: {
                    service.startTransaction();
                }
            }
        }
    }

    private static final class NotAllowed
    extends RuntimeException {
        private static final long serialVersionUID = 4872889537922290831L;
        private final int id;

        public NotAllowed(int id) {
            this.id = id;
        }
    }
}

