/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.update.UpdateStatus;
import com.openexchange.groupware.update.Updater;
import com.openexchange.groupware.update.internal.SchemaExceptionCodes;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.util.List;

public class CachingContextStorage
extends ContextStorage {
    static final org.apache.commons.logging.Log LOG = Log.loggerFor(CachingContextStorage.class);
    private static final String REGION_NAME = "Context";
    public static volatile CachingContextStorage parent;
    private final ContextStorage persistantImpl;
    private boolean started;

    public CachingContextStorage(ContextStorage persistantImpl) {
        this.persistantImpl = persistantImpl;
    }

    @Override
    public int getContextId(String loginInfo) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return this.persistantImpl.getContextId(loginInfo);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Integer contextId = (Integer)cache.get((Serializable)((Object)loginInfo));
        if (null == contextId) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Cache MISS. Login info: " + loginInfo));
            }
            if (-1 != (contextId = Autoboxing.I((int)this.persistantImpl.getContextId(loginInfo)))) {
                try {
                    cache.put((Serializable)((Object)loginInfo), (Serializable)contextId, false);
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cache HIT. Login info: " + loginInfo));
        }
        return contextId;
    }

    @Override
    public ContextExtended loadContext(int contextId) throws OXException {
        Integer key;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.load(contextId);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(key = Autoboxing.I((int)contextId)));
        if (object instanceof ContextExtended) {
            return (ContextExtended)object;
        }
        ContextExtended contextExtended = this.load(contextId);
        cache.put((Serializable)key, (Serializable)((Object)contextExtended), false);
        return contextExtended;
    }

    @Override
    public List<Integer> getAllContextIds() throws OXException {
        return this.persistantImpl.getAllContextIds();
    }

    @Override
    protected void startUp() throws OXException {
        if (this.started) {
            LOG.error((Object)"Duplicate initialization of CachingContextStorage.");
            return;
        }
        this.persistantImpl.startUp();
        this.started = true;
    }

    @Override
    protected void shutDown() throws OXException {
        if (!this.started) {
            LOG.error((Object)"Duplicate shutdown of CachingContextStorage.");
            return;
        }
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService != null) {
            try {
                cacheService.freeCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.persistantImpl.shutDown();
        this.started = false;
    }

    @Override
    public void invalidateContext(int contextId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return;
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        try {
            Object object = cache.get((Serializable)Autoboxing.I((int)contextId));
            if (object instanceof ContextExtended) {
                for (String loginInfo : ((ContextExtended)object).getLoginInfo()) {
                    cache.remove((Serializable)((Object)loginInfo));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        cache.remove((Serializable)Autoboxing.I((int)contextId));
    }

    @Override
    public void invalidateLoginInfo(String loginContextInfo) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return;
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        cache.remove((Serializable)((Object)loginContextInfo));
    }

    ContextStorage getPersistantImpl() {
        return this.persistantImpl;
    }

    private ContextExtended load(int contextId) throws OXException {
        ContextExtended retval;
        block3: {
            retval = parent.getPersistantImpl().loadContext(contextId);
            Updater updater = Updater.getInstance();
            try {
                UpdateStatus status = updater.getStatus(retval);
                retval.setUpdating(status.blockingUpdatesRunning() || status.needsBlockingUpdates());
                if ((status.needsBlockingUpdates() || status.needsBackgroundUpdates()) && !status.blockingUpdatesRunning() && !status.backgroundUpdatesRunning()) {
                    updater.startUpdate(retval);
                }
            }
            catch (OXException e) {
                if (!SchemaExceptionCodes.DATABASE_DOWN.equals(e)) break block3;
                LOG.warn((Object)("Switching to read only mode for context " + contextId + " because master database is down."), (Throwable)e);
                retval.setReadOnly(true);
            }
        }
        return retval;
    }
}

