/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Change;
import com.openexchange.groupware.container.ConfirmationChange;
import com.openexchange.groupware.container.Differ;
import com.openexchange.groupware.container.Difference;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import edu.emory.mathcs.backport.java.util.Arrays;

public class ConfirmationsDiffer
extends Differ<CalendarObject> {
    @Override
    public Difference getDifference(CalendarObject original, CalendarObject update) {
        boolean found;
        if (!update.containsConfirmations()) {
            return null;
        }
        if (!original.containsConfirmations() && update.containsConfirmations()) {
            Difference difference = new Difference(226);
            difference.getAdded().addAll(Arrays.asList((Object[])update.getConfirmations()));
            return difference;
        }
        if (original.getConfirmations() == update.getConfirmations()) {
            return null;
        }
        if (original.getConfirmations() == null) {
            Difference difference = new Difference(226);
            difference.getAdded().addAll(Arrays.asList((Object[])update.getConfirmations()));
            return difference;
        }
        boolean isDifferent = false;
        Difference difference = new Difference(226);
        for (ConfirmableParticipant o : original.getConfirmations()) {
            found = false;
            for (ConfirmableParticipant u : update.getConfirmations()) {
                if (o.getEmailAddress() == null || !o.getEmailAddress().equalsIgnoreCase(u.getEmailAddress())) continue;
                Change change = this.getChange(o, u);
                found = true;
                if (change == null) break;
                isDifferent = true;
                difference.getChanged().add(change);
                break;
            }
            if (found) continue;
            difference.getRemoved().add(o);
            isDifferent = true;
        }
        for (ConfirmableParticipant u : update.getConfirmations()) {
            found = false;
            for (ConfirmableParticipant o : original.getConfirmations()) {
                if (u.getEmailAddress() == null || !u.getEmailAddress().equalsIgnoreCase(o.getEmailAddress())) continue;
                found = true;
                break;
            }
            if (found) continue;
            difference.getAdded().add(u);
            isDifferent = true;
        }
        return isDifferent ? difference : null;
    }

    private Change getChange(ConfirmableParticipant original, ConfirmableParticipant update) {
        boolean changed = false;
        ConfirmationChange change = new ConfirmationChange(original.getEmailAddress());
        if (original.getConfirm() != update.getConfirm()) {
            changed = true;
            change.setStatus(original.getConfirm(), update.getConfirm());
        }
        if (original.getMessage() != update.getMessage() && (original.getMessage() == null && update.getMessage() != null || !original.getMessage().equals(update.getMessage()))) {
            changed = true;
            change.setMessage(original.getMessage(), update.getMessage());
            change.setStatus(original.getConfirm(), update.getConfirm());
        }
        return changed ? change : null;
    }

    @Override
    public int getColumn() {
        return 226;
    }
}

