/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.Order;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;

public class CollationContactComparator
implements Comparator<Contact> {
    private int orderDir;
    private final ContactField orderBy;
    private final RuleBasedCollator collator;

    public CollationContactComparator(ContactField orderBy, Order order, Locale locale) {
        this.orderBy = orderBy;
        switch (order) {
            case ASCENDING: {
                this.orderDir = 1;
                break;
            }
            case DESCENDING: {
                this.orderDir = -1;
                break;
            }
            default: {
                this.orderDir = 0;
            }
        }
        this.collator = (RuleBasedCollator)Collator.getInstance(locale);
    }

    @Override
    public int compare(Contact o1, Contact o2) {
        Object f2;
        if (o1 == o2 || this.orderDir == 0) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Object f1 = o1.get(this.orderBy.getNumber());
        if (f1 == (f2 = o2.get(this.orderBy.getNumber()))) {
            return 0;
        }
        if (f1 == null && f2 != null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        return this.orderDir * this.collator.compare(f1, f2);
    }
}

