/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.ContactMySql;
import com.openexchange.groupware.contact.ContactSql;
import com.openexchange.groupware.contact.database.PrivateFlag;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderAdminHelper;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.mail.internet.AddressException;
import org.apache.commons.logging.Log;

@Deprecated
public final class Contacts {
    private static final String PROP_SCALE_IMAGE_HEIGHT = "scale_image_height";
    private static final String PROP_SCALE_IMAGE_WIDTH = "scale_image_width";
    private static final String PROP_VALIDATE_CONTACT_EMAIL = "validate_contact_email";
    private static final String PROP_SCALE_IMAGES = "scale_images";
    private static final String PROP_MAX_IMAGE_SIZE = "max_image_size";
    public static final int DATA_TRUNCATION = 54;
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Contacts.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final Mapper[] mapping = new Mapper[700];
    private static final int LIMIT = 1000;

    private Contacts() {
    }

    private static String getStatementString(Statement statement) {
        String str = statement.toString();
        int pos = str.indexOf(": ");
        return pos < 0 ? str : str.substring(pos + 2);
    }

    private static void validateEmailAddress(Contact co) throws OXException {
        if (Boolean.TRUE.toString().equalsIgnoreCase(ContactConfig.getInstance().getProperty(PROP_VALIDATE_CONTACT_EMAIL))) {
            String email = null;
            try {
                if (co.containsEmail1() && (email = co.getEmail1()) != null && email.trim().length() > 0) {
                    new QuotedInternetAddress(email).validate();
                }
                if (co.containsEmail2() && (email = co.getEmail2()) != null && email.trim().length() > 0) {
                    new QuotedInternetAddress(email).validate();
                }
                if (co.containsEmail3() && (email = co.getEmail3()) != null && email.trim().length() > 0) {
                    new QuotedInternetAddress(email).validate();
                }
            }
            catch (AddressException e) {
                throw ContactExceptionCodes.INVALID_EMAIL.create(e, email);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] scaleContactImage(byte[] img, String mime) throws OXException {
        long max_size;
        if (null == mime) {
            throw ContactExceptionCodes.MIME_TYPE_NOT_DEFINED.create();
        }
        String tempWidth = ContactConfig.getInstance().getProperty(PROP_SCALE_IMAGE_WIDTH);
        int scaledWidth = tempWidth == null ? 90 : Integer.parseInt(tempWidth);
        String tempHeight = ContactConfig.getInstance().getProperty(PROP_SCALE_IMAGE_HEIGHT);
        int scaledHeight = tempHeight == null ? 90 : Integer.parseInt(tempHeight);
        String tempSize = ContactConfig.getInstance().getProperty(PROP_MAX_IMAGE_SIZE);
        long l = max_size = tempSize == null ? 0x400000L : Long.parseLong(tempSize);
        String myMime = mime.toLowerCase().indexOf("jpg") != -1 || mime.toLowerCase().indexOf("jpeg") != -1 ? "image/jpg" : (mime.toLowerCase().indexOf("bmp") != -1 ? "image/bmp" : (mime.toLowerCase().indexOf("png") != -1 ? "image/png" : mime));
        String fileType = myMime.substring(myMime.indexOf(47) + 1);
        boolean check = false;
        HashSet<String> allowedMime = new HashSet<String>(java.util.Arrays.asList(ImageIO.getReaderFormatNames()));
        check = allowedMime.contains(fileType);
        if (myMime.toLowerCase().contains("gif")) {
            check = true;
        }
        if ((long)img.length > max_size) {
            check = false;
        }
        if (!check) {
            int pos;
            int n = pos = myMime == null ? -1 : myMime.indexOf(47);
            if (pos >= 0) {
                myMime = myMime.substring(pos + 1).toUpperCase(Locale.US);
            }
            throw ContactExceptionCodes.IMAGE_SCALE_PROBLEM.create(myMime, Autoboxing.I((int)img.length), Autoboxing.L((long)max_size));
        }
        BufferedImage bi = null;
        try {
            bi = ImageIO.read((InputStream)new UnsynchronizedByteArrayInputStream(img));
            if (null == bi) {
                BufferedImage targetImage = new BufferedImage(scaledWidth, scaledHeight, 4);
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
                ImageIO.write((RenderedImage)targetImage, fileType, (OutputStream)out);
                bi = ImageIO.read((InputStream)new UnsynchronizedByteArrayInputStream(out.toByteArray()));
            }
        }
        catch (IOException e) {
            throw ContactExceptionCodes.IMAGE_DOWNSCALE_FAILED.create(e, new Object[0]);
        }
        int origHeigh = bi.getHeight();
        int origWidth = bi.getWidth();
        int origType = bi.getType();
        if (DEBUG) {
            StringBuilder logi = new StringBuilder(128).append("OUR IMAGE -> mime=").append(myMime).append(" / type=").append(origType).append(" / width=").append(origWidth).append(" / height=").append(origHeigh).append(" / byte[] size=").append(img.length);
            LOG.debug((Object)logi.toString());
        }
        if (origHeigh > scaledHeight || origWidth > scaledWidth) {
            float h1;
            float w1;
            float ratio = 0.0f;
            int sWd = 0;
            int sHd = 0;
            if (origWidth == origHeigh) {
                ratio = 1.0f;
                if (scaledHeight < scaledWidth) {
                    sWd = scaledHeight;
                    sHd = scaledHeight;
                } else if (scaledHeight > scaledWidth) {
                    sWd = scaledWidth;
                    sHd = scaledWidth;
                } else if (scaledHeight == scaledWidth) {
                    sWd = scaledWidth;
                    sHd = scaledWidth;
                }
                if (DEBUG) {
                    LOG.debug((Object)new StringBuilder(64).append("IMAGE SCALE Picture Heigh ").append(origHeigh).append(" Width ").append(origWidth).append(" -> Scale down to Heigh ").append(sHd).append(" Width ").append(sWd).append(" Ratio ").append(ratio).toString());
                }
            } else if (origWidth > origHeigh) {
                float widthFloat = scaledWidth;
                w1 = origWidth;
                h1 = origHeigh;
                ratio = w1 / h1;
                float heighFloat = widthFloat / ratio;
                if (heighFloat > (float)scaledHeight) {
                    heighFloat = scaledHeight;
                    widthFloat = heighFloat * ratio;
                }
                sWd = Math.round(widthFloat);
                sHd = Math.round(heighFloat);
                if (DEBUG) {
                    LOG.debug((Object)new StringBuilder(64).append("IMAGE SCALE Picture Heigh ").append(origHeigh).append(" Width ").append(origWidth).append(" -> Scale down to Heigh ").append(sHd).append(" Width ").append(sWd).append(" Ratio ").append(ratio).toString());
                }
            } else if (origWidth < origHeigh) {
                float heighFloat = scaledHeight;
                h1 = origHeigh;
                w1 = origWidth;
                ratio = h1 / w1;
                float widthFloat = heighFloat / ratio;
                if (widthFloat > (float)scaledWidth) {
                    widthFloat = scaledWidth;
                    heighFloat = widthFloat * ratio;
                }
                sWd = Math.round(widthFloat);
                sHd = Math.round(heighFloat);
                if (DEBUG) {
                    LOG.debug((Object)new StringBuilder(64).append("IMAGE SCALE Picture Heigh ").append(origHeigh).append(" Width ").append(origWidth).append(" -> Scale down to Heigh ").append(sHd).append(" Width ").append(sWd).append(" Ratio ").append(ratio).toString());
                }
            }
            if (origType == 0) {
                origType = 1;
            }
            BufferedImage scaledBufferedImage = new BufferedImage(sWd, sHd, origType);
            Graphics2D g2d = scaledBufferedImage.createGraphics();
            g2d.drawImage(bi, 0, 0, sWd, sHd, null);
            g2d.dispose();
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)scaledBufferedImage, fileType, (OutputStream)baos);
            }
            catch (Exception fallback) {
                LOG.debug((Object)"Unable to Scale the Image with default Parameters. Gonna try fallback");
            }
            finally {
                if (baos.toByteArray().length < 1) {
                    try {
                        ImageIO.write((RenderedImage)scaledBufferedImage, "JPG", (OutputStream)baos);
                    }
                    catch (IOException e) {
                        throw ContactExceptionCodes.IMAGE_DOWNSCALE_FAILED.create(e, new Object[0]);
                    }
                }
            }
            byte[] back = baos.toByteArray();
            return back;
        }
        return img;
    }

    private static void checkImageSize(int imageSize, int maxSize) throws OXException {
        if (maxSize > 0 && imageSize > maxSize) {
            throw ContactExceptionCodes.IMAGE_TOO_LARGE.create(Autoboxing.I((int)imageSize), Autoboxing.I((int)maxSize));
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void performContactStorageInsert(Contact contact, int user, Session session, boolean override) throws OXException, OXException {
        int id;
        StringBuilder insert_fields = new StringBuilder();
        StringBuilder insert_values = new StringBuilder();
        ContactMySql contactSql = null;
        Connection writecon = null;
        Connection readcon = null;
        Context context = null;
        if (!contact.containsFileAs() && contact.containsDisplayName()) {
            contact.setFileAs(contact.getDisplayName());
        }
        int contextId = session.getContextId();
        if (!contact.containsContextId() || contact.getContextId() <= 0) {
            contact.setContextId(contextId);
        }
        try {
            Contacts.validateEmailAddress(contact);
            context = ContextStorage.getStorageContext(contextId);
            contactSql = new ContactMySql(session, context);
            readcon = DBPool.pickup(context);
            int fid = contact.getParentFolderID();
            OXFolderAccess oxfs = new OXFolderAccess(readcon, context);
            FolderObject contactFolder = oxfs.getFolderObject(fid);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)fid), Autoboxing.I((int)contextId), Autoboxing.I((int)user));
            }
            EffectivePermission oclPerm = oxfs.getFolderPermission(fid, user, UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), context));
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)fid), Autoboxing.I((int)contextId), Autoboxing.I((int)user));
            }
            if (!oclPerm.canCreateObjects()) {
                throw ContactExceptionCodes.NO_CREATE_PERMISSION.create(Autoboxing.I((int)fid), Autoboxing.I((int)contextId), Autoboxing.I((int)user));
            }
            if (contactFolder.getType() != 1 && contact.getPrivateFlag()) {
                throw ContactExceptionCodes.PFLAG_IN_PUBLIC_FOLDER.create(Autoboxing.I((int)fid), Autoboxing.I((int)contextId), Autoboxing.I((int)user));
            }
            if (!contact.containsFileAs()) {
                contact.setFileAs(contact.getDisplayName());
            }
            if (!contact.containsUid() || Contacts.isEmpty(contact.getUid())) {
                contact.setUid(UUID.randomUUID().toString());
            }
            contact.removeContextID();
            contact.removeLastModified();
            contact.removeCreationDate();
            contact.removeCreatedBy();
            contact.removeModifiedBy();
            contact.removeObjectID();
            contact.setNumberOfAttachments(0);
            Contacts.checkCharacters(contact);
            for (int i = 0; i < 650; ++i) {
                Mapper mapper = mapping[i];
                if (mapper == null || !mapper.containsElement(contact) || i == 592 || i == 591 || i == 1 || i == 597 || i == 601) continue;
                insert_fields.append(mapper.getDBFieldName()).append(',');
                insert_values.append("?,");
            }
        }
        catch (Throwable throwable) {
            try {
                DBPool.closeReaderSilent(context, readcon);
                throw throwable;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to close READ Connection", (Throwable)e);
            }
            throw throwable;
        }
        try {
            DBPool.closeReaderSilent(context, readcon);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to close READ Connection", (Throwable)e);
        }
        try {
            writecon = DBPool.pickupWriteable(context);
            writecon.setAutoCommit(false);
            id = IDGenerator.getId(context, 7, writecon);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Got ID from Generator -> " + id));
            }
            writecon.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(writecon);
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
        }
        catch (RuntimeException re) {
            DBUtils.rollback(writecon);
            throw ContactExceptionCodes.UNEXPECTED_ERROR.create(re, re.getMessage());
        }
        finally {
            if (null != writecon) {
                DBUtils.autocommit(writecon);
                try {
                    DBPool.closeWriterSilent(context, writecon);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to close WRITE Connection");
                }
                writecon = null;
            }
        }
        PreparedStatement ps = null;
        try {
            writecon = DBPool.pickupWriteable(context);
            writecon.setAutoCommit(false);
            contact.setObjectID(id);
            long lmd = System.currentTimeMillis();
            StringBuilder insert = contactSql.iFperformContactStorageInsert(insert_fields, insert_values, user, lmd, contextId, id);
            if (override) {
                insert = contactSql.iFperformOverridingContactStorageInsert(insert_fields, insert_values, user, lmd, contextId, id);
            }
            ps = writecon.prepareStatement(insert.toString());
            int counter = 1;
            for (int i = 2; i < 650; ++i) {
                if (mapping[i] == null || !mapping[i].containsElement(contact) || i == 592 || i == 591 || i == 1 || i == 597 || i == 601) continue;
                mapping[i].fillPreparedStatement(ps, counter, contact);
                ++counter;
            }
            Date ddd = new Date(lmd);
            contact.setLastModified(ddd);
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder(64).append("DEBUG: YOU WANT TO INSERT THIS: cid=").append(contextId).append(" oid=").append(contact.getObjectID()).append(" -> ").append(Contacts.getStatementString(ps)).toString());
            }
            ps.execute();
            if (contact.containsNumberOfDistributionLists() && contact.getSizeOfDistributionListArray() > 0) {
                Contacts.writeDistributionListArrayInsert(contact.getDistributionList(), contact.getObjectID(), contextId, writecon);
            }
            if (contact.containsNumberOfLinks() && contact.getSizeOfLinks() > 0) {
                Contacts.writeContactLinkArrayInsert(contact.getLinks(), contact.getObjectID(), contextId, writecon);
            }
            if (contact.containsImage1()) {
                String shouldScale = ContactConfig.getInstance().getProperty(PROP_SCALE_IMAGES);
                if (shouldScale == null || shouldScale.equalsIgnoreCase("true")) {
                    try {
                        contact.setImage1(Contacts.scaleContactImage(contact.getImage1(), contact.getImageContentType()));
                    }
                    catch (OXException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw ContactExceptionCodes.NOT_VALID_IMAGE.create(e, new Object[0]);
                    }
                } else {
                    Contacts.checkImageSize(contact.getImage1().length, Integer.parseInt(ContactConfig.getInstance().getProperty(PROP_MAX_IMAGE_SIZE)));
                }
                Contacts.writeContactImage(contact.getObjectID(), contact.getImage1(), contextId, contact.getImageContentType(), lmd, writecon);
            }
            writecon.commit();
        }
        catch (DataTruncation se) {
            try {
                DBUtils.rollback(writecon);
                throw Contacts.getTruncation(writecon, se, "prg_contacts", contact);
                catch (OXException e) {
                    DBUtils.rollback(writecon);
                    throw e;
                }
                catch (SQLException se2) {
                    DBUtils.rollback(writecon);
                    throw ContactExceptionCodes.SQL_PROBLEM.create(se2, new Object[0]);
                }
                catch (RuntimeException re) {
                    DBUtils.rollback(writecon);
                    throw ContactExceptionCodes.UNEXPECTED_ERROR.create(re, re.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                if (null == writecon) throw throwable;
                DBUtils.autocommit(writecon);
                try {
                    DBPool.closeWriterSilent(context, writecon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to close WRITE Connection");
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
        if (null == writecon) return;
        DBUtils.autocommit(writecon);
        try {
            DBPool.closeWriterSilent(context, writecon);
            return;
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to close WRITE Connection");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void performContactStorageUpdate(Contact co, int fid, java.util.Date client_date, int user, int[] group, Context ctx, UserConfiguration uc) throws OXException {
        Contacts.validateEmailAddress(co);
        boolean can_edit_only_own = false;
        boolean can_delete_only_own = false;
        if (!co.containsParentFolderID() || co.getParentFolderID() == 0) {
            co.setParentFolderID(fid);
        }
        if (!co.containsContextId() || co.getContextId() <= 0) {
            co.setContextId(ctx.getContextId());
        }
        ContactMySql cs = new ContactMySql(ctx, user);
        Contact original = null;
        Connection readcon = null;
        try {
            readcon = DBPool.pickup(ctx);
            try {
                original = Contacts.getContactById(co.getObjectID(), user, group, ctx, uc, readcon);
            }
            catch (OXException e) {
                throw ContactExceptionCodes.LOAD_OLD_CONTACT_FAILED.create(e, Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()));
            }
            if (fid != original.getParentFolderID()) {
                throw ContactExceptionCodes.NOT_IN_FOLDER.create(Autoboxing.I((int)co.getObjectID()), Autoboxing.I((int)fid), Autoboxing.I((int)ctx.getContextId()));
            }
            if (6 == fid && co.containsEmail1() && ctx.getMailadmin() != user && original.getInternalUserId() == user) {
                throw ContactExceptionCodes.NO_PRIMARY_EMAIL_EDIT.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()), Autoboxing.I((int)user));
            }
            int folder_whereto = co.getParentFolderID();
            int folder_comesfrom = fid;
            FolderObject contactFolder = new OXFolderAccess(readcon, ctx).getFolderObject(folder_comesfrom);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folder_comesfrom), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
            }
            OXFolderAccess oxfs = new OXFolderAccess(readcon, ctx);
            EffectivePermission oclPerm = oxfs.getFolderPermission(folder_comesfrom, user, uc);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folder_comesfrom), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
            }
            if (!oclPerm.canWriteAllObjects()) {
                if (!oclPerm.canWriteOwnObjects()) {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)co.getParentFolderID()), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
                }
                can_edit_only_own = true;
            }
            if (co.getParentFolderID() != fid) {
                EffectivePermission op;
                if (!oclPerm.canDeleteAllObjects()) {
                    if (!oclPerm.canDeleteOwnObjects()) {
                        throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Autoboxing.I((int)folder_comesfrom), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
                    }
                    can_delete_only_own = true;
                }
                if (!(op = oxfs.getFolderPermission(folder_whereto, user, uc)).canCreateObjects()) {
                    throw ContactExceptionCodes.NO_CREATE_PERMISSION.create(Autoboxing.I((int)folder_whereto), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
                }
                FolderObject destination = new OXFolderAccess(readcon, ctx).getFolderObject(folder_whereto);
                if (destination.getModule() != 3) {
                    throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folder_whereto), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
                }
                if (op.getFolderPermission() <= 0) {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folder_whereto), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
                }
                if (!oclPerm.canCreateObjects()) {
                    throw ContactExceptionCodes.NO_CREATE_PERMISSION.create(Autoboxing.I((int)folder_whereto), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
                }
                if (contactFolder.getType() == 1 && destination.getType() == 2) {
                    if (co.containsPrivateFlag() && co.getPrivateFlag() || !original.getPrivateFlag() && co.containsPrivateFlag()) {
                        throw ContactExceptionCodes.NO_PRIVATE_MOVE.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()));
                    }
                } else if (contactFolder.getType() == 2 && destination.getType() == 2 && co.containsPrivateFlag()) {
                    throw ContactExceptionCodes.MARK_PRIVATE_NOT_ALLOWED.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()));
                }
            }
            if (can_edit_only_own && original.getCreatedBy() != user) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)fid), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
            }
            if (can_delete_only_own && original.getCreatedBy() != user) {
                throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Autoboxing.I((int)fid), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)user));
            }
            if (contactFolder.getType() != 1 && co.getPrivateFlag()) {
                throw ContactExceptionCodes.MARK_PRIVATE_NOT_ALLOWED.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()));
            }
            if (contactFolder.getType() == 1 && original.getPrivateFlag() && original.getCreatedBy() != user) {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Autoboxing.I((int)co.getObjectID()), Autoboxing.I((int)ctx.getContextId()));
            }
            java.util.Date server_date = original.getLastModified();
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder("Compare Dates for Contact Update\nClient-Date=" + client_date.getTime() + "\nServer-Date=" + server_date.getTime()));
            }
            if (client_date != null && client_date.getTime() > -1L && client_date.getTime() < server_date.getTime()) {
                throw ContactExceptionCodes.OBJECT_HAS_CHANGED.create();
            }
            if (6 == co.getParentFolderID()) {
                if (co.containsDisplayName()) {
                    if (null == co.getDisplayName()) throw ContactExceptionCodes.DISPLAY_NAME_MANDATORY.create();
                    if ("".equals(co.getDisplayName())) {
                        throw ContactExceptionCodes.DISPLAY_NAME_MANDATORY.create();
                    }
                }
                if (co.containsSurName()) {
                    if (null == co.getSurName()) throw ContactExceptionCodes.LAST_NAME_MANDATORY.create();
                    if ("".equals(co.getSurName())) {
                        throw ContactExceptionCodes.LAST_NAME_MANDATORY.create();
                    }
                }
                if (co.containsGivenName()) {
                    if (null == co.getGivenName()) throw ContactExceptionCodes.FIRST_NAME_MANDATORY.create();
                    if ("".equals(co.getGivenName())) {
                        throw ContactExceptionCodes.FIRST_NAME_MANDATORY.create();
                    }
                }
            }
            if (co.getParentFolderID() == 6 && co.containsDisplayName() && co.getDisplayName() != null) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                ContactMySql csql = new ContactMySql(ctx, user);
                csql.setFolder(co.getParentFolderID());
                ContactSearchObject cso = new ContactSearchObject();
                cso.setDisplayName(co.getDisplayName());
                cso.setIgnoreOwn(co.getObjectID());
                csql.setContactSearchObject(cso);
                csql.setSelect(csql.iFgetColsString(new int[]{1, 20}).toString());
                csql.setSearchHabit(" AND ");
                try {
                    stmt = csql.getSqlStatement(readcon);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        throw ContactExceptionCodes.DISPLAY_NAME_IN_USE.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            if ((!co.containsFileAs() || co.getFileAs() != null && co.getFileAs().length() > 0) && co.getDisplayName() != null) {
                co.setFileAs(co.getDisplayName());
            }
            Contacts.checkCharacters(co);
        }
        finally {
            try {
                DBPool.closeReaderSilent(ctx, readcon);
            }
            catch (Exception ex) {
                LOG.error((Object)"Unable to close READ Connection", (Throwable)ex);
            }
        }
        Connection writecon = null;
        PreparedStatement ps = null;
        StringBuilder update = new StringBuilder();
        try {
            int id;
            boolean modifiedDisplayName = false;
            String newDisplayName = null;
            String newFirstName = null;
            String newLstName = null;
            String newEmail01 = null;
            int[] mod = new int[650];
            int cnt = 0;
            for (int i = 0; i < 650; ++i) {
                Mapper mapper = mapping[i];
                if (mapper == null || mapper.compare(co, original)) continue;
                if (i == 500) {
                    if (original.getInternalUserId() > 0) {
                        modifiedDisplayName = true;
                    }
                    newDisplayName = co.getDisplayName();
                } else if (i == 555) {
                    newEmail01 = co.getEmail1();
                } else if (i == 501) {
                    newFirstName = co.getGivenName();
                } else if (i == 502) {
                    newLstName = co.getSurName();
                }
                mod[cnt++] = i;
            }
            int[] modtrim = new int[cnt];
            System.arraycopy(mod, 0, modtrim, 0, cnt);
            if (modtrim.length <= 0) {
                throw ContactExceptionCodes.NO_CHANGES.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)co.getObjectID()));
            }
            boolean addressBusinessChanged = false;
            boolean addressHomeChanged = false;
            boolean addressOtherChanged = false;
            for (int i = 0; i < modtrim.length; ++i) {
                int field = modtrim[i];
                Mapper mapper = mapping[field];
                if (mapper == null || !mapper.containsElement(co) || field == 592 || field == 591 || field == 1 || i == 601) continue;
                addressBusinessChanged |= java.util.Arrays.binarySearch(Contact.ADDRESS_FIELDS_BUSINESS, field) >= 0;
                addressHomeChanged |= java.util.Arrays.binarySearch(Contact.ADDRESS_FIELDS_HOME, field) >= 0;
                addressOtherChanged |= java.util.Arrays.binarySearch(Contact.ADDRESS_FIELDS_OTHER, field) >= 0;
                update.append(mapper.getDBFieldName()).append(" = ?,");
            }
            if (addressBusinessChanged || addressHomeChanged || addressOtherChanged) {
                int[] tmp = new int[modtrim.length];
                System.arraycopy(modtrim, 0, tmp, 0, modtrim.length);
                java.util.Arrays.sort(tmp);
                if (addressBusinessChanged) {
                    if (java.util.Arrays.binarySearch(tmp, 614) < 0 || !co.containsAddressBusiness()) {
                        update.append("businessAddress").append(" = ?,");
                    } else {
                        addressBusinessChanged = false;
                    }
                }
                if (addressHomeChanged) {
                    if (java.util.Arrays.binarySearch(tmp, 613) < 0 || !co.containsAddressHome()) {
                        update.append("homeAddress").append(" = ?,");
                    } else {
                        addressHomeChanged = false;
                    }
                }
                if (addressOtherChanged) {
                    if (java.util.Arrays.binarySearch(tmp, 615) < 0 || !co.containsAddressOther()) {
                        update.append("otherAddress").append(" = ?,");
                    } else {
                        addressOtherChanged = false;
                    }
                }
            }
            if ((id = co.getObjectID()) == -1) {
                throw ContactExceptionCodes.NEGATIVE_OBJECT_ID.create();
            }
            long lmd = System.currentTimeMillis();
            StringBuilder updater = cs.iFperformContactStorageUpdate(update, lmd, id, ctx.getContextId());
            writecon = DBPool.pickupWriteable(ctx);
            ps = writecon.prepareStatement(updater.toString());
            int counter = 1;
            for (int i = 0; i < modtrim.length; ++i) {
                Mapper mapper = mapping[modtrim[i]];
                if (mapper == null || !mapper.containsElement(co) || modtrim[i] == 592 || modtrim[i] == 591 || modtrim[i] == 1 || i == 601) continue;
                mapper.fillPreparedStatement(ps, counter, co);
                ++counter;
            }
            if (addressBusinessChanged) {
                ps.setNull(counter++, 12);
            }
            if (addressHomeChanged) {
                ps.setNull(counter++, 12);
            }
            if (addressOtherChanged) {
                ps.setNull(counter++, 12);
            }
            Date ddd = new Date(lmd);
            co.setLastModified(ddd);
            writecon.setAutoCommit(false);
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder("DEBUG: YOU WANT TO UPDATE THIS: cid=" + ctx.getContextId() + " oid=" + co.getObjectID() + " -> " + Contacts.getStatementString(ps)));
            }
            if (co.getParentFolderID() != fid) {
                Statement stmt = writecon.createStatement();
                try {
                    cs.iFbackupContact(stmt, ctx.getContextId(), co.getObjectID(), user);
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            ps.execute();
            if (co.containsNumberOfDistributionLists()) {
                Contacts.writeDistributionListArrayUpdate(co.getDistributionList(), original.getDistributionList(), co.getObjectID(), ctx.getContextId(), writecon);
            }
            if (co.containsNumberOfLinks() && co.getSizeOfLinks() > 0) {
                Contacts.writeContactLinkArrayUpdate(co.getLinks(), original.getLinks(), co.getObjectID(), ctx.getContextId(), writecon);
            }
            if (co.containsImage1()) {
                if (co.getImage1() != null) {
                    if ("true".equalsIgnoreCase(ContactConfig.getInstance().getProperty(PROP_SCALE_IMAGES))) {
                        try {
                            co.setImage1(Contacts.scaleContactImage(co.getImage1(), co.getImageContentType()));
                        }
                        catch (OXException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw ContactExceptionCodes.NOT_VALID_IMAGE.create(e, new Object[0]);
                        }
                    } else {
                        Contacts.checkImageSize(co.getImage1().length, Integer.parseInt(ContactConfig.getInstance().getProperty(PROP_MAX_IMAGE_SIZE)));
                    }
                    if (original.containsImage1()) {
                        Contacts.updateContactImage(co.getObjectID(), co.getImage1(), ctx.getContextId(), co.getImageContentType(), lmd, writecon);
                    } else {
                        Contacts.writeContactImage(co.getObjectID(), co.getImage1(), ctx.getContextId(), co.getImageContentType(), lmd, writecon);
                    }
                } else if (original.containsImage1()) {
                    try {
                        Contacts.deleteImage(co.getObjectID(), ctx.getContextId(), writecon);
                    }
                    catch (SQLException oxee) {
                        LOG.error((Object)"Unable to delete Contact Image", (Throwable)oxee);
                    }
                }
            }
            if (modifiedDisplayName) {
                OXFolderAdminHelper.propagateUserModification(original.getInternalUserId(), new int[]{500}, System.currentTimeMillis(), writecon, writecon, ctx.getContextId());
            }
            if (null != newDisplayName || null != newEmail01 || null != newFirstName || null != newLstName) {
                boolean isUserContact = original.getInternalUserId() > 0;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = writecon.prepareStatement("SELECT field01, field02, field03, field04, intfield01 FROM prg_dlist WHERE cid = ? AND intfield03 IS NOT NULL AND intfield03 <> 0 AND intfield02 IS NOT NULL AND intfield02 = ?");
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos, co.getObjectID());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        LinkedList<DistributionListEntryObject> entries = new LinkedList<DistributionListEntryObject>();
                        do {
                            DistributionListEntryObject e = new DistributionListEntryObject();
                            String tmp = rs.getString(1);
                            if (!rs.wasNull()) {
                                e.setDisplayname(tmp);
                            }
                            tmp = rs.getString(2);
                            if (!rs.wasNull()) {
                                e.setFirstname(tmp);
                            }
                            tmp = rs.getString(3);
                            if (!rs.wasNull()) {
                                e.setLastname(tmp);
                            }
                            tmp = rs.getString(4);
                            if (!rs.wasNull()) {
                                e.setEmailaddress(tmp);
                            }
                            e.setEmailfield(rs.getInt(5));
                            entries.add(e);
                        } while (rs.next());
                        DBUtils.closeSQLStuff(rs, stmt);
                        ArrayList<String> values = new ArrayList<String>(4);
                        for (DistributionListEntryObject dleo : entries) {
                            values.clear();
                            StringBuilder sb = new StringBuilder("UPDATE prg_dlist SET");
                            if (null != newDisplayName) {
                                sb.append(" field01 = ?,");
                                values.add(newDisplayName);
                            } else if (null != newLstName && null != newFirstName) {
                                sb.append(" field01 = ?,");
                                values.add(newLstName + ", " + newFirstName);
                            } else if (null != newLstName && null == newFirstName) {
                                sb.append(" field01 = ?,");
                                values.add(newLstName + ", " + original.getGivenName());
                            } else if (null == newLstName && null != newFirstName) {
                                sb.append(" field01 = ?,");
                                values.add(original.getSurName() + ", " + newFirstName);
                            }
                            if (null != newEmail01) {
                                sb.append(" field04 = ?,");
                                values.add(newEmail01);
                            }
                            if (values.isEmpty()) continue;
                            sb.deleteCharAt(sb.length() - 1);
                            sb.append(" WHERE cid = ? AND intfield03 IS NOT NULL AND intfield03 <> ").append(0);
                            sb.append(" AND intfield02 IS NOT NULL AND intfield02 = ? AND intfield01 = ").append(dleo.getEmailfield());
                            stmt = writecon.prepareStatement(sb.toString());
                            pos = 1;
                            for (String val : values) {
                                stmt.setString(pos++, val);
                            }
                            stmt.setInt(pos++, ctx.getContextId());
                            stmt.setInt(pos, co.getObjectID());
                            stmt.executeUpdate();
                            DBUtils.closeSQLStuff(stmt);
                        }
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            writecon.commit();
        }
        catch (OXException ox) {
            try {
                DBUtils.rollback(writecon);
                throw ox;
                catch (DataTruncation se) {
                    DBUtils.rollback(writecon);
                    throw Contacts.getTruncation(writecon, se, "prg_contacts", co);
                }
                catch (SQLException e) {
                    DBUtils.rollback(writecon);
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(ps));
                }
                catch (Exception re) {
                    DBUtils.rollback(writecon);
                    throw ContactExceptionCodes.UNEXPECTED_ERROR.create(re, re.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                if (null == writecon) throw throwable;
                DBUtils.autocommit(writecon);
                try {
                    DBPool.closeWriterSilent(ctx, writecon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to set return writeconnection");
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
        if (null == writecon) return;
        DBUtils.autocommit(writecon);
        try {
            DBPool.closeWriterSilent(ctx, writecon);
            return;
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to set return writeconnection");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void performUserContactStorageUpdate(Contact contact, java.util.Date lastModified, int userId, int[] groups, Context ctx, UserConfiguration userConfig) throws OXException {
        Contacts.validateEmailAddress(contact);
        if (!contact.containsParentFolderID() || contact.getParentFolderID() == 0) {
            contact.setParentFolderID(6);
        }
        if (!contact.containsContextId() || contact.getContextId() <= 0) {
            contact.setContextId(ctx.getContextId());
        }
        ContactMySql cs = new ContactMySql(ctx, userId);
        Contact original = null;
        Connection writecon = null;
        Connection readcon = null;
        try {
            readcon = DBPool.pickup(ctx);
            try {
                original = Contacts.getContactById(contact.getObjectID(), userId, groups, ctx, userConfig, readcon);
            }
            catch (Exception e) {
                throw ContactExceptionCodes.LOAD_OLD_CONTACT_FAILED.create(e, Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)contact.getObjectID()));
            }
            if (contact.containsEmail1() && ctx.getMailadmin() != userId && original.getInternalUserId() == userId) {
                throw ContactExceptionCodes.NO_PRIMARY_EMAIL_EDIT.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)contact.getObjectID()), Autoboxing.I((int)userId));
            }
            if (contact.getParentFolderID() != 6) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)6), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)userId));
            }
            int createdBy = original.getCreatedBy();
            if (createdBy != userId) {
                if (createdBy != ctx.getMailadmin()) {
                    throw ContactExceptionCodes.NO_CREATE_PERMISSION.create(Autoboxing.I((int)6), Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)userId));
                }
                StringBuilder stmtBuilder = cs.iFperformContactStorageUpdate(new StringBuilder(1), System.currentTimeMillis(), original.getObjectID(), ctx.getContextId());
                Connection wc = DBPool.pickupWriteable(ctx);
                PreparedStatement stmt = null;
                try {
                    stmt = wc.prepareStatement(stmtBuilder.toString());
                }
                catch (SQLException e) {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                }
                finally {
                    DBPool.closeWriterSilent(ctx, wc);
                    DBUtils.closeSQLStuff(stmt);
                }
            }
            java.util.Date server_date = original.getLastModified();
            if (DEBUG) {
                LOG.debug((Object)("Compare Dates for Contact Update\nClient-Date=" + lastModified.getTime() + "\nServer-Date=" + server_date.getTime()));
            }
            if (lastModified != null && lastModified.getTime() > -1L && lastModified.getTime() < server_date.getTime()) {
                throw ContactExceptionCodes.OBJECT_HAS_CHANGED.create();
            }
            if (contact.containsDisplayName()) {
                if (null == contact.getDisplayName()) throw ContactExceptionCodes.DISPLAY_NAME_MANDATORY.create();
                if ("".equals(contact.getDisplayName())) {
                    throw ContactExceptionCodes.DISPLAY_NAME_MANDATORY.create();
                }
            }
            if (contact.containsSurName()) {
                if (null == contact.getSurName()) throw ContactExceptionCodes.LAST_NAME_MANDATORY.create();
                if ("".equals(contact.getSurName())) {
                    throw ContactExceptionCodes.LAST_NAME_MANDATORY.create();
                }
            }
            if (contact.containsGivenName()) {
                if (null == contact.getGivenName()) throw ContactExceptionCodes.FIRST_NAME_MANDATORY.create();
                if ("".equals(contact.getGivenName())) {
                    throw ContactExceptionCodes.FIRST_NAME_MANDATORY.create();
                }
            }
            if (contact.containsDisplayName() && contact.getDisplayName() != null) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                ContactMySql csql = new ContactMySql(ctx, userId);
                csql.setFolder(contact.getParentFolderID());
                ContactSearchObject cso = new ContactSearchObject();
                cso.setDisplayName(contact.getDisplayName());
                cso.setIgnoreOwn(contact.getObjectID());
                csql.setContactSearchObject(cso);
                int[] cols = new int[]{1, 20, 500};
                csql.setSelect(csql.iFgetColsString(cols).toString());
                csql.setSearchHabit(" AND ");
                try {
                    stmt = csql.getSqlStatement(readcon);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String displayName = rs.getString(10);
                        if (!contact.getDisplayName().equalsIgnoreCase(displayName)) continue;
                        throw ContactExceptionCodes.DISPLAY_NAME_IN_USE.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)contact.getObjectID()));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            if ((!contact.containsFileAs() || contact.getFileAs() != null && contact.getFileAs().length() > 0) && contact.getDisplayName() != null) {
                contact.setFileAs(contact.getDisplayName());
            }
            Contacts.checkCharacters(contact);
        }
        finally {
            try {
                DBPool.closeReaderSilent(ctx, readcon);
            }
            catch (Exception ex) {
                LOG.error((Object)"Unable to close READ Connection", (Throwable)ex);
            }
        }
        PreparedStatement ps = null;
        StringBuilder update = new StringBuilder();
        try {
            int id;
            boolean modifiedDisplayName = false;
            int[] mod = new int[650];
            int cnt = 0;
            for (int i = 0; i < 650; ++i) {
                Mapper mapper = mapping[i];
                if (mapper == null || mapper.compare(contact, original)) continue;
                if (i == 500 && original.getInternalUserId() > 0) {
                    modifiedDisplayName = true;
                }
                mod[cnt] = i;
                ++cnt;
            }
            int[] modtrim = new int[cnt];
            System.arraycopy(mod, 0, modtrim, 0, cnt);
            if (modtrim.length <= 0) {
                throw ContactExceptionCodes.NO_CHANGES.create(Autoboxing.I((int)ctx.getContextId()), Autoboxing.I((int)contact.getObjectID()));
            }
            boolean addressBusinessChanged = false;
            boolean addressHomeChanged = false;
            boolean addressOtherChanged = false;
            for (int i = 0; i < modtrim.length; ++i) {
                int field = modtrim[i];
                Mapper mapper = mapping[field];
                if (mapper == null || !mapper.containsElement(contact) || field == 592 || field == 591 || field == 1 || i == 601) continue;
                update.append(mapper.getDBFieldName()).append(" = ?,");
            }
            if (addressBusinessChanged || addressHomeChanged || addressOtherChanged) {
                int[] tmp = new int[modtrim.length];
                System.arraycopy(modtrim, 0, tmp, 0, modtrim.length);
                java.util.Arrays.sort(tmp);
                if (addressBusinessChanged) {
                    if (java.util.Arrays.binarySearch(tmp, 614) < 0 || !contact.containsAddressBusiness()) {
                        update.append("businessAddress").append(" = ?,");
                    } else {
                        addressBusinessChanged = false;
                    }
                }
                if (addressHomeChanged) {
                    if (java.util.Arrays.binarySearch(tmp, 613) < 0 || !contact.containsAddressHome()) {
                        update.append("homeAddress").append(" = ?,");
                    } else {
                        addressHomeChanged = false;
                    }
                }
                if (addressOtherChanged) {
                    if (java.util.Arrays.binarySearch(tmp, 615) < 0 || !contact.containsAddressOther()) {
                        update.append("otherAddress").append(" = ?,");
                    } else {
                        addressOtherChanged = false;
                    }
                }
            }
            if ((id = contact.getObjectID()) == -1) {
                throw ContactExceptionCodes.NEGATIVE_OBJECT_ID.create();
            }
            long lmd = System.currentTimeMillis();
            StringBuilder updater = cs.iFperformContactStorageUpdate(update, lmd, id, ctx.getContextId());
            writecon = DBPool.pickupWriteable(ctx);
            ps = writecon.prepareStatement(updater.toString());
            int counter = 1;
            for (int i = 0; i < modtrim.length; ++i) {
                int field = modtrim[i];
                Mapper mapper = mapping[field];
                if (mapper == null || !mapper.containsElement(contact) || field == 592 || field == 591 || field == 1 || i == 601) continue;
                mapper.fillPreparedStatement(ps, counter, contact);
                ++counter;
            }
            if (addressBusinessChanged) {
                ps.setNull(counter++, 12);
            }
            if (addressHomeChanged) {
                ps.setNull(counter++, 12);
            }
            if (addressOtherChanged) {
                ps.setNull(counter++, 12);
            }
            Date ddd = new Date(lmd);
            contact.setLastModified(ddd);
            writecon.setAutoCommit(false);
            if (DEBUG) {
                LOG.debug((Object)("INFO: YOU WANT TO UPDATE THIS: cid=" + ctx.getContextId() + " oid=" + contact.getObjectID() + " -> " + Contacts.getStatementString(ps)));
            }
            ps.execute();
            if (contact.containsNumberOfDistributionLists() && contact.getSizeOfDistributionListArray() > 0) {
                Contacts.writeDistributionListArrayUpdate(contact.getDistributionList(), original.getDistributionList(), contact.getObjectID(), ctx.getContextId(), writecon);
            }
            if (contact.containsNumberOfLinks() && contact.getSizeOfLinks() > 0) {
                Contacts.writeContactLinkArrayUpdate(contact.getLinks(), original.getLinks(), contact.getObjectID(), ctx.getContextId(), writecon);
            }
            if (contact.containsImage1()) {
                if (contact.getImage1() != null) {
                    if (ContactConfig.getInstance().getProperty(PROP_SCALE_IMAGES).equalsIgnoreCase("true")) {
                        try {
                            contact.setImage1(Contacts.scaleContactImage(contact.getImage1(), contact.getImageContentType()));
                        }
                        catch (OXException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw ContactExceptionCodes.NOT_VALID_IMAGE.create(e, new Object[0]);
                        }
                    } else {
                        Contacts.checkImageSize(contact.getImage1().length, Integer.parseInt(ContactConfig.getInstance().getProperty(PROP_MAX_IMAGE_SIZE)));
                    }
                    if (original.containsImage1()) {
                        Contacts.updateContactImage(contact.getObjectID(), contact.getImage1(), ctx.getContextId(), contact.getImageContentType(), lmd, writecon);
                    } else {
                        Contacts.writeContactImage(contact.getObjectID(), contact.getImage1(), ctx.getContextId(), contact.getImageContentType(), lmd, writecon);
                    }
                } else if (original.containsImage1()) {
                    try {
                        Contacts.deleteImage(contact.getObjectID(), ctx.getContextId(), writecon);
                    }
                    catch (SQLException oxee) {
                        LOG.error((Object)"Unable to delete Contact Image", (Throwable)oxee);
                    }
                }
            }
            if (modifiedDisplayName) {
                OXFolderAdminHelper.propagateUserModification(original.getInternalUserId(), new int[]{500}, System.currentTimeMillis(), writecon, writecon, ctx.getContextId());
            }
            writecon.commit();
        }
        catch (OXException ox) {
            try {
                DBUtils.rollback(writecon);
                throw ox;
                catch (DataTruncation se) {
                    DBUtils.rollback(writecon);
                    throw Contacts.getTruncation(writecon, se, "prg_contacts", contact);
                }
                catch (SQLException e) {
                    DBUtils.rollback(writecon);
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(ps));
                }
                catch (Exception re) {
                    DBUtils.rollback(writecon);
                    throw ContactExceptionCodes.UNEXPECTED_ERROR.create(re, re.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                if (null == writecon) throw throwable;
                DBUtils.autocommit(writecon);
                try {
                    DBPool.closeWriterSilent(ctx, writecon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to set return writeconnection");
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
        if (null == writecon) return;
        DBUtils.autocommit(writecon);
        try {
            DBPool.closeWriterSilent(ctx, writecon);
            return;
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to set return writeconnection");
            return;
        }
    }

    public static Contact getUserById(int userId, int user, int[] memberInGroups, Context ctx, UserConfiguration uc, Connection readCon) throws OXException {
        ContactMySql contactSQL = new ContactMySql(ctx, user);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 650; ++i) {
            Mapper mapper = mapping[i];
            if (mapper == null) continue;
            sb.append(',');
            sb.append("co.");
            sb.append(mapper.getDBFieldName());
        }
        sb.deleteCharAt(0);
        sb = contactSQL.iFgetContactById(sb.toString());
        contactSQL.setSelect(sb.toString());
        contactSQL.setInternalUser(userId);
        return Contacts.fillContactObject(contactSQL, userId, user, memberInGroups, ctx, uc, readCon);
    }

    public static Contact[] getUsersById(int[] userIds, int user, int[] memberInGroups, Context ctx, UserConfiguration uc, Connection readCon) throws OXException {
        ContactMySql contactSQL = new ContactMySql(ctx, user);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 650; ++i) {
            Mapper mapper = mapping[i];
            if (mapper == null) continue;
            sb.append(',');
            sb.append("co.");
            sb.append(mapper.getDBFieldName());
        }
        sb.deleteCharAt(0);
        contactSQL.setSelect(contactSQL.iFgetContactById(sb.toString()).toString());
        TIntObjectHashMap contacts2 = new TIntObjectHashMap(userIds.length, 1.0f);
        for (int i = 0; i < userIds.length; i += 1000) {
            contactSQL.setInternalUsers(Arrays.extract((int[])userIds, (int)i, (int)1000));
            contacts2.putAll(Contacts.fillContactObject(contactSQL, user, memberInGroups, ctx, uc, readCon));
        }
        Contact[] retval = new Contact[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            Contact contact = (Contact)contacts2.get(userIds[i]);
            if (null == contact) {
                throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Autoboxing.I((int)userIds[i]), Autoboxing.I((int)ctx.getContextId()));
            }
            retval[i] = contact;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Contact getContactById(int objectId, Session session) throws OXException {
        Contact co;
        Context ctx = ContextStorage.getStorageContext(session);
        int[] groups = UserStorage.getStorageUser(session.getUserId(), ctx).getGroups();
        Connection readCon = DBPool.pickup(ctx);
        try {
            UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), ctx);
            co = Contacts.getContactById(objectId, session.getUserId(), groups, ctx, uc, readCon);
        }
        finally {
            DBPool.closeReaderSilent(ctx, readCon);
        }
        return co;
    }

    public static Contact getContactById(int objectId, int userId, int[] memberInGroups, Context ctx, UserConfiguration uc, Connection readCon) throws OXException {
        Contact co = null;
        ContactMySql contactSQL = new ContactMySql(ctx, userId);
        StringBuilder sb = new StringBuilder(512);
        for (int i = 0; i < 650; ++i) {
            Mapper mapper = mapping[i];
            if (mapper == null) continue;
            sb.append(',');
            sb.append("co.");
            sb.append(mapper.getDBFieldName());
        }
        sb.deleteCharAt(0);
        sb = contactSQL.iFgetContactById(sb.toString());
        contactSQL.setSelect(sb.toString());
        contactSQL.setObjectID(objectId);
        co = Contacts.fillContactObject(contactSQL, objectId, userId, memberInGroups, ctx, uc, readCon);
        return co;
    }

    private static Contact fillContactObject(ContactSql contactSQL, int objectId, int user, int[] group, Context ctx, UserConfiguration uc, Connection con) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Contact co;
        block6: {
            co = new Contact();
            stmt = null;
            rs = null;
            try {
                stmt = contactSQL.getSqlStatement(con);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int cnt = 1;
                    for (int i = 0; i < 650; ++i) {
                        Mapper mapper = mapping[i];
                        if (mapper == null) continue;
                        mapper.addToContactObject(rs, cnt, co, con, user, group, ctx, uc);
                        ++cnt;
                    }
                    break block6;
                }
                throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Autoboxing.I((int)objectId), Autoboxing.I((int)ctx.getContextId()));
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return co;
    }

    private static TIntObjectMap<Contact> fillContactObject(ContactSql contactSQL, int user, int[] group, Context ctx, UserConfiguration uc, Connection con) throws OXException {
        TIntObjectHashMap contacts2 = new TIntObjectHashMap();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = contactSQL.getSqlStatement(con);
            result = stmt.executeQuery();
            while (result.next()) {
                Contact contact = new Contact();
                int cnt = 1;
                for (int i = 0; i < 650; ++i) {
                    Mapper mapper = mapping[i];
                    if (mapper == null) continue;
                    mapper.addToContactObject(result, cnt, contact, con, user, group, ctx, uc);
                    ++cnt;
                }
                contacts2.put(contact.getInternalUserId(), (Object)contact);
            }
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return contacts2;
    }

    public static void deleteContact(int id, int cid, Connection writecon) throws OXException {
        Contacts.deleteContact(id, cid, writecon, false);
    }

    public static void deleteContact(int id, int cid, Connection writecon, boolean admin_delete) throws OXException {
        Statement del = null;
        try {
            del = writecon.createStatement();
            Contacts.trashDistributionList(id, cid, writecon, false);
            Contacts.trashLinks(id, cid, writecon, false);
            Contacts.trashImage(id, cid, writecon, false);
            ContactMySql cs = new ContactMySql(null);
            if (admin_delete) {
                cs.iFtrashTheAdmin(del, cid, id);
            } else {
                cs.iFdeleteContact(id, cid, del);
            }
        }
        catch (SQLException e) {
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(del);
        }
    }

    public static DistributionListEntryObject[] fillDistributionListArray(int id, int user, Context ctx, Connection readcon) throws OXException {
        Statement stmt = null;
        ResultSet rs = null;
        DistributionListEntryObject[] r = null;
        try {
            ContactMySql cs = new ContactMySql(ctx, user);
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(cs.iFfillDistributionListArray(id, ctx.getContextId()));
            rs.last();
            int size = rs.getRow();
            rs.beforeFirst();
            DistributionListEntryObject[] dleos = new DistributionListEntryObject[size];
            DistributionListEntryObject dleo = null;
            String displayname = null;
            String lastname = null;
            String firstname = null;
            int emailfield = 0;
            int objectid = 0;
            int folderid = 0;
            int cnt = 0;
            while (rs.next()) {
                dleo = new DistributionListEntryObject();
                displayname = rs.getString(5);
                if (!rs.wasNull()) {
                    dleo.setDisplayname(displayname);
                }
                lastname = rs.getString(6);
                if (!rs.wasNull()) {
                    dleo.setLastname(lastname);
                }
                firstname = rs.getString(7);
                if (!rs.wasNull()) {
                    dleo.setFirstname(firstname);
                }
                dleo.setEmailaddress(rs.getString(8));
                objectid = rs.getInt(2);
                if (!rs.wasNull() && objectid > 0) {
                    dleo.setEntryID(objectid);
                }
                emailfield = rs.getInt(3);
                if (!rs.wasNull()) {
                    dleo.setEmailfield(emailfield);
                }
                folderid = rs.getInt(4);
                if (!rs.wasNull()) {
                    dleo.setFolderID(folderid);
                }
                dleos[cnt] = dleo;
                ++cnt;
            }
            r = new DistributionListEntryObject[cnt];
            System.arraycopy(dleos, 0, r, 0, cnt);
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return r;
    }

    public static void writeDistributionListArrayInsert(DistributionListEntryObject[] dleos, int id, int cid, Connection writecon) throws OXException {
        DistributionListEntryObject dleo = null;
        PreparedStatement ps = null;
        try {
            ContactMySql cs = new ContactMySql(null);
            ps = writecon.prepareStatement(cs.iFwriteDistributionListArrayInsert());
            for (int i = 0; i < dleos.length; ++i) {
                dleo = dleos[i];
                ps.setInt(1, id);
                ps.setBytes(10, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                if (dleo.containsEntryID() && dleo.getEntryID() > 0) {
                    ps.setInt(2, dleo.getEntryID());
                    ps.setInt(3, dleo.getEmailfield());
                    ps.setInt(9, dleo.getFolderID());
                } else {
                    ps.setNull(2, 4);
                    ps.setNull(3, 4);
                    ps.setNull(9, 4);
                }
                if (dleo.containsDisplayname()) {
                    ps.setString(4, dleo.getDisplayname());
                } else if (dleo.containsLastname() && dleo.getLastname() != null && dleo.containsFistname() && dleo.getFirstname() != null) {
                    ps.setString(4, dleo.getLastname() + ", " + dleo.getFirstname());
                } else if (dleo.containsLastname() && dleo.getLastname() != null && !dleo.containsFistname()) {
                    ps.setString(4, dleo.getLastname());
                } else {
                    ps.setNull(4, 12);
                }
                if (dleo.containsLastname() && dleo.getLastname() != null) {
                    ps.setString(5, dleo.getLastname());
                } else {
                    ps.setNull(5, 12);
                }
                if (dleo.containsFistname() && dleo.getFirstname() != null) {
                    ps.setString(6, dleo.getFirstname());
                } else {
                    ps.setNull(6, 12);
                }
                ps.setString(7, dleo.getEmailaddress());
                ps.setInt(8, cid);
                if (DEBUG) {
                    LOG.debug((Object)new StringBuilder("WRITE DLIST ").append(Contacts.getStatementString(ps)));
                }
                ps.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
    }

    public static void writeDistributionListArrayUpdate(DistributionListEntryObject[] dleos, DistributionListEntryObject[] old_dleos, int id, int cid, Connection writecon) throws OXException {
        DistributionListEntryObject new_one = null;
        DistributionListEntryObject old_one = null;
        int sizey = (dleos == null ? 0 : dleos.length) + (old_dleos == null ? 0 : old_dleos.length);
        DistributionListEntryObject[] inserts = new DistributionListEntryObject[sizey];
        DistributionListEntryObject[] updates = new DistributionListEntryObject[sizey];
        DistributionListEntryObject[] deletes = new DistributionListEntryObject[sizey];
        int insert_count = 0;
        int update_count = 0;
        int delete_count = 0;
        if (null != dleos) {
            for (int i = 0; i < dleos.length; ++i) {
                new_one = dleos[i];
                if (new_one.containsEntryID() && new_one.getEntryID() > 0) {
                    boolean actions = false;
                    if (old_dleos != null) {
                        for (int u = 0; u < old_dleos.length; ++u) {
                            if (old_dleos[u] == null) continue;
                            old_one = old_dleos[u];
                            if (new_one.searchDlistObject(old_one)) {
                                if (!new_one.compareDlistObject(old_one)) {
                                    updates[insert_count] = new_one;
                                    ++update_count;
                                    actions = true;
                                } else {
                                    actions = true;
                                }
                                old_dleos[u] = null;
                                break;
                            }
                            actions = false;
                        }
                    }
                    if (actions) continue;
                    inserts[insert_count] = new_one;
                    ++insert_count;
                    continue;
                }
                inserts[insert_count] = new_one;
                ++insert_count;
            }
        }
        if (old_dleos != null) {
            for (int u = 0; u < old_dleos.length; ++u) {
                old_one = old_dleos[u];
                if (old_one == null || !old_one.containsEntryID() || old_one.getEntryID() <= 0) continue;
                deletes[delete_count] = old_one;
                ++delete_count;
            }
        }
        DistributionListEntryObject[] insertcut = new DistributionListEntryObject[insert_count];
        System.arraycopy(inserts, 0, insertcut, 0, insert_count);
        DistributionListEntryObject[] updatecut = new DistributionListEntryObject[update_count];
        System.arraycopy(updates, 0, updatecut, 0, update_count);
        DistributionListEntryObject[] deletecut = new DistributionListEntryObject[delete_count];
        System.arraycopy(deletes, 0, deletecut, 0, delete_count);
        Contacts.deleteDistributionListEntriesByIds(id, deletecut, cid, writecon);
        Contacts.updateDistributionListEntriesByIds(id, updatecut, cid, writecon);
        Contacts.writeDistributionListArrayInsert(insertcut, id, cid, writecon);
    }

    public static void updateDistributionListEntriesByIds(int id, DistributionListEntryObject[] dleos, int cid, Connection writecon) throws OXException {
        if (dleos.length > 0) {
            PreparedStatement ps = null;
            try {
                ContactMySql cs = new ContactMySql(null);
                ps = writecon.prepareStatement(cs.iFupdateDistributionListEntriesByIds());
                for (int i = 0; i < dleos.length; ++i) {
                    DistributionListEntryObject dleo = dleos[i];
                    if (null == dleo) continue;
                    ps.setInt(1, id);
                    ps.setInt(9, id);
                    if (dleo.containsEntryID() && dleo.getEntryID() > 0) {
                        ps.setInt(2, dleo.getEntryID());
                        ps.setInt(3, dleo.getEmailfield());
                        ps.setInt(10, dleo.getEntryID());
                        ps.setInt(11, dleo.getEmailfield());
                        ps.setInt(4, dleo.getFolderID());
                    } else {
                        ps.setNull(2, 4);
                        ps.setNull(3, 4);
                        ps.setNull(10, 4);
                        ps.setNull(11, 4);
                        ps.setNull(4, 4);
                    }
                    if (dleo.containsDisplayname()) {
                        ps.setString(5, dleo.getDisplayname());
                    } else if (dleo.containsLastname() && dleo.containsFistname()) {
                        ps.setString(5, dleo.getLastname() + ", " + dleo.getFirstname());
                    } else if (dleo.containsLastname() && !dleo.containsFistname()) {
                        ps.setString(5, dleo.getLastname());
                    } else {
                        ps.setString(5, "unknown");
                    }
                    if (dleo.containsLastname()) {
                        ps.setString(6, dleo.getLastname());
                    } else {
                        ps.setNull(6, 12);
                    }
                    if (dleo.containsFistname()) {
                        ps.setString(7, dleo.getFirstname());
                    } else {
                        ps.setNull(7, 12);
                    }
                    ps.setString(8, dleo.getEmailaddress());
                    ps.setInt(12, cid);
                    if (DEBUG) {
                        LOG.debug((Object)new StringBuilder("UPDATE DLIST ").append(Contacts.getStatementString(ps)));
                    }
                    ps.execute();
                }
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(ps);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(ps);
        }
    }

    public static void deleteDistributionListEntriesByIds(int id, DistributionListEntryObject[] dleos, int cid, Connection writecon) throws OXException {
        PreparedStatement ps = null;
        DistributionListEntryObject dleo = null;
        ContactMySql cs = null;
        try {
            cs = new ContactMySql(null);
            ps = writecon.prepareStatement(cs.iFdeleteDistributionListEntriesByIds(cid));
            ps.setInt(1, id);
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder("DELETE FROM DLIST ").append(Contacts.getStatementString(ps)));
            }
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
        if (dleos.length > 0) {
            try {
                ps = writecon.prepareStatement(cs.iFdeleteDistributionListEntriesByIds2());
                for (int i = 0; i < dleos.length; ++i) {
                    dleo = dleos[i];
                    ps.setInt(1, id);
                    if (dleo.containsEntryID() && dleo.getEntryID() > 0) {
                        ps.setInt(2, dleo.getEntryID());
                        ps.setInt(3, dleo.getEmailfield());
                    }
                    ps.setInt(4, cid);
                    if (DEBUG) {
                        LOG.debug((Object)new StringBuilder("DELETE FROM DLIST ").append(Contacts.getStatementString(ps)));
                    }
                    ps.execute();
                }
            }
            catch (SQLException e) {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(ps));
            }
            finally {
                DBUtils.closeSQLStuff(ps);
            }
        }
    }

    public static LinkEntryObject[] fillLinkArray(Contact co, int user, Context ctx, Connection readcon) throws OXException {
        Statement stmt = null;
        ResultSet rs = null;
        LinkEntryObject[] r = null;
        ContactMySql cs = new ContactMySql(ctx, user);
        try {
            int id = co.getObjectID();
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(cs.iFgetFillLinkArrayString(id, ctx.getContextId()));
            rs.last();
            int size = rs.getRow();
            rs.beforeFirst();
            LinkEntryObject[] leos = new LinkEntryObject[size];
            LinkEntryObject leo = null;
            String contact_displayname = null;
            String link_displayname = null;
            int linkid = 0;
            int cnt = 0;
            while (rs.next()) {
                leo = new LinkEntryObject();
                leo.setContactID(id);
                contact_displayname = rs.getString(3);
                if (!rs.wasNull()) {
                    leo.setContactDisplayname(contact_displayname);
                }
                link_displayname = rs.getString(4);
                if (!rs.wasNull()) {
                    leo.setLinkDisplayname(link_displayname);
                }
                linkid = rs.getInt(2);
                if (!rs.wasNull()) {
                    leo.setLinkID(linkid);
                }
                leos[cnt] = leo;
                ++cnt;
            }
            r = new LinkEntryObject[cnt];
            System.arraycopy(leos, 0, r, 0, cnt);
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return r;
    }

    public static void writeContactLinkArrayInsert(LinkEntryObject[] leos, int id, int cid, Connection writecon) throws OXException {
        LinkEntryObject leo = null;
        PreparedStatement ps = null;
        try {
            ContactMySql cs = new ContactMySql(null);
            ps = writecon.prepareStatement(cs.iFwriteContactLinkArrayInsert());
            for (int i = 0; i < leos.length; ++i) {
                leo = leos[i];
                ps.setInt(1, id);
                ps.setInt(2, leo.getLinkID());
                ps.setString(3, leo.getContactDisplayname());
                ps.setString(4, leo.getLinkDisplayname());
                ps.setInt(5, cid);
                UUID uuid = UUID.randomUUID();
                byte[] uuidBinary = UUIDs.toByteArray((UUID)uuid);
                ps.setBytes(6, uuidBinary);
                if (DEBUG) {
                    LOG.debug((Object)new StringBuilder("INSERT LINKAGE ").append(Contacts.getStatementString(ps)));
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
    }

    public static void writeContactLinkArrayUpdate(LinkEntryObject[] leos, LinkEntryObject[] original, int id, int cid, Connection writecon) throws OXException {
        int i;
        int sizey = (null == leos ? 0 : leos.length) + (null == original ? 0 : original.length);
        LinkEntryObject[] inserts = new LinkEntryObject[sizey];
        LinkEntryObject[] deletes = new LinkEntryObject[sizey];
        int delete_count = 0;
        int insert_count = 0;
        if (null != leos) {
            for (i = 0; i < leos.length; ++i) {
                LinkEntryObject new_leo = leos[i];
                boolean action = false;
                if (original != null) {
                    for (int u = 0; u < original.length; ++u) {
                        LinkEntryObject old_leo = original[u];
                        if (new_leo.compare(old_leo)) {
                            original[u] = null;
                            action = true;
                            break;
                        }
                        action = false;
                    }
                }
                if (action) continue;
                inserts[insert_count] = new_leo;
                ++insert_count;
            }
        }
        if (original != null) {
            for (i = 0; i < original.length; ++i) {
                LinkEntryObject del_leo = original[i];
                if (del_leo == null) continue;
                deletes[delete_count] = del_leo;
                ++delete_count;
            }
        }
        LinkEntryObject[] deletecut = new LinkEntryObject[delete_count];
        System.arraycopy(deletes, 0, deletecut, 0, delete_count);
        LinkEntryObject[] insertcut = new LinkEntryObject[insert_count];
        System.arraycopy(inserts, 0, insertcut, 0, insert_count);
        Contacts.deleteLinkEntriesByIds(id, deletecut, cid, writecon);
        Contacts.writeContactLinkArrayInsert(insertcut, id, cid, writecon);
    }

    public static void deleteLinkEntriesByIds(int id, LinkEntryObject[] leos, int cid, Connection writecon) throws OXException {
        if (leos.length > 0) {
            LinkEntryObject leo = null;
            PreparedStatement ps = null;
            try {
                ContactMySql cs = new ContactMySql(null);
                ps = writecon.prepareStatement(cs.iFgetdeleteLinkEntriesByIdsString());
                for (int i = 0; i < leos.length; ++i) {
                    leo = leos[i];
                    ps.setInt(1, id);
                    ps.setInt(2, leo.getLinkID());
                    ps.setInt(3, cid);
                    if (DEBUG) {
                        LOG.debug((Object)new StringBuilder("DELETE LINKAGE ENTRY").append(Contacts.getStatementString(ps)));
                    }
                    ps.execute();
                }
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(ps);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(ps);
        }
    }

    public static Date getContactImageLastModified(int id, int cid, Connection readcon) throws SQLException, OXException {
        Date last_mod = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ContactMySql cs = new ContactMySql(null);
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(cs.iFgetContactImageLastModified(id, cid));
            if (rs.next()) {
                last_mod = new Date(rs.getLong(1));
            }
        }
        catch (SQLException sxe) {
            try {
                throw sxe;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return last_mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContactImageContentType(int id, int cid, Connection readcon) throws SQLException, OXException {
        ResultSet rs;
        Statement stmt;
        block3: {
            String string;
            stmt = null;
            rs = null;
            try {
                ContactMySql cs = new ContactMySql(null);
                stmt = readcon.createStatement();
                rs = stmt.executeQuery(cs.iFgetContactImageContentType(id, cid));
                if (!rs.next()) break block3;
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return string;
        }
        String string = null;
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    public static void getContactImage(int contact_id, Contact co, int cid, Connection readcon) throws OXException {
        ResultSet rs;
        Statement stmt;
        block5: {
            Date last_mod = null;
            stmt = null;
            rs = null;
            try {
                ContactMySql cs = new ContactMySql(null);
                stmt = readcon.createStatement();
                rs = stmt.executeQuery(cs.iFgetContactImage(contact_id, cid));
                if (!rs.next()) break block5;
                byte[] bb = rs.getBytes(1);
                if (!rs.wasNull()) {
                    last_mod = new Date(rs.getLong(2));
                    co.setImageLastModified(last_mod);
                    co.setImage1(bb);
                    co.setImageContentType(rs.getString(3));
                }
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    public static void writeContactImage(int contact_id, byte[] img, int cid, String mime, long lastModified, Connection writecon) throws OXException, OXException {
        if (contact_id < 1 || img == null || img.length < 1 || cid < 1 || mime == null || mime.length() < 1) {
            throw ContactExceptionCodes.IMAGE_BROKEN.create();
        }
        PreparedStatement ps = null;
        try {
            ContactMySql cs = new ContactMySql(null);
            ps = writecon.prepareStatement(cs.iFwriteContactImage());
            ps.setInt(1, contact_id);
            ps.setBytes(2, img);
            ps.setString(3, mime);
            ps.setInt(4, cid);
            ps.setLong(5, lastModified);
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder("INSERT IMAGE ").append(Contacts.getStatementString(ps)));
            }
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
    }

    public static void updateContactImage(int contact_id, byte[] img, int cid, String mime, long lastModified, Connection writecon) throws OXException, OXException {
        if (contact_id < 1 || img == null || img.length < 1 || cid < 1 || mime == null || mime.length() < 1) {
            throw ContactExceptionCodes.IMAGE_BROKEN.create();
        }
        PreparedStatement ps = null;
        try {
            ContactMySql cs = new ContactMySql(null);
            ps = writecon.prepareStatement(cs.iFupdateContactImageString());
            ps.setInt(1, contact_id);
            ps.setBytes(2, img);
            ps.setString(3, mime);
            ps.setInt(4, cid);
            ps.setLong(5, lastModified);
            ps.setInt(6, contact_id);
            ps.setInt(7, cid);
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder("UPDATE IMAGE ").append(Contacts.getStatementString(ps)));
            }
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean performContactReadCheckByID(int objectId, int user, Context ctx, UserConfiguration uc) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        ResultSet rs;
        Connection readCon;
        block29: {
            int created_from;
            int fid;
            block28: {
                boolean pflag;
                block27: {
                    readCon = null;
                    rs = null;
                    stmt = null;
                    ContactMySql cs = new ContactMySql(ctx, user);
                    cs.setSelect(cs.iFgetRightsSelectString());
                    cs.setObjectID(objectId);
                    readCon = DBPool.pickup(ctx);
                    stmt = cs.getSqlStatement(readCon);
                    rs = stmt.executeQuery();
                    fid = -1;
                    created_from = -1;
                    pflag = false;
                    if (rs.next()) {
                        fid = rs.getInt(5);
                        created_from = rs.getInt(6);
                        int xx = rs.getInt(7);
                        if (!rs.wasNull() && xx == 1) {
                            pflag = true;
                        }
                        break block27;
                    }
                    boolean bl2 = false;
                    DBUtils.closeSQLStuff(rs, stmt);
                    try {
                        if (readCon != null) {
                            DBPool.closeReaderSilent(ctx, readCon);
                        }
                    }
                    catch (Exception see) {
                        LOG.error((Object)"Unable to return Connection", (Throwable)see);
                    }
                    return bl2;
                }
                if (!pflag || created_from == user) break block28;
                bl = false;
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ctx, readCon);
                    }
                }
                catch (Exception see) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)see);
                }
                return bl;
            }
            if (fid == -1 || created_from == -1) break block29;
            bl = Contacts.performContactReadCheck(fid, created_from, user, ctx, uc, readCon);
            DBUtils.closeSQLStuff(rs, stmt);
            try {
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
            catch (Exception see) {
                LOG.error((Object)"Unable to return Connection", (Throwable)see);
            }
            return bl;
        }
        bl = false;
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readCon != null) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
        }
        catch (Exception see) {
            LOG.error((Object)"Unable to return Connection", (Throwable)see);
        }
        return bl;
        catch (SQLException e) {
            boolean bl3;
            try {
                LOG.error((Object)("UNABLE TO performContactReadCheckByID cid=" + ctx.getContextId() + " oid=" + objectId), (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ctx, readCon);
                    }
                }
                catch (Exception see) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)see);
                }
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            try {
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
            catch (Exception see) {
                LOG.error((Object)"Unable to return Connection", (Throwable)see);
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean performContactReadCheckByID(int folderId, int objectId, int user, Context ctx, UserConfiguration uc) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        ResultSet rs;
        Connection readCon;
        block34: {
            int created_from;
            int fid;
            block33: {
                block32: {
                    boolean pflag;
                    block31: {
                        readCon = null;
                        rs = null;
                        stmt = null;
                        ContactMySql cs = new ContactMySql(ctx, user);
                        cs.setSelect(cs.iFgetRightsSelectString());
                        cs.setObjectID(objectId);
                        readCon = DBPool.pickup(ctx);
                        stmt = cs.getSqlStatement(readCon);
                        rs = stmt.executeQuery();
                        fid = -1;
                        created_from = -1;
                        pflag = false;
                        if (rs.next()) {
                            fid = rs.getInt(5);
                            created_from = rs.getInt(6);
                            int xx = rs.getInt(7);
                            if (!rs.wasNull() && xx == 1) {
                                pflag = true;
                            }
                            break block31;
                        }
                        boolean bl2 = false;
                        DBUtils.closeSQLStuff(rs, stmt);
                        try {
                            if (readCon != null) {
                                DBPool.closeReaderSilent(ctx, readCon);
                            }
                        }
                        catch (Exception see) {
                            LOG.error((Object)"Unable to return Connection", (Throwable)see);
                        }
                        return bl2;
                    }
                    if (!pflag || created_from == user) break block32;
                    bl = false;
                    DBUtils.closeSQLStuff(rs, stmt);
                    try {
                        if (readCon != null) {
                            DBPool.closeReaderSilent(ctx, readCon);
                        }
                    }
                    catch (Exception see) {
                        LOG.error((Object)"Unable to return Connection", (Throwable)see);
                    }
                    return bl;
                }
                if (fid == folderId) break block33;
                bl = false;
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ctx, readCon);
                    }
                }
                catch (Exception see) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)see);
                }
                return bl;
            }
            if (fid == -1 || created_from == -1) break block34;
            bl = Contacts.performContactReadCheck(fid, created_from, user, ctx, uc, readCon);
            DBUtils.closeSQLStuff(rs, stmt);
            try {
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
            catch (Exception see) {
                LOG.error((Object)"Unable to return Connection", (Throwable)see);
            }
            return bl;
        }
        bl = false;
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readCon != null) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
        }
        catch (Exception see) {
            LOG.error((Object)"Unable to return Connection", (Throwable)see);
        }
        return bl;
        catch (SQLException e) {
            boolean bl3;
            try {
                LOG.error((Object)("UNABLE TO performContactReadCheckByID cid=" + ctx.getContextId() + " oid=" + objectId), (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ctx, readCon);
                    }
                }
                catch (Exception see) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)see);
                }
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            try {
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
            catch (Exception see) {
                LOG.error((Object)"Unable to return Connection", (Throwable)see);
            }
            return bl3;
        }
    }

    public static boolean performContactReadCheck(int folderId, int created_from, int user, Context ctx, UserConfiguration uc, Connection readCon) {
        try {
            FolderObject contactFolder = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                return false;
            }
            OXFolderAccess oxfs = new OXFolderAccess(readCon, ctx);
            EffectivePermission oclPerm = oxfs.getFolderPermission(folderId, user, uc);
            if (oclPerm.getFolderPermission() <= 0) {
                return false;
            }
            if (!oclPerm.canReadAllObjects()) {
                return oclPerm.canReadOwnObjects() && created_from == user;
            }
            return true;
        }
        catch (OXException e) {
            LOG.error((Object)("UNABLE TO PERFORM performContactReadCheck cid=" + ctx.getContextId() + " fid=" + folderId), (Throwable)e);
            return false;
        }
    }

    public static boolean performContactReadCheck(FolderObject folder, int user, int createdFrom, UserConfiguration uc, Connection readCon) {
        try {
            if (folder.getModule() != 3) {
                return false;
            }
            EffectivePermission oclPerm = folder.getEffectiveUserPermission(user, uc, readCon);
            if (oclPerm.getFolderPermission() <= 0) {
                return false;
            }
            if (!oclPerm.canReadAllObjects()) {
                return oclPerm.canReadOwnObjects() && createdFrom == user;
            }
            return true;
        }
        catch (SQLException e) {
            OXException e1 = ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
            return false;
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean performContactWriteCheckByID(int folderId, int objectId, int user, Context ctx, UserConfiguration uc) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        ResultSet rs;
        Connection readCon;
        block34: {
            int created_from;
            int fid;
            block33: {
                block32: {
                    boolean pflag;
                    block31: {
                        readCon = null;
                        rs = null;
                        stmt = null;
                        ContactMySql cs = new ContactMySql(ctx, user);
                        cs.setSelect(cs.iFgetRightsSelectString());
                        cs.setObjectID(objectId);
                        readCon = DBPool.pickup(ctx);
                        stmt = cs.getSqlStatement(readCon);
                        rs = stmt.executeQuery();
                        fid = -1;
                        created_from = -1;
                        pflag = false;
                        if (rs.next()) {
                            fid = rs.getInt(5);
                            created_from = rs.getInt(6);
                            int xx = rs.getInt(7);
                            if (!rs.wasNull() && xx == 1) {
                                pflag = true;
                            }
                            break block31;
                        }
                        boolean bl2 = false;
                        DBUtils.closeSQLStuff(rs, stmt);
                        try {
                            if (readCon != null) {
                                DBPool.closeReaderSilent(ctx, readCon);
                            }
                        }
                        catch (Exception see) {
                            LOG.error((Object)"Unable to return Connection", (Throwable)see);
                        }
                        return bl2;
                    }
                    if (!pflag || created_from == user) break block32;
                    bl = false;
                    DBUtils.closeSQLStuff(rs, stmt);
                    try {
                        if (readCon != null) {
                            DBPool.closeReaderSilent(ctx, readCon);
                        }
                    }
                    catch (Exception see) {
                        LOG.error((Object)"Unable to return Connection", (Throwable)see);
                    }
                    return bl;
                }
                if (fid == folderId) break block33;
                bl = false;
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ctx, readCon);
                    }
                }
                catch (Exception see) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)see);
                }
                return bl;
            }
            if (fid == -1 || created_from == -1) break block34;
            bl = Contacts.performContactWriteCheck(fid, created_from, user, ctx, uc, readCon);
            DBUtils.closeSQLStuff(rs, stmt);
            try {
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
            catch (Exception see) {
                LOG.error((Object)"Unable to return Connection", (Throwable)see);
            }
            return bl;
        }
        bl = false;
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readCon != null) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
        }
        catch (Exception see) {
            LOG.error((Object)"Unable to return Connection", (Throwable)see);
        }
        return bl;
        catch (SQLException e) {
            boolean bl3;
            try {
                LOG.error((Object)("UNABLE TO performContactWriteCheckByID cid=" + ctx.getContextId() + " oid=" + objectId), (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ctx, readCon);
                    }
                }
                catch (Exception see) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)see);
                }
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            try {
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
            catch (Exception see) {
                LOG.error((Object)"Unable to return Connection", (Throwable)see);
            }
            return bl3;
        }
    }

    public static boolean performContactWriteCheck(int folderId, int created_from, int user, Context ctx, UserConfiguration uc, Connection readCon) {
        try {
            FolderObject contactFolder = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                return false;
            }
            OXFolderAccess oxfs = new OXFolderAccess(readCon, ctx);
            EffectivePermission oclPerm = oxfs.getFolderPermission(folderId, user, uc);
            if (oclPerm.getFolderPermission() <= 0) {
                return false;
            }
            if (!oclPerm.canWriteAllObjects()) {
                return oclPerm.canWriteOwnObjects() && created_from == user;
            }
            return true;
        }
        catch (OXException e) {
            LOG.error((Object)("UNABLE TO PERFORM performContactWriteCheck cid=" + ctx.getContextId() + " fid=" + folderId), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsForeignObjectInFolder(int fid, int uid, Session so) throws OXException {
        boolean bl;
        Connection readCon = null;
        Context ct = null;
        try {
            ct = ContextStorage.getStorageContext(so.getContextId());
            readCon = DBPool.pickup(ct);
            bl = Contacts.containsForeignObjectInFolder(fid, uid, so, readCon);
        }
        catch (Throwable throwable) {
            DBPool.closeReaderSilent(ct, readCon);
            throw throwable;
        }
        DBPool.closeReaderSilent(ct, readCon);
        return bl;
    }

    public static boolean containsForeignObjectInFolder(int fid, int uid, Session so, Connection readCon) throws OXException {
        boolean bl;
        Statement stmt;
        ResultSet rs;
        block5: {
            rs = null;
            stmt = null;
            stmt = readCon.createStatement();
            ContactMySql cs = new ContactMySql(null);
            rs = stmt.executeQuery(cs.iFcontainsForeignObjectInFolder(fid, uid, so.getContextId()));
            if (!rs.next()) break block5;
            boolean bl2 = true;
            DBUtils.closeSQLStuff(rs, stmt);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsAnyObjectInFolder(int fid, Context cx) throws OXException {
        boolean bl;
        Connection readCon = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            readCon = DBPool.pickup(cx);
            st = readCon.createStatement();
            ContactMySql cs = new ContactMySql(null);
            rs = st.executeQuery(cs.iFgetFolderSelectString(fid, cx.getContextId()));
            bl = rs.next();
        }
        catch (SQLException se) {
            boolean bl2;
            try {
                LOG.error((Object)("Unable to perform containsAnyObjectInFolder check. Cid: " + cx.getContextId() + " Fid: " + fid + " Cause:" + se));
                bl2 = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, st, readCon, true, cx);
                throw throwable;
            }
            DBUtils.closeResources(rs, st, readCon, true, cx);
            return bl2;
        }
        DBUtils.closeResources(rs, st, readCon, true, cx);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsAnyObjectInFolder(int fid, Connection readCon, Context cx) throws OXException {
        boolean bl;
        ResultSet rs = null;
        Statement st = null;
        try {
            st = readCon.createStatement();
            ContactMySql cs = new ContactMySql(null);
            rs = st.executeQuery(cs.iFgetFolderSelectString(fid, cx.getContextId()));
            bl = rs.next();
        }
        catch (SQLException se) {
            boolean bl2;
            try {
                LOG.error((Object)("Unable to perform containsAnyObjectInFolder check. Cid: " + cx.getContextId() + " Fid: " + fid + " Cause:" + se));
                bl2 = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, st);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, st);
            return bl2;
        }
        DBUtils.closeSQLStuff(rs, st);
        return bl;
    }

    public static void deleteContactsFromFolder(int fid, Session so, Connection readcon, Connection writecon) throws OXException {
        Contacts.trashContactsFromFolder(fid, so, readcon, writecon, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void trashContactsFromFolder(int fid, Session so, Connection readcon, Connection writecon, boolean delit) throws OXException {
        PreparedStatement read = null;
        Statement del = null;
        ResultSet rs = null;
        boolean deleteIt = delit;
        try {
            del = writecon.createStatement();
            Context ct = ContextStorage.getStorageContext(so.getContextId());
            FolderObject contactFolder = new OXFolderAccess(readcon, ct).getFolderObject(fid);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)fid), Autoboxing.I((int)so.getContextId()), Autoboxing.I((int)so.getUserId()));
            }
            if (contactFolder.getType() == 1) {
                deleteIt = true;
            }
            ContactMySql cs = new ContactMySql(so);
            cs.setFolder(fid);
            cs.setSelect(cs.iFgetRightsSelectString());
            read = cs.getSqlStatement(readcon);
            rs = read.executeQuery();
            EventClient ec = new EventClient(so);
            int oid = 0;
            int dlist = 0;
            int link = 0;
            int image = 0;
            int created_from = 0;
            while (rs.next()) {
                oid = rs.getInt(1);
                dlist = rs.getInt(2);
                if (!rs.wasNull() && dlist > 0) {
                    Contacts.trashDistributionList(oid, so.getContextId(), writecon, deleteIt);
                }
                link = rs.getInt(3);
                if (!rs.wasNull() && link > 0) {
                    Contacts.trashLinks(oid, so.getContextId(), writecon, deleteIt);
                }
                image = rs.getInt(4);
                if (!rs.wasNull() && image > 0) {
                    Contacts.trashImage(oid, so.getContextId(), writecon, deleteIt);
                }
                created_from = rs.getInt(6);
                cs.iFtrashContactsFromFolder(deleteIt, del, oid, so.getContextId());
                Contact co = new Contact();
                co.setCreatedBy(created_from);
                co.setParentFolderID(fid);
                co.setObjectID(oid);
                ec.delete(co);
            }
            if (DEBUG) {
                LOG.debug((Object)cs.iFtrashContactsFromFolderUpdateString(fid, so.getContextId()));
            }
            del.execute(cs.iFtrashContactsFromFolderUpdateString(fid, so.getContextId()));
        }
        catch (OXException e) {
            try {
                throw ContactExceptionCodes.TRIGGERING_EVENT_FAILED.create(e, Autoboxing.I((int)so.getContextId()), Autoboxing.I((int)fid));
                catch (SQLException e2) {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, read);
                DBUtils.closeSQLStuff(del);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, read);
        DBUtils.closeSQLStuff(del);
    }

    public static void deleteDistributionList(int id, int cid, Connection writecon) throws SQLException, OXException {
        Contacts.trashDistributionList(id, cid, writecon, true);
    }

    public static void trashDistributionList(int id, int cid, Connection writecon, boolean delete) throws SQLException, OXException {
        Statement stmt = writecon.createStatement();
        try {
            ContactMySql cs = new ContactMySql(null);
            cs.iFtrashDistributionList(delete, id, cid, stmt);
        }
        catch (SQLException sxe) {
            throw sxe;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void deleteLinks(int id, int cid, Connection writecon) throws SQLException, OXException {
        Contacts.trashLinks(id, cid, writecon, true);
    }

    public static void trashLinks(int id, int cid, Connection writecon, boolean delete) throws SQLException, OXException {
        Statement stmt = writecon.createStatement();
        try {
            ContactMySql cs = new ContactMySql(null);
            cs.iFtrashLinks(delete, stmt, id, cid);
        }
        catch (SQLException sxe) {
            throw sxe;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void deleteImage(int id, int cid, Connection writecon) throws SQLException, OXException {
        Contacts.trashImage(id, cid, writecon, true);
    }

    public static void trashImage(int id, int cid, Connection writecon, boolean delete) throws SQLException, OXException {
        Statement stmt = writecon.createStatement();
        try {
            ContactMySql cs = new ContactMySql(null);
            cs.iFtrashImage(delete, stmt, id, cid);
        }
        catch (SQLException sxe) {
            throw sxe;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void trashAllUserContacts(int uid, Session so, Connection readcon, Connection writecon) throws OXException {
        ResultSet rs;
        Statement del;
        Statement stmt;
        block20: {
            stmt = null;
            del = null;
            rs = null;
            try {
                int contextId = so.getContextId();
                Context ct = ContextStorage.getStorageContext(contextId);
                ContactMySql cs = new ContactMySql(ct, uid);
                stmt = readcon.createStatement();
                del = writecon.createStatement();
                FolderObject contactFolder = null;
                rs = stmt.executeQuery(cs.iFgetRightsSelectString(uid, contextId));
                int fid = 0;
                int oid = 0;
                int created_from = 0;
                boolean delete = false;
                int pflag = 0;
                EventClient ec = new EventClient(so);
                OXFolderAccess oxfs = null;
                while (rs.next()) {
                    delete = false;
                    oid = rs.getInt(1);
                    fid = rs.getInt(5);
                    created_from = rs.getInt(6);
                    pflag = rs.getInt(7);
                    if (rs.wasNull()) {
                        pflag = 0;
                    }
                    boolean folder_error = false;
                    try {
                        contactFolder = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(fid, true, ct, readcon) : FolderObject.loadFolderObjectFromDB(fid, ct, readcon);
                        if (contactFolder.getModule() != 3) {
                            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)fid), Autoboxing.I((int)contextId), Autoboxing.I((int)uid));
                        }
                        if (contactFolder.getType() == 1) {
                            delete = true;
                        }
                    }
                    catch (Exception oe) {
                        if (LOG.isWarnEnabled()) {
                            StringBuilder sb = new StringBuilder(128);
                            sb.append("WARNING: During the delete process 'delete all contacts from one user', a contact was found who has no folder.");
                            sb.append("This contact will be modified and can be found in the administrator address book.");
                            sb.append(" Context=").append(contextId);
                            sb.append(" Folder=").append(fid);
                            sb.append(" User=").append(uid);
                            sb.append(" Contact=").append(oid);
                            LOG.warn((Object)sb.toString());
                        }
                        folder_error = true;
                        delete = true;
                    }
                    if (folder_error && pflag == 0) {
                        try {
                            int mailadmin = ct.getMailadmin();
                            if (null == oxfs) {
                                oxfs = new OXFolderAccess(readcon, ct);
                            }
                            FolderObject xx = oxfs.getDefaultFolder(mailadmin, 3);
                            int admin_folder = xx.getObjectID();
                            cs.iFgiveUserContacToAdmin(del, oid, admin_folder, ct);
                        }
                        catch (Exception oxee) {
                            LOG.error((Object)("ERROR: It was not possible to move this contact (without paren folder) to the admin address book!.This contact will be deleted.Context " + contextId + " Folder " + fid + " User" + uid + " Contact" + oid), (Throwable)oxee);
                            folder_error = false;
                        }
                    } else if (folder_error && pflag != 0) {
                        folder_error = false;
                    }
                    if (folder_error) continue;
                    cs.iFtrashAllUserContacts(delete, del, contextId, oid, uid, rs, so);
                    Contact co = new Contact();
                    try {
                        co.setCreatedBy(created_from);
                        co.setParentFolderID(fid);
                        co.setObjectID(oid);
                        ec.delete(co);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable to trigger delete event for contact delete: id=" + co.getObjectID() + " cid=" + co.getContextId()), (Throwable)e);
                    }
                }
                if (uid == ct.getMailadmin()) {
                    cs.iFtrashAllUserContactsDeletedEntriesFromAdmin(del, contextId, uid);
                    break block20;
                }
                cs.iFtrashAllUserContactsDeletedEntries(del, contextId, uid, ct);
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    DBUtils.closeSQLStuff(del);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        DBUtils.closeSQLStuff(del);
    }

    public static OXException getTruncation(Connection con, DataTruncation se, String table, final Contact co) {
        String[] fields = DBUtils.parseTruncatedFields(se);
        StringBuilder sFields = new StringBuilder();
        for (String field : fields) {
            ContactField cf = ContactField.getByFieldName(field);
            if (cf == null) {
                sFields.append(field);
            } else {
                sFields.append(cf.getReadableName());
            }
            sFields.append(", ");
        }
        sFields.setLength(sFields.length() - 2);
        OXException.Truncated[] truncateds = new OXException.Truncated[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            for (int j = 0; j < 650; ++j) {
                Mapper mapper = mapping[j];
                if (mapper == null || !mapper.getDBFieldName().equals(fields[i])) continue;
                int tmp = 0;
                try {
                    tmp = DBUtils.getColumnSize(con, table, fields[i]);
                }
                catch (SQLException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    tmp = 0;
                }
                final int maxSize = tmp;
                final int attributeId = j;
                truncateds[i] = new OXException.Truncated(){

                    public int getId() {
                        return attributeId;
                    }

                    public int getLength() {
                        return Charsets.getBytes((String)mapping[attributeId].getValueAsString(co), (Charset)Charsets.UTF_8).length;
                    }

                    public int getMaxSize() {
                        return maxSize;
                    }
                };
            }
        }
        OXException retval = truncateds.length > 0 ? ContactExceptionCodes.DATA_TRUNCATION.create(se, sFields.toString(), Autoboxing.I((int)truncateds[0].getMaxSize()), Autoboxing.I((int)truncateds[0].getLength())) : ContactExceptionCodes.DATA_TRUNCATION.create(se, sFields.toString(), Autoboxing.I((int)-1), Autoboxing.I((int)-1));
        for (OXException.Truncated truncated : truncateds) {
            retval.addProblematic((OXException.ProblematicAttribute)truncated);
        }
        return retval;
    }

    private static void checkCharacters(Contact co) throws OXException {
        for (int i = 0; i < 650; ++i) {
            if (mapping[i] == null || i == 570) continue;
            String error = null;
            try {
                error = Check.containsInvalidChars(mapping[i].getValueAsString(co));
            }
            catch (NullPointerException npe) {
                LOG.error((Object)"Null pointer detected", (Throwable)npe);
            }
            if (error == null) continue;
            throw ContactExceptionCodes.BAD_CHARACTER.create(error, mapping[i].getReadableTitle());
        }
    }

    protected static boolean areEqual(String string, String other) {
        return null == string ? null == other : (null == other ? false : string.equals(other));
    }

    protected static java.util.Date getDate(int pos, ResultSet rs) {
        try {
            Timestamp timestamp = rs.getTimestamp(pos);
            return rs.wasNull() ? null : timestamp;
        }
        catch (SQLException e) {
            LOG.warn((Object)("TIMESTAMP field could not be read: " + e.getMessage()));
            return null;
        }
    }

    static {
        Contacts.mapping[500] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field01";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setDisplayName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsDisplayName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getDisplayName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getDisplayName();
                String y = original.getDisplayName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getDisplayName();
            }

            @Override
            public String getReadableTitle() {
                return "Display name";
            }
        };
        Contacts.mapping[502] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field02";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setSurName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsSurName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getSurName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getSurName();
                String y = original.getSurName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getSurName();
            }

            @Override
            public String getReadableTitle() {
                return "Sur name";
            }
        };
        Contacts.mapping[501] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field03";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setGivenName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsGivenName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getGivenName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getGivenName();
                String y = original.getGivenName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getGivenName();
            }

            @Override
            public String getReadableTitle() {
                return "Given name";
            }
        };
        Contacts.mapping[503] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field04";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setMiddleName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsMiddleName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getMiddleName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getMiddleName();
                String y = original.getMiddleName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getMiddleName();
            }

            @Override
            public String getReadableTitle() {
                return "Middle name";
            }
        };
        Contacts.mapping[504] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field05";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setSuffix(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsSuffix();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getSuffix());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getSuffix();
                String y = original.getSuffix();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getSuffix();
            }

            @Override
            public String getReadableTitle() {
                return "Suffix";
            }
        };
        Contacts.mapping[505] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field06";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTitle(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTitle();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTitle());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTitle();
                String y = original.getTitle();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTitle();
            }

            @Override
            public String getReadableTitle() {
                return "Title";
            }
        };
        Contacts.mapping[506] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field07";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setStreetHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsStreetHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getStreetHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getStreetHome();
                String y = original.getStreetHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getStreetHome();
            }

            @Override
            public String getReadableTitle() {
                return "Street home";
            }
        };
        Contacts.mapping[507] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field08";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setPostalCodeHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsPostalCodeHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getPostalCodeHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getPostalCodeHome();
                String y = original.getPostalCodeHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getPostalCodeHome();
            }

            @Override
            public String getReadableTitle() {
                return "Postal code home";
            }
        };
        Contacts.mapping[508] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field09";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCityHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCityHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCityHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCityHome();
                String y = original.getCityHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCityHome();
            }

            @Override
            public String getReadableTitle() {
                return "City home";
            }
        };
        Contacts.mapping[509] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field10";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setStateHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsStateHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getStateHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getStateHome();
                String y = original.getStateHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getStateHome();
            }

            @Override
            public String getReadableTitle() {
                return "State home";
            }
        };
        Contacts.mapping[510] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field11";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCountryHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCountryHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCountryHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCountryHome();
                String y = original.getCountryHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCountryHome();
            }

            @Override
            public String getReadableTitle() {
                return "Country home";
            }
        };
        Contacts.mapping[512] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field12";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setMaritalStatus(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsMaritalStatus();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getMaritalStatus());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getMaritalStatus();
                String y = original.getMaritalStatus();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getMaritalStatus();
            }

            @Override
            public String getReadableTitle() {
                return "Martial status";
            }
        };
        Contacts.mapping[513] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field13";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setNumberOfChildren(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNumberOfChildren();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getNumberOfChildren());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getNumberOfChildren();
                String y = original.getNumberOfChildren();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getNumberOfChildren();
            }

            @Override
            public String getReadableTitle() {
                return "Number of children";
            }
        };
        Contacts.mapping[514] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field14";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setProfession(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsProfession();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getProfession());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getProfession();
                String y = original.getProfession();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getProfession();
            }

            @Override
            public String getReadableTitle() {
                return "Profession";
            }
        };
        Contacts.mapping[515] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field15";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setNickname(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNickname();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getNickname());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getNickname();
                String y = original.getNickname();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getNickname();
            }

            @Override
            public String getReadableTitle() {
                return "Nickname";
            }
        };
        Contacts.mapping[516] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field16";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setSpouseName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsSpouseName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getSpouseName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getSpouseName();
                String y = original.getSpouseName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getSpouseName();
            }

            @Override
            public String getReadableTitle() {
                return "Spouse name";
            }
        };
        Contacts.mapping[518] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field17";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setNote(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNote();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getNote());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getNote();
                String y = original.getNote();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getNote();
            }

            @Override
            public String getReadableTitle() {
                return "Note";
            }
        };
        Contacts.mapping[569] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field18";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCompany(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCompany();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCompany());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCompany();
                String y = original.getCompany();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCompany();
            }

            @Override
            public String getReadableTitle() {
                return "Company";
            }
        };
        Contacts.mapping[519] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field19";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setDepartment(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsDepartment();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getDepartment());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getDepartment();
                String y = original.getDepartment();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getDepartment();
            }

            @Override
            public String getReadableTitle() {
                return "Department";
            }
        };
        Contacts.mapping[520] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field20";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setPosition(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsPosition();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getPosition());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getPosition();
                String y = original.getPosition();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getPosition();
            }

            @Override
            public String getReadableTitle() {
                return "Position";
            }
        };
        Contacts.mapping[521] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field21";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setEmployeeType(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsEmployeeType();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getEmployeeType());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getEmployeeType();
                String y = original.getEmployeeType();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getEmployeeType();
            }

            @Override
            public String getReadableTitle() {
                return "Employee type";
            }
        };
        Contacts.mapping[522] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field22";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setRoomNumber(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsRoomNumber();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getRoomNumber());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getRoomNumber();
                String y = original.getRoomNumber();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getRoomNumber();
            }

            @Override
            public String getReadableTitle() {
                return "Room number";
            }
        };
        Contacts.mapping[523] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field23";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setStreetBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsStreetBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getStreetBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getStreetBusiness();
                String y = original.getStreetBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getStreetBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "Street business";
            }
        };
        Contacts.mapping[525] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field24";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setPostalCodeBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsPostalCodeBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getPostalCodeBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getPostalCodeBusiness();
                String y = original.getPostalCodeBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getPostalCodeBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "Postal code business";
            }
        };
        Contacts.mapping[526] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field25";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCityBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCityBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCityBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCityBusiness();
                String y = original.getCityBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCityBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "City business";
            }
        };
        Contacts.mapping[527] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field26";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setStateBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsStateBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getStateBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getStateBusiness();
                String y = original.getStateBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getStateBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "State business";
            }
        };
        Contacts.mapping[528] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field27";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCountryBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCountryBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCountryBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCountryBusiness();
                String y = original.getCountryBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCountryBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "Country business";
            }
        };
        Contacts.mapping[529] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field28";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setNumberOfEmployee(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNumberOfEmployee();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getNumberOfEmployee());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getNumberOfEmployee();
                String y = original.getNumberOfEmployee();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getNumberOfEmployee();
            }

            @Override
            public String getReadableTitle() {
                return "Number of employee";
            }
        };
        Contacts.mapping[530] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field29";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setSalesVolume(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsSalesVolume();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getSalesVolume());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getSalesVolume();
                String y = original.getSalesVolume();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getSalesVolume();
            }

            @Override
            public String getReadableTitle() {
                return "Sales volume";
            }
        };
        Contacts.mapping[531] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field30";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTaxID(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTaxID();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTaxID());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTaxID();
                String y = original.getTaxID();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTaxID();
            }

            @Override
            public String getReadableTitle() {
                return "Tax id";
            }
        };
        Contacts.mapping[532] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field31";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCommercialRegister(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCommercialRegister();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCommercialRegister());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCommercialRegister();
                String y = original.getCommercialRegister();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCommercialRegister();
            }

            @Override
            public String getReadableTitle() {
                return "Commercial register";
            }
        };
        Contacts.mapping[533] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field32";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setBranches(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsBranches();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getBranches());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getBranches();
                String y = original.getBranches();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getBranches();
            }

            @Override
            public String getReadableTitle() {
                return "Branches";
            }
        };
        Contacts.mapping[534] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field33";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setBusinessCategory(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsBusinessCategory();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getBusinessCategory());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getBusinessCategory();
                String y = original.getBusinessCategory();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getBusinessCategory();
            }

            @Override
            public String getReadableTitle() {
                return "Business category";
            }
        };
        Contacts.mapping[535] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field34";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setInfo(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsInfo();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getInfo());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getInfo();
                String y = original.getInfo();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getInfo();
            }

            @Override
            public String getReadableTitle() {
                return "Info";
            }
        };
        Contacts.mapping[536] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field35";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setManagerName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsManagerName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getManagerName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getManagerName();
                String y = original.getManagerName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getManagerName();
            }

            @Override
            public String getReadableTitle() {
                return "Manager's name";
            }
        };
        Contacts.mapping[537] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field36";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setAssistantName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsAssistantName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getAssistantName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getAssistantName();
                String y = original.getAssistantName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getAssistantName();
            }

            @Override
            public String getReadableTitle() {
                return "Assistant's name";
            }
        };
        Contacts.mapping[538] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field37";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setStreetOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsStreetOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getStreetOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getStreetOther();
                String y = original.getStreetOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getStreetOther();
            }

            @Override
            public String getReadableTitle() {
                return "Street other";
            }
        };
        Contacts.mapping[540] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field38";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setPostalCodeOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsPostalCodeOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getPostalCodeOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getPostalCodeOther();
                String y = original.getPostalCodeOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getPostalCodeOther();
            }

            @Override
            public String getReadableTitle() {
                return "Postal code other";
            }
        };
        Contacts.mapping[539] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field39";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCityOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCityOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCityOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCityOther();
                String y = original.getCityOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCityOther();
            }

            @Override
            public String getReadableTitle() {
                return "City other";
            }
        };
        Contacts.mapping[598] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field40";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setStateOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsStateOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getStateOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getStateOther();
                String y = original.getStateOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getStateOther();
            }

            @Override
            public String getReadableTitle() {
                return "State other";
            }
        };
        Contacts.mapping[541] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field41";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCountryOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCountryOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCountryOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCountryOther();
                String y = original.getCountryOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCountryOther();
            }

            @Override
            public String getReadableTitle() {
                return "Country other";
            }
        };
        Contacts.mapping[568] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field42";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneAssistant(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneAssistant();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneAssistant());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneAssistant();
                String y = original.getTelephoneAssistant();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneAssistant();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone assistant";
            }
        };
        Contacts.mapping[542] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field43";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneBusiness1(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneBusiness1();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneBusiness1());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneBusiness1();
                String y = original.getTelephoneBusiness1();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneBusiness1();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone business 1";
            }
        };
        Contacts.mapping[543] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field44";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneBusiness2(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneBusiness2();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneBusiness2());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneBusiness2();
                String y = original.getTelephoneBusiness2();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneBusiness2();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone business 2";
            }
        };
        Contacts.mapping[544] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field45";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setFaxBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsFaxBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getFaxBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getFaxBusiness();
                String y = original.getFaxBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getFaxBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "FAX business";
            }
        };
        Contacts.mapping[545] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field46";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneCallback(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneCallback();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneCallback());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneCallback();
                String y = original.getTelephoneCallback();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneCallback();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone callback";
            }
        };
        Contacts.mapping[546] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field47";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneCar(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneCar();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneCar());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneCar();
                String y = original.getTelephoneCar();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneCar();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone car";
            }
        };
        Contacts.mapping[547] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field48";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneCompany(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneCompany();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneCompany());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneCompany();
                String y = original.getTelephoneCompany();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneCompany();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone company";
            }
        };
        Contacts.mapping[548] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field49";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneHome1(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneHome1();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneHome1());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneHome1();
                String y = original.getTelephoneHome1();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneHome1();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone home 1";
            }
        };
        Contacts.mapping[549] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field50";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneHome2(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneHome2();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneHome2());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneHome2();
                String y = original.getTelephoneHome2();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneHome2();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone home 2";
            }
        };
        Contacts.mapping[550] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field51";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setFaxHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsFaxHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getFaxHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getFaxHome();
                String y = original.getFaxHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getFaxHome();
            }

            @Override
            public String getReadableTitle() {
                return "FAX home";
            }
        };
        Contacts.mapping[559] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field52";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneISDN(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneISDN();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneISDN());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneISDN();
                String y = original.getTelephoneISDN();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneISDN();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone ISDN";
            }
        };
        Contacts.mapping[551] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field53";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCellularTelephone1(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCellularTelephone1();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCellularTelephone1());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCellularTelephone1();
                String y = original.getCellularTelephone1();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCellularTelephone1();
            }

            @Override
            public String getReadableTitle() {
                return "Cellular telephone 1";
            }
        };
        Contacts.mapping[552] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field54";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCellularTelephone2(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCellularTelephone2();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCellularTelephone2());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCellularTelephone2();
                String y = original.getCellularTelephone2();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCellularTelephone2();
            }

            @Override
            public String getReadableTitle() {
                return "Cellular telephone 2";
            }
        };
        Contacts.mapping[553] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field55";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneOther();
                String y = original.getTelephoneOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneOther();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone other";
            }
        };
        Contacts.mapping[554] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field56";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setFaxOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsFaxOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getFaxOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getFaxOther();
                String y = original.getFaxOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getFaxOther();
            }

            @Override
            public String getReadableTitle() {
                return "FAX other";
            }
        };
        Contacts.mapping[560] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field57";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephonePager(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephonePager();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephonePager());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephonePager();
                String y = original.getTelephonePager();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephonePager();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone pager";
            }
        };
        Contacts.mapping[561] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field58";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephonePrimary(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephonePrimary();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephonePrimary());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephonePrimary();
                String y = original.getTelephonePrimary();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephonePrimary();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone primary";
            }
        };
        Contacts.mapping[562] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field59";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneRadio(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneRadio();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneRadio());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneRadio();
                String y = original.getTelephoneRadio();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneRadio();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone radio";
            }
        };
        Contacts.mapping[563] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field60";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneTelex(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneTelex();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneTelex());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneTelex();
                String y = original.getTelephoneTelex();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneTelex();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone telex";
            }
        };
        Contacts.mapping[564] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field61";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneTTYTTD(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneTTYTTD();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneTTYTTD());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneTTYTTD();
                String y = original.getTelephoneTTYTTD();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneTTYTTD();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone TTY/TDD";
            }
        };
        Contacts.mapping[565] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field62";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setInstantMessenger1(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsInstantMessenger1();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getInstantMessenger1());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getInstantMessenger1();
                String y = original.getInstantMessenger1();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getInstantMessenger1();
            }

            @Override
            public String getReadableTitle() {
                return "Instantmessenger 1";
            }
        };
        Contacts.mapping[566] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field63";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setInstantMessenger2(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsInstantMessenger2();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getInstantMessenger2());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getInstantMessenger2();
                String y = original.getInstantMessenger2();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getInstantMessenger2();
            }

            @Override
            public String getReadableTitle() {
                return "Instantmessenger 2";
            }
        };
        Contacts.mapping[567] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field64";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setTelephoneIP(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsTelephoneIP();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getTelephoneIP());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getTelephoneIP();
                String y = original.getTelephoneIP();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getTelephoneIP();
            }

            @Override
            public String getReadableTitle() {
                return "Telephone IP";
            }
        };
        Contacts.mapping[555] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field65";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setEmail1(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsEmail1();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getEmail1());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getEmail1();
                String y = original.getEmail1();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getEmail1();
            }

            @Override
            public String getReadableTitle() {
                return "Email 1";
            }
        };
        Contacts.mapping[556] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field66";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setEmail2(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsEmail2();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getEmail2());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getEmail2();
                String y = original.getEmail2();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getEmail2();
            }

            @Override
            public String getReadableTitle() {
                return "Email 2";
            }
        };
        Contacts.mapping[557] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field67";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setEmail3(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsEmail3();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getEmail3());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getEmail3();
                String y = original.getEmail3();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getEmail3();
            }

            @Override
            public String getReadableTitle() {
                return "Email 3";
            }
        };
        Contacts.mapping[558] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field68";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setURL(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsURL();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getURL());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getURL();
                String y = original.getURL();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getURL();
            }

            @Override
            public String getReadableTitle() {
                return "URL";
            }
        };
        Contacts.mapping[100] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field69";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setCategories(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCategories();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getCategories());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getCategories();
                String y = original.getCategories();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCategories();
            }

            @Override
            public String getReadableTitle() {
                return "Categories";
            }
        };
        Contacts.mapping[571] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field70";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField01(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField01();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField01());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField01();
                String y = original.getUserField01();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField01();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 1";
            }
        };
        Contacts.mapping[572] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field71";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField02(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField02();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField02());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField02();
                String y = original.getUserField02();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField02();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 2";
            }
        };
        Contacts.mapping[573] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field72";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField03(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField03();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField03());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField03();
                String y = original.getUserField03();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField03();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 3";
            }
        };
        Contacts.mapping[574] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field73";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField04(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField04();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField04());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField04();
                String y = original.getUserField04();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField04();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 4";
            }
        };
        Contacts.mapping[575] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field74";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField05(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField05();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField05());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField05();
                String y = original.getUserField05();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField05();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 5";
            }
        };
        Contacts.mapping[576] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field75";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField06(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField06();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField06());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField06();
                String y = original.getUserField06();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField06();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 6";
            }
        };
        Contacts.mapping[577] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field76";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField07(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField07();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField07());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField07();
                String y = original.getUserField07();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField07();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 7";
            }
        };
        Contacts.mapping[578] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field77";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField08(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField08();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField08());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField08();
                String y = original.getUserField08();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField08();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 8";
            }
        };
        Contacts.mapping[579] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field78";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField09(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField09();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField09());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField09();
                String y = original.getUserField09();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField09();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 9";
            }
        };
        Contacts.mapping[580] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field79";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField10(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField10();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField10());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField10();
                String y = original.getUserField10();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField10();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 10";
            }
        };
        Contacts.mapping[581] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field80";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField11(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField11();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField11());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField11();
                String y = original.getUserField11();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField11();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 11";
            }
        };
        Contacts.mapping[582] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field81";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField12(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField12();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField12());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField12();
                String y = original.getUserField12();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField12();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 12";
            }
        };
        Contacts.mapping[583] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field82";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField13(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField13();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField13());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField13();
                String y = original.getUserField13();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField13();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 13";
            }
        };
        Contacts.mapping[584] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field83";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField14(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField14();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField14());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField14();
                String y = original.getUserField14();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField14();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 14";
            }
        };
        Contacts.mapping[585] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field84";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField15(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField15();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField15());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField15();
                String y = original.getUserField15();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField15();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 15";
            }
        };
        Contacts.mapping[586] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field85";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField16(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField16();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField16());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField16();
                String y = original.getUserField16();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField16();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 16";
            }
        };
        Contacts.mapping[587] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field86";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField17(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField17();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField17());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField17();
                String y = original.getUserField17();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField17();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 17";
            }
        };
        Contacts.mapping[588] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field87";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField18(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField18();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField18());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField18();
                String y = original.getUserField18();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField18();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 18";
            }
        };
        Contacts.mapping[589] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field88";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField19(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField19();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField19());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField19();
                String y = original.getUserField19();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField19();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 19";
            }
        };
        Contacts.mapping[590] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field89";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUserField20(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUserField20();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUserField20());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUserField20();
                String y = original.getUserField20();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUserField20();
            }

            @Override
            public String getReadableTitle() {
                return "Dynamic Field 20";
            }
        };
        Contacts.mapping[1] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield01";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull()) {
                    co.setObjectID(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsObjectID();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getObjectID());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return original.getObjectID() == co.getObjectID();
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getObjectID());
            }

            @Override
            public String getReadableTitle() {
                return "Object id";
            }
        };
        Contacts.mapping[594] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield02";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull() && t > 0) {
                    co.setNumberOfDistributionLists(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNumberOfDistributionLists();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getNumberOfDistributionLists());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return original.getNumberOfDistributionLists() == co.getNumberOfDistributionLists();
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getNumberOfDistributionLists());
            }

            @Override
            public String getReadableTitle() {
                return "Number of distributionlists";
            }
        };
        Contacts.mapping[103] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield03";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull() && t > 0) {
                    co.setNumberOfLinks(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNumberOfLinks();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getNumberOfLinks());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return original.getNumberOfLinks() == co.getNumberOfLinks();
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getNumberOfLinks());
            }

            @Override
            public String getReadableTitle() {
                return "Number of links";
            }
        };
        Contacts.mapping[592] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield02";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) {
                try {
                    int t = rs.getInt(pos);
                    if (!rs.wasNull() && t > 0) {
                        co.setDistributionList(Contacts.fillDistributionListArray(co.getObjectID(), user, ctx, readcon));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to load Distributionlist", (Throwable)e);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsDistributionLists();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) {
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return "Distribution list";
            }
        };
        Contacts.mapping[591] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield03";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) {
                try {
                    int t = rs.getInt(pos);
                    if (!rs.wasNull() && t > 0) {
                        co.setLinks(Contacts.fillLinkArray(co, user, ctx, readcon));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to load Links", (Throwable)e);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsLinks();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) {
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[20] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "fid";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull()) {
                    co.setParentFolderID(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsParentFolderID();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getParentFolderID());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getParentFolderID());
            }

            @Override
            public String getReadableTitle() {
                return "Folder id";
            }
        };
        Contacts.mapping[593] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "cid";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull()) {
                    co.setContextId(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsContextId();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getContextId());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return original.getContextId() == co.getContextId();
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getContextId());
            }

            @Override
            public String getReadableTitle() {
                return "Context id";
            }
        };
        Contacts.mapping[101] = new PrivateFlag();
        Contacts.mapping[2] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "created_from";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull()) {
                    co.setCreatedBy(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCreatedBy();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getCreatedBy());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getCreatedBy());
            }

            @Override
            public String getReadableTitle() {
                return "Created by";
            }
        };
        Contacts.mapping[3] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "changed_from";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int t = rs.getInt(pos);
                if (!rs.wasNull()) {
                    co.setModifiedBy(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsModifiedBy();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setInt(pos, co.getModifiedBy());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return co.getModifiedBy() == original.getModifiedBy();
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getModifiedBy());
            }

            @Override
            public String getReadableTitle() {
                return "Modified by";
            }
        };
        Contacts.mapping[4] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "creating_date";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                long dong = rs.getLong(pos);
                if (!rs.wasNull()) {
                    java.util.Date d = new java.util.Date(dong);
                    co.setCreationDate(d);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsCreationDate();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                java.util.Date d = co.getCreationDate();
                ps.setLong(pos, d.getTime());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getCreationDate() == null ? null : co.getCreationDate().toString();
            }

            @Override
            public String getReadableTitle() {
                return "Creation date";
            }
        };
        Contacts.mapping[5] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "changing_date";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                long dong = rs.getLong(pos);
                if (!rs.wasNull()) {
                    java.util.Date d = new java.util.Date(dong);
                    co.setLastModified(d);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsLastModified();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                java.util.Date d = co.getLastModified();
                ps.setLong(pos, d.getTime());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getLastModified() == null ? null : co.getLastModified().toString();
            }

            @Override
            public String getReadableTitle() {
                return "Changing date";
            }
        };
        Contacts.mapping[511] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "timestampfield01";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                co.setBirthday(Contacts.getDate(pos, rs));
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsBirthday();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.getBirthday() == null) {
                    ps.setTimestamp(pos, null);
                } else {
                    ps.setTimestamp(pos, new Timestamp(co.getBirthday().getTime()));
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                java.util.Date x = co.getBirthday();
                java.util.Date y = original.getBirthday();
                if (null == x) {
                    return null == y;
                }
                if (null == y) {
                    return false;
                }
                return x.getTime() == y.getTime();
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getBirthday() == null ? null : co.getBirthday().toString();
            }

            @Override
            public String getReadableTitle() {
                return "Birthday";
            }
        };
        Contacts.mapping[517] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "timestampfield02";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                co.setAnniversary(Contacts.getDate(pos, rs));
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsAnniversary();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.getAnniversary() == null) {
                    ps.setTimestamp(pos, null);
                } else {
                    ps.setTimestamp(pos, new Timestamp(co.getAnniversary().getTime()));
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                java.util.Date x = co.getAnniversary();
                java.util.Date y = original.getAnniversary();
                if (null == x) {
                    return null == y;
                }
                if (null == y) {
                    return false;
                }
                return x.getTime() == y.getTime();
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getAnniversary() == null ? null : co.getAnniversary().toString();
            }

            @Override
            public String getReadableTitle() {
                return "Anniversary";
            }
        };
        Contacts.mapping[570] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield04";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) {
                try {
                    int t = rs.getInt(pos);
                    if (!rs.wasNull() && t > 0) {
                        Contacts.getContactImage(co.getObjectID(), co, ctx.getContextId(), readcon);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Image not found", (Throwable)e);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsImage1();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (null != co.getImage1()) {
                    ps.setInt(pos, 1);
                } else {
                    ps.setNull(pos, 4);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                if (co.getImage1() != null && original.getImage1() != null) {
                    String x = new String(co.getImage1());
                    String y = new String(original.getImage1());
                    return x.equals(y);
                }
                return (co.getImage1() != null || original.getImage1() == null) && (co.getImage1() == null || original.getImage1() != null);
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[597] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield04";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) {
                try {
                    Date dd;
                    int t = rs.getInt(pos);
                    if (!rs.wasNull() && t > 0 && (dd = Contacts.getContactImageLastModified(co.getObjectID(), ctx.getContextId(), readcon)) != null) {
                        co.setImageLastModified(dd);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to load Image", (Throwable)e);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsImageLastModified();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsImage1()) {
                    ps.setInt(pos, 1);
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[601] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield04";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) {
                try {
                    String ct;
                    int t = rs.getInt(pos);
                    if (!rs.wasNull() && t > 0 && (ct = Contacts.getContactImageContentType(co.getObjectID(), ctx.getContextId(), readcon)) != null) {
                        co.setImageContentType(ct);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Image not found", (Throwable)e);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsImageContentType();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsImage1()) {
                    ps.setInt(pos, 1);
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[596] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield04";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) {
            }

            @Override
            public boolean containsElement(Contact co) {
                return false;
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) {
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[524] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "userid";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int i = rs.getInt(pos);
                if (!rs.wasNull() && i > 0) {
                    co.setInternalUserId(i);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsInternalUserId();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsInternalUserId()) {
                    ps.setInt(pos, co.getInternalUserId());
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return false;
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[102] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield05";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int i = rs.getInt(pos);
                if (!rs.wasNull() && i > 0) {
                    co.setLabel(i);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsLabel();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsLabel()) {
                    ps.setInt(pos, co.getLabel());
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return co.getLabel() == original.getLabel();
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[599] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "field90";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setFileAs(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsFileAs();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getFileAs());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getFileAs();
                String y = original.getFileAs();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[605] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield06";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int i = rs.getInt(pos);
                if (!rs.wasNull() && i > 0) {
                    co.setDefaultAddress(i);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsDefaultAddress();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsDefaultAddress()) {
                    ps.setInt(pos, co.getDefaultAddress());
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return co.getDefaultAddress() == original.getDefaultAddress();
            }

            @Override
            public String getValueAsString(Contact co) {
                return Integer.toString(co.getDefaultAddress());
            }

            @Override
            public String getReadableTitle() {
                return "Default address";
            }
        };
        Contacts.mapping[602] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield07";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int i = rs.getInt(pos);
                if (!rs.wasNull() && i > 0) {
                    co.markAsDistributionlist();
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsMarkAsDistributionlist();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsMarkAsDistributionlist()) {
                    if (co.getMarkAsDistribtuionlist()) {
                        ps.setInt(pos, 1);
                    } else {
                        ps.setInt(pos, 0);
                    }
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                if (co.getMarkAsDistribtuionlist() && !original.getMarkAsDistribtuionlist()) {
                    return false;
                }
                if (!co.getMarkAsDistribtuionlist() && original.getMarkAsDistribtuionlist()) {
                    return true;
                }
                return co.getMarkAsDistribtuionlist() == original.getMarkAsDistribtuionlist();
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[104] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "intfield08";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int i = rs.getInt(pos);
                if (!rs.wasNull()) {
                    co.setNumberOfAttachments(i);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsNumberOfAttachments();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsNumberOfAttachments()) {
                    ps.setInt(pos, co.getNumberOfAttachments());
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return co.getNumberOfAttachments() == original.getNumberOfAttachments();
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[608] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "useCount";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                int i = rs.getInt(pos);
                if (!rs.wasNull() && i > 0) {
                    co.setUseCount(i);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUseCount();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                if (co.containsUseCount()) {
                    ps.setInt(pos, co.getUseCount());
                } else {
                    ps.setInt(pos, 0);
                }
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                return co.getUseCount() == original.getUseCount();
            }

            @Override
            public String getValueAsString(Contact co) {
                return null;
            }

            @Override
            public String getReadableTitle() {
                return null;
            }
        };
        Contacts.mapping[610] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "yomiFirstName";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setYomiFirstName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsYomiFirstName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getYomiFirstName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getYomiFirstName();
                String y = original.getYomiFirstName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getYomiFirstName();
            }

            @Override
            public String getReadableTitle() {
                return "Yomi First Name";
            }
        };
        Contacts.mapping[611] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "yomiLastName";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setYomiLastName(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsYomiLastName();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getYomiLastName());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getYomiLastName();
                String y = original.getYomiLastName();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getYomiLastName();
            }

            @Override
            public String getReadableTitle() {
                return "Yomi Last Name";
            }
        };
        Contacts.mapping[612] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "yomiCompany";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setYomiCompany(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsYomiCompany();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getYomiCompany());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getYomiCompany();
                String y = original.getYomiCompany();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getYomiCompany();
            }

            @Override
            public String getReadableTitle() {
                return "Yomi Company";
            }
        };
        Contacts.mapping[613] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "homeAddress";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setAddressHome(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsAddressHome();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getAddressHome());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getAddressHome();
                String y = original.getAddressHome();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getAddressHome();
            }

            @Override
            public String getReadableTitle() {
                return "Home Address";
            }
        };
        Contacts.mapping[614] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "businessAddress";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setAddressBusiness(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsAddressBusiness();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getAddressBusiness());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getAddressBusiness();
                String y = original.getAddressBusiness();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getAddressBusiness();
            }

            @Override
            public String getReadableTitle() {
                return "Business Address";
            }
        };
        Contacts.mapping[615] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "otherAddress";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setAddressOther(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsAddressOther();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getAddressOther());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getAddressOther();
                String y = original.getAddressOther();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getAddressOther();
            }

            @Override
            public String getReadableTitle() {
                return "Other Address";
            }
        };
        Contacts.mapping[223] = new Mapper(){

            @Override
            public String getDBFieldName() {
                return "uid";
            }

            @Override
            public void addToContactObject(ResultSet rs, int pos, Contact co, Connection readcon, int user, int[] group, Context ctx, UserConfiguration uc) throws SQLException {
                String t = rs.getString(pos);
                if (!rs.wasNull()) {
                    co.setUid(t);
                }
            }

            @Override
            public boolean containsElement(Contact co) {
                return co.containsUid();
            }

            @Override
            public void fillPreparedStatement(PreparedStatement ps, int pos, Contact co) throws SQLException {
                ps.setString(pos, co.getUid());
            }

            @Override
            public boolean compare(Contact co, Contact original) {
                String x = co.getUid();
                String y = original.getUid();
                return Contacts.areEqual(x, y);
            }

            @Override
            public String getValueAsString(Contact co) {
                return co.getUid();
            }

            @Override
            public String getReadableTitle() {
                return "UID";
            }
        };
    }

    public static interface Mapper {
        public boolean containsElement(Contact var1);

        public void addToContactObject(ResultSet var1, int var2, Contact var3, Connection var4, int var5, int[] var6, Context var7, UserConfiguration var8) throws SQLException;

        public String getDBFieldName();

        public void fillPreparedStatement(PreparedStatement var1, int var2, Contact var3) throws SQLException;

        public boolean compare(Contact var1, Contact var2);

        public String getValueAsString(Contact var1);

        public String getReadableTitle();
    }
}

