/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual.osgi;

import com.openexchange.database.DatabaseService;
import com.openexchange.folderstorage.FolderField;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.virtual.VirtualFolderDeleteListener;
import com.openexchange.folderstorage.virtual.VirtualFolderStorage;
import com.openexchange.folderstorage.virtual.VirtualServiceRegistry;
import com.openexchange.folderstorage.virtual.osgi.VirtualFolderStorageServiceTracker;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.ServiceRegistry;
import java.util.Dictionary;
import java.util.Hashtable;

public class VirtualFolderStorageActivator
extends HousekeepingActivator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(VirtualFolderStorageActivator.class));

    protected Class<?>[] getNeededServices() {
        return new Class[]{DatabaseService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
        VirtualServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
        VirtualServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = VirtualServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.track(FolderStorage.class, new VirtualFolderStorageServiceTracker(this.context));
            this.openTrackers();
            this.registerService(DeleteListener.class, new VirtualFolderDeleteListener(), null);
            this.registerService(FolderField.class, VirtualFolderStorage.FIELD_NAME_PAIR_PREDEFINED);
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("tree", FolderStorage.ALL_TREE_ID);
            this.registerService(FolderStorage.class, VirtualFolderStorage.getInstance(), dictionary);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            this.cleanUp();
            VirtualServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

