/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual;

import com.openexchange.concurrent.CallerRunsCompletionService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderField;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.internal.performers.InstanceStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.SessionStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.StorageParametersProvider;
import com.openexchange.folderstorage.mail.contentType.DraftsContentType;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.mail.contentType.SentContentType;
import com.openexchange.folderstorage.mail.contentType.SpamContentType;
import com.openexchange.folderstorage.mail.contentType.TrashContentType;
import com.openexchange.folderstorage.outlook.memory.MemoryTable;
import com.openexchange.folderstorage.outlook.memory.MemoryTree;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.virtual.VirtualFolder;
import com.openexchange.folderstorage.virtual.VirtualFolderStorageRegistry;
import com.openexchange.folderstorage.virtual.VirtualFolderType;
import com.openexchange.folderstorage.virtual.VirtualId;
import com.openexchange.folderstorage.virtual.sql.Delete;
import com.openexchange.folderstorage.virtual.sql.Insert;
import com.openexchange.folderstorage.virtual.sql.Select;
import com.openexchange.folderstorage.virtual.sql.Update;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;

public final class VirtualFolderStorage
implements FolderStorage {
    private static final VirtualFolderStorage INSTANCE = new VirtualFolderStorage();
    public static final String FOLDER_TREE_EAS = "20".intern();
    public static final FolderField FIELD_NAME_PAIR_PREDEFINED = new FolderField(3040, "preDefined", Boolean.FALSE);
    private static final ThreadPools.ExpectedExceptionFactory<OXException> FACTORY = new ThreadPools.ExpectedExceptionFactory<OXException>(){

        public Class<OXException> getType() {
            return OXException.class;
        }

        public OXException newUnexpectedError(Throwable t) {
            return FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(t, t.getMessage());
        }
    };
    private final FolderType folderType = VirtualFolderType.getInstance();
    private final String realTreeId = REAL_TREE_ID;
    private final List<ContentType> defaultTypes = Arrays.asList(DraftsContentType.getInstance(), SentContentType.getInstance(), SpamContentType.getInstance(), TrashContentType.getInstance());

    public static VirtualFolderStorage getInstance() {
        return INSTANCE;
    }

    private VirtualFolderStorage() {
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters params) throws OXException {
        return folder;
    }

    private static boolean doCheckConsistency() {
        return false;
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters params) throws OXException {
        if (!VirtualFolderStorage.doCheckConsistency()) {
            return;
        }
        if (FOLDER_TREE_EAS.equals(treeId)) {
            ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
            try {
                Folder folder;
                FolderStorage realStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorageByContentType(this.realTreeId, CalendarContentType.getInstance());
                this.checkOpenedStorage(realStorage, params, false, openedStorages);
                String folderID = realStorage.getDefaultFolderID(params.getUser(), this.realTreeId, CalendarContentType.getInstance(), PrivateType.getInstance(), params);
                MemoryTree tree = MemoryTable.getMemoryTableFor(params.getSession()).getTree(VirtualFolderStorage.unsignedInt(treeId), params.getSession());
                if (!tree.containsFolder(folderID)) {
                    folder = realStorage.getFolder(this.realTreeId, folderID, params);
                    folder.setTreeID(treeId);
                    folder.setParentID(ROOT_ID);
                    folder.setSubscribed(true);
                    this.createDefaultFolder(folder, params);
                }
                realStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorageByContentType(this.realTreeId, ContactContentType.getInstance());
                this.checkOpenedStorage(realStorage, params, false, openedStorages);
                folderID = realStorage.getDefaultFolderID(params.getUser(), this.realTreeId, ContactContentType.getInstance(), PrivateType.getInstance(), params);
                if (!tree.containsFolder(folderID)) {
                    folder = realStorage.getFolder(this.realTreeId, folderID, params);
                    folder.setTreeID(treeId);
                    folder.setParentID(ROOT_ID);
                    folder.setSubscribed(true);
                    this.createDefaultFolder(folder, params);
                }
                realStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorageByContentType(this.realTreeId, TaskContentType.getInstance());
                this.checkOpenedStorage(realStorage, params, false, openedStorages);
                folderID = realStorage.getDefaultFolderID(params.getUser(), this.realTreeId, TaskContentType.getInstance(), PrivateType.getInstance(), params);
                if (!tree.containsFolder(folderID)) {
                    folder = realStorage.getFolder(this.realTreeId, folderID, params);
                    folder.setTreeID(treeId);
                    folder.setParentID(ROOT_ID);
                    folder.setSubscribed(true);
                    this.createDefaultFolder(folder, params);
                }
                realStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorageByContentType(this.realTreeId, MailContentType.getInstance());
                this.checkOpenedStorage(realStorage, params, false, openedStorages);
                folderID = realStorage.getDefaultFolderID(params.getUser(), this.realTreeId, MailContentType.getInstance(), PrivateType.getInstance(), params);
                if (!tree.containsFolder(folderID)) {
                    folder = realStorage.getFolder(this.realTreeId, folderID, params);
                    folder.setTreeID(treeId);
                    folder.setParentID(ROOT_ID);
                    folder.setSubscribed(true);
                    this.createDefaultFolder(folder, params);
                }
                for (ContentType contentType : this.defaultTypes) {
                    Folder folder2;
                    folderID = realStorage.getDefaultFolderID(params.getUser(), this.realTreeId, contentType, PrivateType.getInstance(), params);
                    if (tree.containsFolder(folderID) || null == (folder2 = realStorage.getFolder(this.realTreeId, folderID, params)).getName()) continue;
                    folder2.setTreeID(treeId);
                    folder2.setParentID(ROOT_ID);
                    folder2.setSubscribed(true);
                    this.createDefaultFolder(folder2, params);
                }
                for (FolderStorage folderStorage : openedStorages) {
                    folderStorage.commitTransaction(params);
                }
            }
            catch (OXException e) {
                for (FolderStorage folderStorage : openedStorages) {
                    folderStorage.rollback(params);
                }
                throw e;
            }
            catch (RuntimeException e) {
                for (FolderStorage folderStorage : openedStorages) {
                    folderStorage.rollback(params);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }

    private void checkOpenedStorage(FolderStorage checkMe, StorageParameters params, boolean modify, Collection<FolderStorage> openedStorages) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(params, modify)) {
            openedStorages.add(checkMe);
        }
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters params) throws OXException {
    }

    @Override
    public ContentType getDefaultContentType() {
        return null;
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
    }

    @Override
    public void createFolder(Folder folder, StorageParameters params) throws OXException {
        int tree = VirtualFolderStorage.unsignedInt(folder.getTreeID());
        int contextId = params.getContextId();
        Insert.insertFolder(contextId, tree, params.getUserId(), folder, null, params.getSession());
        MemoryTable.getMemoryTableFor(params.getSession()).initializeFolder(folder.getID(), tree, params.getUserId(), contextId);
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters params) throws OXException {
    }

    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters params) throws OXException {
        int contextId = params.getContextId();
        int tree = VirtualFolderStorage.unsignedInt(treeId);
        Session session = params.getSession();
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
        LinkedList<String> list = new LinkedList<String>();
        list.add(folderId);
        VirtualFolderStorage.gatherSubfolders(folderId, memoryTable.getTree(tree, session), list);
        for (String fid : list) {
            Delete.deleteFolder(contextId, tree, params.getUserId(), fid, false, session);
        }
        memoryTable.initializeTree(tree, params.getUserId(), contextId);
    }

    private static void gatherSubfolders(String parentId, MemoryTree memoryTree, List<String> list) {
        for (String[] args : memoryTree.getSubfolderIds(parentId)) {
            String id = args[0];
            list.add(id);
            VirtualFolderStorage.gatherSubfolders(id, memoryTree, list);
        }
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters params) throws OXException {
        FolderStorage byContentType = VirtualFolderStorageRegistry.getInstance().getFolderStorageByContentType(treeId, contentType);
        if (null == byContentType) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(treeId, contentType);
        }
        boolean started = byContentType.startTransaction(params, false);
        try {
            String defaultFolderID = byContentType.getDefaultFolderID(user, treeId, contentType, type, params);
            if (started) {
                byContentType.commitTransaction(params);
            }
            return defaultFolderID;
        }
        catch (OXException e) {
            if (started) {
                byContentType.rollback(params);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                byContentType.rollback(params);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters params) throws OXException {
        return null;
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters params) throws OXException {
        FolderStorage realFolderStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorage(this.realTreeId, folderId);
        if (null == realFolderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = realFolderStorage.startTransaction(params, false);
        try {
            boolean containsForeignObjects = realFolderStorage.containsForeignObjects(user, treeId, folderId, params);
            if (started) {
                realFolderStorage.commitTransaction(params);
            }
            return containsForeignObjects;
        }
        catch (OXException e) {
            if (started) {
                realFolderStorage.rollback(params);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                realFolderStorage.rollback(params);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters params) throws OXException {
        FolderStorage realFolderStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorage(this.realTreeId, folderId);
        if (null == realFolderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = realFolderStorage.startTransaction(params, false);
        try {
            boolean isEmpty = realFolderStorage.isEmpty(this.realTreeId, folderId, params);
            if (started) {
                realFolderStorage.commitTransaction(params);
            }
            return isEmpty;
        }
        catch (OXException e) {
            if (started) {
                realFolderStorage.rollback(params);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                realFolderStorage.rollback(params);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters params) throws OXException {
        FolderStorage folderStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = folderStorage.startTransaction(params, false);
        try {
            folderStorage.updateLastModified(lastModified, this.realTreeId, folderId, params);
            MemoryTable.getMemoryTableFor(params.getSession()).initializeFolder(folderId, VirtualFolderStorage.unsignedInt(treeId), params.getUserId(), params.getContextId());
            if (started) {
                folderStorage.commitTransaction(params);
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(params);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(params);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters params) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, params);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters params) throws OXException {
        User user = params.getUser();
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(params.getSession());
        int contextId = params.getContextId();
        int tree = VirtualFolderStorage.unsignedInt(treeId);
        int userId = user.getId();
        MemoryTree memoryTree = memoryTable.getTree(tree, userId, contextId);
        Locale locale = user.getLocale();
        Map<String, Folder> realFolders = this.loadFolders(this.realTreeId, folderIds, storageType, params);
        ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
        for (String folderId : folderIds) {
            Folder realFolder = realFolders.get(folderId);
            if (null == realFolder) {
                Delete.deleteFolder(contextId, tree, userId, folderId, false, params.getSession());
                continue;
            }
            ret.add(this.getFolder0(realFolder, treeId, folderId, memoryTree, locale));
        }
        return ret;
    }

    private Map<String, Folder> loadFolders(final String treeId, final List<String> folderIds, final StorageType storageType, StorageParameters storageParameters) throws OXException {
        StorageParametersProvider paramsProvider;
        ThreadPoolCompletionService completionService;
        int size = folderIds.size();
        HashMap<FolderStorage, TIntList> map = new HashMap<FolderStorage, TIntList>(4);
        for (int i = 0; i < size; ++i) {
            String id = folderIds.get(i);
            FolderStorage tmp = VirtualFolderStorageRegistry.getInstance().getFolderStorage(treeId, id);
            if (null == tmp) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
            }
            TIntList list = (TIntList)map.get(tmp);
            if (null == list) {
                list = new TIntArrayList();
                map.put(tmp, list);
            }
            list.add(i);
        }
        if (1 == map.size()) {
            completionService = new CallerRunsCompletionService();
            paramsProvider = new InstanceStorageParametersProvider(storageParameters);
        } else {
            completionService = new ThreadPoolCompletionService((ThreadPoolService)CacheServiceRegistry.getServiceRegistry().getService(ThreadPoolService.class, true));
            Session session = storageParameters.getSession();
            paramsProvider = null == session ? new SessionStorageParametersProvider(storageParameters.getUser(), storageParameters.getContext()) : new SessionStorageParametersProvider((ServerSession)storageParameters.getSession());
        }
        final ConcurrentHashMap<String, Folder> ret = new ConcurrentHashMap<String, Folder>(size);
        int taskCount = 0;
        for (Map.Entry entry : map.entrySet()) {
            final FolderStorage tmp = (FolderStorage)entry.getKey();
            final int[] indexes = ((TIntList)entry.getValue()).toArray();
            completionService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    StorageParameters newParameters = paramsProvider.getStorageParameters();
                    ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(2);
                    if (tmp.startTransaction(newParameters, false)) {
                        openedStorages.add(tmp);
                    }
                    try {
                        ArrayList<String> ids = new ArrayList<String>(indexes.length);
                        for (int index : indexes) {
                            ids.add((String)folderIds.get(index));
                        }
                        List<Folder> folders2 = tmp.getFolders(treeId, ids, storageType, newParameters);
                        for (FolderStorage fs : openedStorages) {
                            fs.commitTransaction(newParameters);
                        }
                        for (Folder folder : folders2) {
                            ret.put(folder.getID(), folder);
                        }
                        return null;
                    }
                    catch (OXException e) {
                        for (FolderStorage fs : openedStorages) {
                            fs.rollback(newParameters);
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        for (FolderStorage fs : openedStorages) {
                            fs.rollback(newParameters);
                        }
                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[0]);
                    }
                }
            });
            ++taskCount;
        }
        ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, FACTORY);
        return ret;
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters params) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, params);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters params) throws OXException {
        User user = params.getUser();
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(params.getSession());
        MemoryTree memoryTree = memoryTable.getTree(VirtualFolderStorage.unsignedInt(treeId), user.getId(), params.getContextId());
        FolderStorage realFolderStorage = VirtualFolderStorageRegistry.getInstance().getFolderStorage(this.realTreeId, folderId);
        if (null == realFolderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = realFolderStorage.startTransaction(params, false);
        try {
            Folder realFolder = realFolderStorage.getFolder(this.realTreeId, folderId, params);
            Folder ret = this.getFolder0(realFolder, treeId, folderId, memoryTree, user.getLocale());
            if (started) {
                realFolderStorage.commitTransaction(params);
            }
            return ret;
        }
        catch (OXException e) {
            if (started) {
                realFolderStorage.rollback(params);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                realFolderStorage.rollback(params);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private Folder getFolder0(Folder realFolder, String treeId, String folderId, MemoryTree memoryTree, Locale locale) throws OXException {
        VirtualFolder virtualFolder = new VirtualFolder(realFolder);
        virtualFolder.setTreeID(treeId);
        virtualFolder.setID(folderId);
        if (!ROOT_ID.equals(folderId) && !memoryTree.fillFolder(virtualFolder)) {
            throw FolderExceptionErrorMessage.NOT_FOUND.create(folderId, treeId);
        }
        String[] subfolderIds = memoryTree.getSubfolderIds(locale, folderId, Collections.<String[]>emptyList());
        virtualFolder.setSubfolderIDs(subfolderIds);
        virtualFolder.setSubscribedSubfolders(subfolderIds != null && subfolderIds.length > 0);
        if (virtualFolder.isDefault()) {
            virtualFolder.setProperty(FIELD_NAME_PAIR_PREDEFINED, Boolean.TRUE);
        }
        return virtualFolder;
    }

    @Override
    public FolderType getFolderType() {
        return this.folderType;
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters params) throws OXException {
        User user = params.getUser();
        Locale locale = user.getLocale();
        MemoryTable memoryTable = MemoryTable.optMemoryTableFor(params.getSession());
        if (null != memoryTable) {
            MemoryTree memoryTree = memoryTable.getTree(VirtualFolderStorage.unsignedInt(treeId), params.getSession());
            if (null == memoryTree) {
                throw FolderExceptionErrorMessage.TREE_NOT_FOUND.create(treeId);
            }
            String[] ids = memoryTree.getSubfolderIds(locale, parentId, Collections.<String[]>emptyList());
            SortableId[] ret = new SortableId[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                ret[i] = new VirtualId(ids[i], i, null);
            }
            return ret;
        }
        String[] ids = Select.getSubfolderIds(params.getContextId(), VirtualFolderStorage.unsignedInt(treeId), user.getId(), locale, parentId, StorageType.WORKING);
        SortableId[] ret = new SortableId[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ret[i] = new VirtualId(ids[i], i, null);
        }
        return ret;
    }

    @Override
    public void rollback(StorageParameters params) {
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        return false;
    }

    @Override
    public void updateFolder(Folder folder, StorageParameters params) throws OXException {
        Folder storageFolder = this.getFolder(folder.getTreeID(), folder.getID(), params);
        if (null == folder.getParentID()) {
            folder.setParentID(storageFolder.getParentID());
        }
        if (null == folder.getPermissions()) {
            folder.setPermissions(storageFolder.getPermissions());
        }
        if (folder.getName() == null) {
            folder.setName(storageFolder.getName());
        }
        int tree = VirtualFolderStorage.unsignedInt(folder.getTreeID());
        int userId = params.getUserId();
        int contextId = params.getContextId();
        Update.updateFolder(contextId, tree, userId, folder, params.getSession());
        MemoryTable.getMemoryTableFor(params.getSession()).initializeTree(tree, userId, contextId);
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[0];
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters params) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, params);
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters params) throws OXException {
        if (ROOT_ID.equals(folderId)) {
            return true;
        }
        ServerSession session = this.getServerSession(params);
        return MemoryTable.getMemoryTableFor(session).getTree(VirtualFolderStorage.unsignedInt(treeId), session).containsFolder(folderId);
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters params) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters params) throws OXException {
        return new String[0];
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters params) throws OXException {
        User user = params.getUser();
        Locale locale = user.getLocale();
        ServerSession session = this.getServerSession(params);
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
        MemoryTree memoryTree = memoryTable.getTree(VirtualFolderStorage.unsignedInt(treeId), session);
        if (null == memoryTree) {
            throw FolderExceptionErrorMessage.TREE_NOT_FOUND.create(treeId);
        }
        ArrayList<Pair> list = new ArrayList<Pair>(32);
        VirtualFolderStorage.traverse(ROOT_ID, memoryTree, locale, list);
        Collections.sort(list, new PairComparator(locale));
        List<Folder> folders2 = this.loadFolderFor(list, params);
        ArrayList<VirtualId> ret = new ArrayList<VirtualId>(folders2.size());
        String cts = ((Object)contentType).toString();
        List<ContentType> contentTypes = Collections.singletonList(contentType);
        int index = 0;
        for (Folder folder : folders2) {
            if (!cts.equals(((Object)folder.getContentType()).toString()) || !CalculatePermission.calculate(folder, session, contentTypes).isVisible()) continue;
            ret.add(new VirtualId(folder.getID(), index++, folder.getLocalizedName(locale)));
        }
        return ret.toArray(new SortableId[ret.size()]);
    }

    private List<Folder> loadFolderFor(List<Pair> pairs, StorageParameters storageParameters) throws OXException {
        ArrayList<FolderStorage> openStorages = new ArrayList<FolderStorage>(4);
        try {
            ArrayList<Folder> folders2 = new ArrayList<Folder>(pairs.size());
            for (Pair pair : pairs) {
                String folderId = pair.id;
                FolderStorage fs = VirtualFolderStorageRegistry.getInstance().getFolderStorage(this.realTreeId, folderId);
                if (null == fs) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
                }
                VirtualFolderStorage.checkOpenedStorage(fs, false, openStorages, storageParameters);
                folders2.add(fs.getFolder(this.realTreeId, folderId, storageParameters));
            }
            for (FolderStorage fs : openStorages) {
                fs.commitTransaction(storageParameters);
            }
            return folders2;
        }
        catch (OXException e) {
            for (FolderStorage fs : openStorages) {
                fs.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openStorages) {
                fs.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void createDefaultFolder(Folder folder, StorageParameters params) throws OXException {
        int tree = VirtualFolderStorage.unsignedInt(folder.getTreeID());
        int contextId = params.getContextId();
        Insert.insertFolder(contextId, tree, params.getUserId(), folder, "default", params.getSession());
        MemoryTable.getMemoryTableFor(params.getSession()).initializeFolder(folder.getID(), tree, params.getUserId(), contextId);
    }

    private static void checkOpenedStorage(FolderStorage checkMe, boolean modify, Collection<FolderStorage> openedStorages, StorageParameters storageParameters) throws OXException {
        if (openedStorages.contains(checkMe) || !checkMe.startTransaction(storageParameters, modify)) {
            return;
        }
        openedStorages.add(checkMe);
    }

    private static void traverse(String parentId, MemoryTree memoryTree, Locale locale, List<Pair> list) {
        String[] ids;
        for (String id : ids = memoryTree.getSubfolderIds(locale, parentId, Collections.<String[]>emptyList())) {
            Pair pair = new Pair(id, memoryTree.getFolderName(id));
            list.add(pair);
            VirtualFolderStorage.traverse(id, memoryTree, locale, list);
        }
    }

    private static int unsignedInt(String sInteger) {
        return Tools.getUnsignedInteger(sInteger);
    }

    private ServerSession getServerSession(StorageParameters params) throws OXException {
        Session s = params.getSession();
        if (s instanceof ServerSession) {
            return (ServerSession)s;
        }
        return ServerSessionAdapter.valueOf(s);
    }

    private static final class PairComparator
    implements Comparator<Pair> {
        private final Collator collator;

        protected PairComparator(Locale locale) {
            this.collator = Collator.getInstance(locale == null ? Locale.US : locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(Pair o1, Pair o2) {
            return this.collator.compare(o1.name, o2.name);
        }
    }

    private static final class Pair {
        final String id;
        final String name;

        protected Pair(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

