/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCode;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public final class VirtualFolderDeleteListener
implements DeleteListener {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (event.getType() != 1) {
            return;
        }
        Statement stmt = null;
        try {
            int contextId = event.getContext().getContextId();
            int userId = event.getId();
            stmt = writeCon.prepareStatement("DELETE FROM virtualSubscription WHERE cid = ? AND user = ?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM virtualBackupSubscription WHERE cid = ? AND user = ?");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM virtualPermission WHERE cid = ? AND user = ?");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM virtualBackupPermission WHERE cid = ? AND user = ?");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM virtualTree WHERE cid = ? AND user = ?");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("DELETE FROM virtualBackupTree WHERE cid = ? AND user = ?");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(VirtualFolderDeleteListener.class)).error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

