/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.mail.MailFolderStorage;
import com.openexchange.folderstorage.mail.MailServiceRegistry;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;

public final class MailFolderStorageActivator
extends DeferredActivator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailFolderStorageActivator.class));
    private ServiceRegistration<FolderStorage> folderStorageRegistration;

    protected Class<?>[] getNeededServices() {
        return new Class[]{MailAccountStorageService.class, UnifiedInboxManagement.class, EventAdmin.class, ConfigurationService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
        MailServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
        MailServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = MailServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("tree", FolderStorage.REAL_TREE_ID);
            this.folderStorageRegistration = this.context.registerService(FolderStorage.class, (Object)new MailFolderStorage(), dictionary);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            if (null != this.folderStorageRegistration) {
                this.folderStorageRegistration.unregister();
                this.folderStorageRegistration = null;
            }
            MailServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

