/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.osgi;

import com.openexchange.database.DatabaseService;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.database.DatabaseFolderStorage;
import com.openexchange.folderstorage.database.DatabaseServiceRegistry;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.ServiceRegistration;

public final class DatabaseFolderStorageActivator
extends DeferredActivator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DatabaseFolderStorageActivator.class));
    private ServiceRegistration<FolderStorage> folderStorageRegistration;

    protected Class<?>[] getNeededServices() {
        return new Class[]{DatabaseService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
        DatabaseServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
        DatabaseServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = DatabaseServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("tree", FolderStorage.REAL_TREE_ID);
            this.folderStorageRegistration = this.context.registerService(FolderStorage.class, (Object)new DatabaseFolderStorage(), dictionary);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            if (null != this.folderStorageRegistration) {
                this.folderStorageRegistration.unregister();
                this.folderStorageRegistration = null;
            }
            DatabaseServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

