/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.lock;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public final class TreeLockManagement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TreeLockManagement.class));
    private static final TreeLockManagement INSTANCE = new TreeLockManagement();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, ConcurrentMap<String, ReadWriteLock>>> map = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, ConcurrentMap<String, ReadWriteLock>>>(32);
    static final Lock EMPTY_LOCK = new Lock(){

        @Override
        public void unlock() {
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public Condition newCondition() {
            return EMPTY_CONDITION;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public void lock() {
        }
    };
    static final Condition EMPTY_CONDITION = new Condition(){

        @Override
        public void signalAll() {
        }

        @Override
        public void signal() {
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            return true;
        }

        @Override
        public void awaitUninterruptibly() {
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            return 0L;
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void await() throws InterruptedException {
        }
    };
    private static final ReadWriteLock EMPTY_READ_WRITE_LOCK = new ReadWriteLock(){

        @Override
        public Lock writeLock() {
            return EMPTY_LOCK;
        }

        @Override
        public Lock readLock() {
            return EMPTY_LOCK;
        }
    };

    public static TreeLockManagement getInstance() {
        return INSTANCE;
    }

    private TreeLockManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(Session session) {
        ConcurrentMap userMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null != userMap) {
            userMap.remove(session.getUserId());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringAllocator("Cleaned folder locks for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).toString());
            }
        }
    }

    public void dropFor(int contextId) {
        this.map.remove(contextId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringAllocator("Cleaned folder locks for context ").append(contextId).toString());
        }
    }

    public ReadWriteLock getFor(String treeId, Session session) {
        return this.getFor(treeId, session.getUserId(), session.getContextId());
    }

    public ReadWriteLock getFor(String treeId, int userId, int contextId) {
        return EMPTY_READ_WRITE_LOCK;
    }

    public ReadWriteLock optFor(String treeId, Session session) {
        return EMPTY_READ_WRITE_LOCK;
    }
}

