/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.json.actions;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.java.Streams;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

@Action(method=RequestMethod.GET, name="range", description="Requesting a range from a formerly uploaded file", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The ID of the uploaded file."), @Parameter(name="off", description="The offset position to read from."), @Parameter(name="len", description="The number of bytes to read.")}, responseDescription="The content of the requested file range is directly written into output stream.")
@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public final class RangeAction
implements AJAXActionService {
    private final ServiceLookup services;

    public RangeAction(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        RandomAccessFile raf = null;
        try {
            String id = requestData.getParameter("id");
            if (id == null || id.length() == 0) {
                throw UploadException.UploadCode.MISSING_PARAM.create("id").setAction("range");
            }
            int off = requestData.getIntParameter("off");
            if (off < 0) {
                throw UploadException.UploadCode.MISSING_PARAM.create("off").setAction("range");
            }
            int len = requestData.getIntParameter("len");
            if (len < 0) {
                throw UploadException.UploadCode.MISSING_PARAM.create("len").setAction("range");
            }
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            ManagedFile file = management.getByID(id);
            String fileName = file.getFileName();
            String disposition = file.getContentDisposition();
            ContentType contentType = new ContentType(file.getContentType());
            if (null != fileName) {
                if (contentType.startsWith("application/octet-stream")) {
                    String ct = MimeType2ExtMap.getContentType(fileName);
                    int pos = ct.indexOf(47);
                    contentType.setPrimaryType(ct.substring(0, pos));
                    contentType.setSubType(ct.substring(pos + 1));
                }
                contentType.setParameter("name", fileName);
            }
            File tmpFile = file.getFile();
            raf = new RandomAccessFile(tmpFile, "r");
            long total = raf.length();
            ThresholdFileHolder fileHolder = new ThresholdFileHolder();
            if ((long)off >= total) {
                fileHolder.write(new byte[0]);
            } else {
                int toRead;
                int read;
                long available = total - (long)off;
                if (available < (long)len) {
                    len = (int)available;
                }
                raf.seek(off);
                int buflen = 2048;
                byte[] bytes = new byte[2048];
                for (int n = 0; n < len && (read = raf.read(bytes, 0, 2048 > (toRead = len - n) ? toRead : 2048)) > 0; n += read) {
                    fileHolder.write(bytes, 0, read);
                }
            }
            if (fileName != null) {
                fileHolder.setName(fileName);
            }
            fileHolder.setContentType(contentType.toString());
            fileHolder.setDisposition(disposition);
            requestData.setFormat("file");
            aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
        }
        catch (IOException e) {
            try {
                throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Streams.close(raf);
                throw throwable;
            }
        }
        Streams.close((Closeable)raf);
        return aJAXRequestResult;
    }
}

