/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileFilter;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.filemanagement.internal.ManagedFileImpl;
import com.openexchange.filemanagement.internal.ManagedInputStream;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

public final class ManagedFileManagementImpl
implements ManagedFileManagement {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ManagedFileManagementImpl.class));
    private static final int DELAY = 10000;
    private static final int INITIAL_DELAY = 1000;
    private static final String PREFIX = "open-xchange-";
    private static final String SUFFIX = ".tmp";
    private final ConfigurationService cs;
    private final TimerService timer;
    private final ConcurrentMap<String, ManagedFileImpl> files;
    private final PropertyListener propertyListener;
    private volatile ScheduledTimerTask timerTask;
    private final AtomicReference<File> tmpDirReference;

    public ManagedFileManagementImpl(ConfigurationService cs, TimerService timer) {
        this.cs = cs;
        this.timer = timer;
        this.files = new ConcurrentHashMap<String, ManagedFileImpl>();
        this.tmpDirReference = new AtomicReference();
        this.propertyListener = new FileManagementPropertyListener(this.tmpDirReference);
        String path = cs.getProperty("UPLOAD_DIRECTORY", this.propertyListener);
        this.tmpDirReference.set(this.getTmpDirByPath(path));
        this.timerTask = timer.scheduleWithFixedDelay((Runnable)new FileManagementTask(this.files, 300000, LOG), 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public InputStream createInputStream(byte[] bytes) throws OXException {
        return new ManagedInputStream(bytes, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(byte[] bytes, int capacity) throws OXException {
        return new ManagedInputStream(bytes, capacity, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in) throws OXException {
        return new ManagedInputStream(in, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in, int capacity) throws OXException {
        return new ManagedInputStream(in, capacity, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in, int size, int capacity) throws OXException {
        return new ManagedInputStream(in, size, capacity, this);
    }

    public void clear() {
        Iterator iter = this.files.values().iterator();
        while (iter.hasNext()) {
            ((ManagedFileImpl)iter.next()).delete();
        }
        this.files.clear();
    }

    public File newTempFile() throws OXException {
        return this.newTempFile(PREFIX, SUFFIX);
    }

    public File newTempFile(String prefix, String suffix) throws OXException {
        File tmpFile = null;
        File directory = null;
        do {
            directory = this.tmpDirReference.get();
            try {
                if (null == tmpFile) {
                    tmpFile = File.createTempFile(prefix, suffix, directory);
                    tmpFile.deleteOnExit();
                    continue;
                }
                File tmp = File.createTempFile(prefix, suffix, directory);
                if (!tmpFile.delete()) {
                    LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()));
                }
                tmpFile = tmp;
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                if (tmpFile != null && !tmpFile.delete() && LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()), (Throwable)e);
                }
                throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        } while (!this.tmpDirReference.compareAndSet(directory, directory));
        return tmpFile;
    }

    public ManagedFile createManagedFile(File temporaryFile) throws OXException {
        ManagedFileImpl mf = new ManagedFileImpl(this, UUID.randomUUID().toString(), temporaryFile);
        mf.setSize(temporaryFile.length());
        this.files.put(mf.getID(), mf);
        return mf;
    }

    public ManagedFile createManagedFile(byte[] bytes) throws OXException {
        return this.createManagedFile0(null, (InputStream)new UnsynchronizedByteArrayInputStream(bytes), false, null, -1);
    }

    public ManagedFile createManagedFile(InputStream inputStream) throws OXException {
        return this.createManagedFile(null, inputStream);
    }

    public ManagedFile createManagedFile(String id, InputStream inputStream) throws OXException {
        return this.createManagedFile0(id, inputStream, true, null, -1);
    }

    public ManagedFile createManagedFile(String id, InputStream inputStream, int ttl) throws OXException {
        return this.createManagedFile0(id, inputStream, true, null, ttl);
    }

    public ManagedFile createManagedFile(InputStream inputStream, String optExtension) throws OXException {
        return this.createManagedFile0(null, inputStream, true, optExtension, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedFile createManagedFile0(String identifier, InputStream inputStream, boolean closeStream, String optExtension, int optTtl) throws OXException {
        if (null == inputStream) {
            throw new IllegalArgumentException("Missing input stream.");
        }
        ManagedFileImpl mf = null;
        File tmpFile = null;
        File directory = null;
        String id = identifier;
        do {
            block17: {
                directory = this.tmpDirReference.get();
                try {
                    if (null == tmpFile) {
                        tmpFile = File.createTempFile(PREFIX, null == optExtension ? SUFFIX : optExtension, directory);
                        tmpFile.deleteOnExit();
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile, false));
                        try {
                            byte[] buf = new byte[8192];
                            int len = -1;
                            while ((len = inputStream.read(buf, 0, buf.length)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((OutputStream)out).flush();
                            break block17;
                        }
                        finally {
                            Streams.close((Closeable)out);
                        }
                    }
                    File tmp = File.createTempFile(PREFIX, SUFFIX, directory);
                    ManagedFileManagementImpl.copyFile(tmpFile, tmp);
                    if (!tmpFile.delete()) {
                        LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()));
                    }
                    tmpFile = tmp;
                    tmpFile.deleteOnExit();
                }
                catch (IOException e) {
                    if (tmpFile != null && !tmpFile.delete() && LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()), (Throwable)e);
                    }
                    throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    if (closeStream) {
                        Streams.close((Closeable)inputStream);
                    }
                }
            }
            if (ManagedFileManagementImpl.isEmpty(id)) {
                id = UUID.randomUUID().toString();
            }
            mf = new ManagedFileImpl(this, id, tmpFile, optTtl);
            mf.setSize(tmpFile.length());
        } while (!this.tmpDirReference.compareAndSet(directory, directory));
        this.files.put(mf.getID(), mf);
        DistributedFileManagement distributed = this.getDistributed();
        if (distributed != null && !distributed.exists(id)) {
            distributed.register(id);
        }
        return mf;
    }

    public boolean containsLocal(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf || mf.isDeleted()) {
            return false;
        }
        mf.touch();
        return true;
    }

    public boolean contains(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf || mf.isDeleted()) {
            return this.containsDistributed(id);
        }
        mf.touch();
        return true;
    }

    private boolean containsDistributed(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement == null) {
            return false;
        }
        try {
            if (distributedFileManagement.exists(id)) {
                distributedFileManagement.touch(id);
                return true;
            }
        }
        catch (OXException e) {
            return false;
        }
        return false;
    }

    public List<ManagedFile> getManagedFiles() throws OXException {
        return this.getManagedFiles(null);
    }

    public List<ManagedFile> getManagedFiles(ManagedFileFilter filter) throws OXException {
        if (null == filter) {
            return new ArrayList<ManagedFile>(this.files.values());
        }
        ArrayList<ManagedFile> list = new ArrayList<ManagedFile>(this.files.size());
        for (ManagedFileImpl managedFile : this.files.values()) {
            if (!filter.accept((ManagedFile)managedFile)) continue;
            list.add(managedFile);
        }
        return list;
    }

    public ManagedFile getByID(String id) throws OXException {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null != mf) {
            if (mf.isDeleted()) {
                throw ManagedFileExceptionErrorMessage.NOT_FOUND.create(new Object[]{id});
            }
            mf.touch();
            return mf;
        }
        mf = this.getByIDDistributed(id);
        if (null == mf || mf.isDeleted()) {
            throw ManagedFileExceptionErrorMessage.NOT_FOUND.create(new Object[]{id});
        }
        mf.touch();
        return mf;
    }

    private ManagedFile getByIDDistributed(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement == null) {
            return null;
        }
        try {
            if (!distributedFileManagement.exists(id)) {
                return null;
            }
            ManagedFile managedFile = this.createManagedFile(id, distributedFileManagement.get(id));
            try {
                distributedFileManagement.touch(id);
            }
            catch (Exception e) {
                // empty catch block
            }
            return managedFile;
        }
        catch (OXException e) {
            return null;
        }
    }

    File getTmpDirByPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("Path is null. Probably property \"UPLOAD_DIRECTORY\" is not set.");
        }
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            throw new IllegalArgumentException("Directory " + path + " does not exist.");
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory.");
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByID(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf) {
            this.removeByIDDistributed(id);
            return;
        }
        try {
            if (!mf.isDeleted()) {
                mf.delete();
                DistributedFileManagement distributedFileManagement = this.getDistributed();
                if (distributedFileManagement != null) {
                    distributedFileManagement.unregister(id);
                }
            }
        }
        catch (OXException oXException) {
        }
        finally {
            this.files.remove(mf.getID());
        }
    }

    private void removeByIDDistributed(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement == null) {
            return;
        }
        try {
            distributedFileManagement.remove(id);
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    void removeFromFiles(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement != null) {
            try {
                distributedFileManagement.unregister(id);
            }
            catch (OXException oXException) {
                // empty catch block
            }
        }
        this.files.remove(id);
    }

    public void shutDown() {
        this.shutDown(true);
    }

    void shutDown(boolean complete) {
        ScheduledTimerTask timerTask;
        if (complete && this.propertyListener != null) {
            this.cs.removePropertyListener("UPLOAD_DIRECTORY", this.propertyListener);
        }
        if ((timerTask = this.timerTask) != null) {
            timerTask.cancel(true);
            this.timerTask = null;
            this.timer.purge();
        }
        this.tmpDirReference.set(null);
        this.clear();
    }

    void startUp() {
        ScheduledTimerTask timerTask = this.timerTask;
        if (timerTask != null) {
            timerTask.cancel(true);
        }
        this.timerTask = this.timer.scheduleWithFixedDelay((Runnable)new FileManagementTask(this.files, 300000, LOG), 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private DistributedFileManagement getDistributed() {
        return ServerServiceRegistry.getInstance().getService(DistributedFileManagement.class);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static class FileManagementTask
    implements Runnable {
        private final Log logger;
        private final ConcurrentMap<String, ManagedFileImpl> tfiles;
        private final int time2live;

        public FileManagementTask(ConcurrentMap<String, ManagedFileImpl> files, int time2live, Log logger) {
            this.tfiles = files;
            this.time2live = time2live;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                long now = System.currentTimeMillis();
                Iterator iter = this.tfiles.values().iterator();
                while (iter.hasNext()) {
                    ManagedFileImpl cur = (ManagedFileImpl)iter.next();
                    int optTimeToLive = cur.optTimeToLive();
                    if (!cur.isDeleted() && now - cur.getLastAccess() <= (long)(optTimeToLive > 0 ? optTimeToLive : this.time2live)) continue;
                    cur.delete();
                    iter.remove();
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)t.getMessage(), t);
            }
        }
    }

    private class FileManagementPropertyListener
    implements PropertyListener {
        private final AtomicReference<File> ttmpDirReference;

        public FileManagementPropertyListener(AtomicReference<File> tmpDirReference) {
            this.ttmpDirReference = tmpDirReference;
        }

        public void onPropertyChange(PropertyEvent event) {
            if (PropertyEvent.Type.CHANGED.equals((Object)event.getType())) {
                this.ttmpDirReference.set(ManagedFileManagementImpl.this.getTmpDirByPath(event.getValue()));
                ManagedFileManagementImpl.this.startUp();
            } else {
                ManagedFileManagementImpl.this.shutDown(false);
            }
        }
    }
}

