/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.tx;

import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tx.AbstractUndoable;
import com.openexchange.tx.UndoableAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractDBAction
extends AbstractUndoable
implements UndoableAction {
    static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AbstractDBAction.class));
    private DBProvider provider = null;
    private Context context = null;

    protected AbstractDBAction() {
    }

    protected int doUpdates(UpdateBlock ... updates) throws OXException {
        Connection writeCon = null;
        UpdateBlock current = null;
        int counter = 0;
        try {
            writeCon = this.getProvider().getWriteConnection(this.getContext());
            UpdateBlock[] arr$ = updates;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                UpdateBlock update;
                current = update = arr$[i$];
                counter += current.performUpdate(writeCon);
                current.close();
            }
        }
        catch (SQLException e) {
            throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (current != null) {
                try {
                    current.close();
                }
                catch (Exception e) {}
            }
            if (writeCon != null) {
                this.provider.releaseWriteConnection(this.getContext(), writeCon);
            }
        }
        return counter;
    }

    protected int doUpdates(List<UpdateBlock> updates) throws OXException, OXException {
        return this.doUpdates(updates.toArray(new UpdateBlock[updates.size()]));
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setProvider(DBProvider provider) {
        this.provider = provider;
    }

    public DBProvider getProvider() {
        return this.provider;
    }

    protected static class OXExceptionRenamed
    extends Exception {
        private static final long serialVersionUID = -3823990951502455901L;
        private final UpdateBlock update;
        private final SQLException sqle;

        public OXExceptionRenamed(SQLException sqle, UpdateBlock update) {
            super(sqle);
            this.sqle = sqle;
            this.update = update;
        }

        public SQLException getSQLException() {
            return this.sqle;
        }

        public UpdateBlock getUpdate() {
            return this.update;
        }

        public String getStatement() {
            return this.update.getStatement();
        }
    }

    protected abstract class Update
    implements UpdateBlock {
        protected PreparedStatement stmt;
        protected ResultSet rs;
        protected final String sql;
        protected String statementString;

        public Update(String sql) {
            this.sql = sql;
        }

        @Override
        public void close() {
            DBUtils.closeSQLStuff(this.rs, this.stmt);
        }

        @Override
        public int performUpdate(Connection writeCon) throws SQLException {
            this.stmt = writeCon.prepareStatement(this.sql);
            this.fillStatement();
            this.statementString = this.stmt.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)this.statementString);
            }
            int updated = this.stmt.executeUpdate();
            return updated;
        }

        public abstract void fillStatement() throws SQLException;

        @Override
        public String getStatement() {
            return this.statementString == null ? this.sql : this.statementString;
        }
    }

    protected static interface UpdateBlock {
        public int performUpdate(Connection var1) throws SQLException;

        public String getStatement();

        public void close();
    }
}

