/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.internal.Check;
import com.openexchange.contact.internal.Tools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.search.SearchTerm;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;
import java.util.List;

public abstract class DefaultContactService
implements ContactService {
    protected static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DefaultContactService.class));

    public DefaultContactService() {
        LOG.debug((Object)"initialized.");
    }

    @Override
    public Contact getContact(Session session, String folderId, String id) throws OXException {
        return this.getContact(session, folderId, id, null);
    }

    @Override
    public SearchIterator<Contact> getAllContacts(Session session, String folderId) throws OXException {
        return this.getAllContacts(session, folderId, null, null);
    }

    @Override
    public SearchIterator<Contact> getAllContacts(Session session, String folderId, SortOptions sortOptions) throws OXException {
        return this.getAllContacts(session, folderId, null, sortOptions);
    }

    @Override
    public SearchIterator<Contact> getAllContacts(Session session, String folderId, ContactField[] fields) throws OXException {
        return this.getAllContacts(session, folderId, fields, null);
    }

    @Override
    public SearchIterator<Contact> getContacts(Session session, String folderId, String[] ids) throws OXException {
        return this.getContacts(session, folderId, ids, null, null);
    }

    @Override
    public SearchIterator<Contact> getContacts(Session session, String folderId, String[] ids, SortOptions sortOptions) throws OXException {
        return this.getContacts(session, folderId, ids, null, sortOptions);
    }

    @Override
    public SearchIterator<Contact> getContacts(Session session, String folderId, String[] ids, ContactField[] fields) throws OXException {
        return this.getContacts(session, folderId, ids, fields, null);
    }

    @Override
    public SearchIterator<Contact> getDeletedContacts(Session session, String folderId, Date since) throws OXException {
        return this.getDeletedContacts(session, folderId, since, null);
    }

    @Override
    public SearchIterator<Contact> getDeletedContacts(Session session, String folderId, Date since, ContactField[] fields) throws OXException {
        return this.getDeletedContacts(session, folderId, since, fields, null);
    }

    @Override
    public SearchIterator<Contact> getModifiedContacts(Session session, String folderId, Date since) throws OXException {
        return this.getModifiedContacts(session, folderId, since, null);
    }

    @Override
    public SearchIterator<Contact> getModifiedContacts(Session session, String folderId, Date since, ContactField[] fields) throws OXException {
        return this.getModifiedContacts(session, folderId, since, fields, SortOptions.EMPTY);
    }

    @Override
    public <O> SearchIterator<Contact> searchContacts(Session session, SearchTerm<O> term) throws OXException {
        return this.searchContacts(session, term, null, null);
    }

    @Override
    public <O> SearchIterator<Contact> searchContacts(Session session, SearchTerm<O> term, SortOptions sortOptions) throws OXException {
        return this.searchContacts(session, term, null, sortOptions);
    }

    @Override
    public <O> SearchIterator<Contact> searchContacts(Session session, SearchTerm<O> term, ContactField[] fields) throws OXException {
        return this.searchContacts(session, term, fields, null);
    }

    @Override
    public SearchIterator<Contact> searchContacts(Session session, ContactSearchObject contactSearch) throws OXException {
        return this.searchContacts(session, contactSearch, null, null);
    }

    @Override
    public SearchIterator<Contact> searchContacts(Session session, ContactSearchObject contactSearch, SortOptions sortOptions) throws OXException {
        return this.searchContacts(session, contactSearch, null, sortOptions);
    }

    @Override
    public SearchIterator<Contact> searchContacts(Session session, ContactSearchObject contactSearch, ContactField[] fields) throws OXException {
        return this.searchContacts(session, contactSearch, fields, null);
    }

    @Override
    public Contact getUser(Session session, int userID) throws OXException {
        return this.getUser(session, userID, null);
    }

    @Override
    public SearchIterator<Contact> getUsers(Session session, int[] userIDs) throws OXException {
        return this.getUsers(session, userIDs, null);
    }

    @Override
    public SearchIterator<Contact> searchContactsWithBirthday(Session session, Date from, Date until, ContactField[] fields, SortOptions sortOptions) throws OXException {
        return this.searchContactsWithBirthday(session, null, from, until, fields, sortOptions);
    }

    @Override
    public SearchIterator<Contact> searchContactsWithAnniversary(Session session, Date from, Date until, ContactField[] fields, SortOptions sortOptions) throws OXException {
        return this.searchContactsWithAnniversary(session, null, from, until, fields, sortOptions);
    }

    @Override
    public <O> SearchIterator<Contact> searchContacts(Session session, SearchTerm<O> term, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(term, "term");
        return this.doSearchContacts(session, term, fields, sortOptions);
    }

    @Override
    public SearchIterator<Contact> searchContacts(Session session, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(contactSearch, "contactSearch");
        return this.doSearchContacts(session, Tools.prepareContactSearch(contactSearch), fields, sortOptions);
    }

    @Override
    public SearchIterator<Contact> getAllContacts(Session session, String folderId, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        return this.doGetContacts(false, session, folderId, null, fields, sortOptions, null);
    }

    @Override
    public SearchIterator<Contact> getAllContacts(Session session, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        return this.doGetContacts(session, null, fields, sortOptions);
    }

    @Override
    public SearchIterator<Contact> getAllContacts(Session session, List<String> folderIDs, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderIDs, "folderIDs");
        return this.doGetContacts(session, folderIDs, fields, sortOptions);
    }

    @Override
    public int countContacts(Session session, String folderId) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        return this.doCountContacts(session, folderId);
    }

    @Override
    public SearchIterator<Contact> getContacts(Session session, String folderId, String[] ids, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(ids, "ids");
        return this.doGetContacts(false, session, folderId, ids, fields, sortOptions, null);
    }

    @Override
    public SearchIterator<Contact> getModifiedContacts(Session session, String folderId, Date since, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(since, "since");
        return this.doGetContacts(false, session, folderId, null, fields, sortOptions, since);
    }

    @Override
    public SearchIterator<Contact> getDeletedContacts(Session session, String folderId, Date since, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(since, "since");
        return this.doGetContacts(true, session, folderId, null, fields, sortOptions, since);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contact getContact(Session session, String folderId, String id, ContactField[] fields) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(id, "id");
        Contact contact = null;
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = this.doGetContacts(false, session, folderId, new String[]{id}, fields, null, null);
            contact = (Contact)searchIterator.next();
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        Check.contactNotNull(contact, session.getContextId(), session.getUserId());
        return contact;
    }

    @Override
    public void createContact(Session session, String folderId, Contact contact) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(contact, "contact");
        this.doCreateContact(session, folderId, contact);
    }

    @Override
    public void updateContact(Session session, String folderId, String id, Contact contact, Date lastRead) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(id, "id");
        Check.argNotNull(lastRead, "lastRead");
        Check.argNotNull(contact, "contact");
        if (contact.containsParentFolderID() && contact.getParentFolderID() != Tools.parse(folderId)) {
            this.doUpdateAndMoveContact(session, folderId, Integer.toString(contact.getParentFolderID()), id, contact, lastRead);
        } else {
            this.doUpdateContact(session, folderId, id, contact, lastRead);
        }
    }

    @Override
    public void updateUser(Session session, String folderId, String id, Contact contact, Date lastRead) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(id, "id");
        Check.argNotNull(lastRead, "lastRead");
        Check.argNotNull(contact, "contact");
        if (contact.containsParentFolderID() && contact.getParentFolderID() != Tools.parse(folderId)) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(id), session.getContextId());
        }
        this.doUpdateUser(session, folderId, id, contact, lastRead);
    }

    @Override
    public void deleteContact(Session session, String folderId, String id, Date lastRead) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(id, "id");
        Check.argNotNull(lastRead, "lastRead");
        this.doDeleteContact(session, folderId, id, lastRead);
    }

    @Override
    public void deleteContacts(Session session, String folderId, String[] ids, Date lastRead) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        Check.argNotNull(ids, "ids");
        Check.argNotNull(lastRead, "lastRead");
        this.doDeleteContacts(session, folderId, ids, lastRead);
    }

    @Override
    public void deleteContacts(Session session, String folderId) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderId, "folderId");
        this.doDeleteContacts(session, folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contact getUser(Session session, int userID, ContactField[] fields) throws OXException {
        Check.argNotNull(session, "session");
        Contact contact = null;
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = this.doGetUsers(session, new int[]{userID}, (SearchTerm)null, fields, null);
            contact = (Contact)searchIterator.next();
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        Check.contactNotNull(contact, session.getContextId(), userID);
        return contact;
    }

    @Override
    public SearchIterator<Contact> getUsers(Session session, int[] userIDs, ContactField[] fields) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(userIDs, "userIDs");
        return this.doGetUsers(session, userIDs, (SearchTerm)null, fields, null);
    }

    @Override
    public SearchIterator<Contact> getAllUsers(Session session, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        return this.doGetUsers(session, null, (SearchTerm)null, fields, sortOptions);
    }

    @Override
    public <O> SearchIterator<Contact> searchUsers(Session session, SearchTerm<O> term, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(term, "term");
        return this.doGetUsers(session, null, term, fields, sortOptions);
    }

    @Override
    public SearchIterator<Contact> searchUsers(Session session, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(contactSearch, "contactSearch");
        return this.doGetUsers(session, null, contactSearch, fields, sortOptions);
    }

    @Override
    public String getOrganization(Session session) throws OXException {
        Check.argNotNull(session, "session");
        return this.doGetOrganization(session);
    }

    @Override
    public SearchIterator<Contact> searchContactsWithAnniversary(Session session, List<String> folderIDs, Date from, Date until, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(from, "from");
        Check.argNotNull(until, "until");
        return this.doSearchContactsWithAnniversary(session, from, until, folderIDs, fields, sortOptions);
    }

    @Override
    public SearchIterator<Contact> searchContactsWithBirthday(Session session, List<String> folderIDs, Date from, Date until, ContactField[] fields, SortOptions sortOptions) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(from, "from");
        Check.argNotNull(until, "until");
        if (from.after(until)) {
            throw new IllegalArgumentException("'from' must not be after 'until'");
        }
        return this.doSearchContactsWithBirthday(session, from, until, folderIDs, fields, sortOptions);
    }

    @Override
    public boolean isFolderEmpty(Session session, String folderID) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderID, "folderID");
        return this.doCheckIfFolderIsEmpty(session, folderID);
    }

    @Override
    public boolean containsForeignObjectInFolder(Session session, String folderID) throws OXException {
        Check.argNotNull(session, "session");
        Check.argNotNull(folderID, "folderID");
        return this.doCheckIfFolderContainsForeignObjects(session, folderID);
    }

    protected abstract void doCreateContact(Session var1, String var2, Contact var3) throws OXException;

    protected abstract void doUpdateAndMoveContact(Session var1, String var2, String var3, String var4, Contact var5, Date var6) throws OXException;

    protected abstract void doUpdateContact(Session var1, String var2, String var3, Contact var4, Date var5) throws OXException;

    protected abstract void doUpdateUser(Session var1, String var2, String var3, Contact var4, Date var5) throws OXException;

    protected abstract void doDeleteContact(Session var1, String var2, String var3, Date var4) throws OXException;

    protected abstract void doDeleteContacts(Session var1, String var2, String[] var3, Date var4) throws OXException;

    protected abstract void doDeleteContacts(Session var1, String var2) throws OXException;

    protected abstract <O> SearchIterator<Contact> doGetContacts(boolean var1, Session var2, String var3, String[] var4, ContactField[] var5, SortOptions var6, Date var7) throws OXException;

    protected abstract <O> SearchIterator<Contact> doSearchContacts(Session var1, SearchTerm<O> var2, ContactField[] var3, SortOptions var4) throws OXException;

    protected abstract SearchIterator<Contact> doSearchContacts(Session var1, ContactSearchObject var2, ContactField[] var3, SortOptions var4) throws OXException;

    protected abstract String doGetOrganization(Session var1) throws OXException;

    protected abstract <O> SearchIterator<Contact> doGetUsers(Session var1, int[] var2, SearchTerm<O> var3, ContactField[] var4, SortOptions var5) throws OXException;

    protected abstract SearchIterator<Contact> doGetUsers(Session var1, int[] var2, ContactSearchObject var3, ContactField[] var4, SortOptions var5) throws OXException;

    protected abstract SearchIterator<Contact> doSearchContactsWithBirthday(Session var1, Date var2, Date var3, List<String> var4, ContactField[] var5, SortOptions var6) throws OXException;

    protected abstract SearchIterator<Contact> doSearchContactsWithAnniversary(Session var1, Date var2, Date var3, List<String> var4, ContactField[] var5, SortOptions var6) throws OXException;

    protected abstract SearchIterator<Contact> doGetContacts(Session var1, List<String> var2, ContactField[] var3, SortOptions var4) throws OXException;

    protected abstract int doCountContacts(Session var1, String var2) throws OXException;

    protected abstract boolean doCheckIfFolderIsEmpty(Session var1, String var2) throws OXException;

    protected abstract boolean doCheckIfFolderContainsForeignObjects(Session var1, String var2) throws OXException;
}

