/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.remote;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.remote.GenericCacheInvalidationInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;

public class FolderCacheInvalidation
implements GenericCacheInvalidationInterface {
    private static final Log LOG = LogFactory.getLog(FolderCacheInvalidation.class);
    private static final String REMOTE_NAME = "FolderCacheInvalidation";
    private static final String ERR = "Folder could not be remote-removed";

    @Override
    public String getRemoteName() {
        return REMOTE_NAME;
    }

    @Override
    public void invalidateCacheElement(int contextId, int objectId) throws RemoteException {
        ConditionTreeMapManagement.dropFor(contextId);
        if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
            try {
                FolderCacheManager.getInstance().removeFolderObject(objectId, ContextStorage.getInstance().getContext(contextId));
            }
            catch (OXException e) {
                throw new RemoteException(ERR, e);
            }
        }
    }

    @Override
    public void invalidateContext(int contextId) throws RemoteException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Method invalidateContext() not implemented");
        }
    }
}

