/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.registry;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class CacheAvailabilityRegistry {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static volatile CacheAvailabilityRegistry instance;
    private final Set<Class<? extends CacheAvailabilityListener>> classes;
    private final List<CacheAvailabilityListener> listeners;
    private final Lock registryLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initInstance() {
        if (!INITIALIZED.get()) {
            AtomicBoolean atomicBoolean = INITIALIZED;
            synchronized (atomicBoolean) {
                if (instance == null) {
                    instance = new CacheAvailabilityRegistry();
                    instance.init();
                    INITIALIZED.set(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseInstance() {
        if (INITIALIZED.get()) {
            AtomicBoolean atomicBoolean = INITIALIZED;
            synchronized (atomicBoolean) {
                if (instance != null) {
                    instance = null;
                    INITIALIZED.set(false);
                }
            }
        }
    }

    public static CacheAvailabilityRegistry getInstance() {
        return instance;
    }

    private void init() {
    }

    private CacheAvailabilityRegistry() {
        this.listeners = new ArrayList<CacheAvailabilityListener>();
        this.classes = new HashSet<Class<? extends CacheAvailabilityListener>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAbsence() throws OXException {
        this.registryLock.lock();
        try {
            int size = this.listeners.size();
            Iterator<CacheAvailabilityListener> iter = this.listeners.iterator();
            for (int i = 0; i < size; ++i) {
                iter.next().handleAbsence();
            }
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAvailability() throws OXException {
        this.registryLock.lock();
        try {
            int size = this.listeners.size();
            Iterator<CacheAvailabilityListener> iter = this.listeners.iterator();
            for (int i = 0; i < size; ++i) {
                iter.next().handleAvailability();
            }
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerListener(CacheAvailabilityListener listener) {
        this.registryLock.lock();
        try {
            if (this.classes.contains(listener.getClass())) {
                boolean bl = false;
                return bl;
            }
            this.listeners.add(listener);
            this.classes.add(listener.getClass());
            boolean bl = true;
            return bl;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(CacheAvailabilityListener listener) {
        this.registryLock.lock();
        try {
            Class<?> clazz = listener.getClass();
            if (!this.classes.contains(clazz)) {
                return;
            }
            if (!this.listeners.remove(listener)) {
                int size = this.listeners.size();
                for (int i = 0; i < size; ++i) {
                    if (!clazz.equals(this.listeners.get(i).getClass())) continue;
                    this.listeners.remove(i);
                    size = 0;
                }
            }
            this.classes.remove(clazz);
        }
        finally {
            this.registryLock.unlock();
        }
    }
}

