/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.console;

import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBean;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class PreviewCacheTool {
    private static final Options sOptions = new Options();

    private PreviewCacheTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        boolean error = true;
        try {
            CommandLine cmd = parser.parse(sOptions, args);
            if (cmd.hasOption('h')) {
                PreviewCacheTool.printHelp();
                System.exit(0);
                return;
            }
            if (!cmd.hasOption('c')) {
                System.out.println("Parameter 'context' is required.");
                PreviewCacheTool.printHelp();
                System.exit(1);
                return;
            }
            String contextOptionVal = cmd.getOptionValue('c');
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9999/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, null);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                try {
                    ResourceCacheMBean previceCacheProxy = PreviewCacheTool.previewCacheMBean(mbsc);
                    previceCacheProxy.clearFor(Integer.parseInt(contextOptionVal.trim()));
                    System.out.println("All cache entries cleared for context " + contextOptionVal);
                }
                catch (Exception e) {
                    String errMsg = e.getMessage();
                    System.out.println(errMsg == null ? "An error occurred." : errMsg);
                }
            }
            finally {
                try {
                    jmxConnector.close();
                }
                catch (Exception e) {}
            }
            error = false;
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            PreviewCacheTool.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
    }

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("clearpreviewcache", sOptions);
    }

    private static ResourceCacheMBean previewCacheMBean(MBeanServerConnection mbsc) throws MalformedObjectNameException {
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, PreviewCacheTool.getObjectName(ResourceCacheMBean.class.getName(), "com.openexchange.preview.cache"), ResourceCacheMBean.class, false);
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }

    static {
        sOptions.addOption("h", "help", false, "Prints a help text");
        sOptions.addOption("c", "context", true, "Required. The context identifier");
    }
}

