/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewConst;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.preview.ContentTypeChecker;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PreviewImageResultConverter
extends AbstractPreviewResultConverter {
    private static final String PARAMETER_ACTION = "action";
    private static final String PARAMETER_SESSION = "session";
    private static final Set<String> INVALIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/octet-stream", "application/force-download", "application/binary", "application/x-download", "application/octet-stream", "application/vnd", "application/vnd.ms-word.document.12n", "application/vnd.ms-word.document.12", "application/vnd.ms-word", "application/odt", "application/x-pdf")));

    @Override
    public String getOutputFormat() {
        return "preview_image";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.IMAGE;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, final ServerSession session, Converter converter) throws OXException {
        try {
            String cacheKey;
            CachedResource cachedPreview;
            boolean isValidEtag;
            final ResourceCache previewCache = ResourceCaches.getResourceCache();
            String eTag = result.getHeader("ETag");
            boolean bl = isValidEtag = !Strings.isEmpty((String)eTag);
            if (null != previewCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", requestData, true) && null != (cachedPreview = previewCache.get(cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, requestData), 0, session.getContextId()))) {
                InputStream inputStream;
                requestData.setFormat("file");
                String contentType = cachedPreview.getFileType();
                if (null == contentType) {
                    contentType = "image/jpeg";
                }
                if (null == (inputStream = cachedPreview.getInputStream())) {
                    ByteArrayFileHolder responseFileHolder = new ByteArrayFileHolder(cachedPreview.getBytes());
                    responseFileHolder.setContentType(contentType);
                    responseFileHolder.setName(cachedPreview.getFileName());
                    result.setResultObject(responseFileHolder, "file");
                } else {
                    FileHolder responseFileHolder = new FileHolder(inputStream, cachedPreview.getSize(), contentType, cachedPreview.getFileName());
                    result.setResultObject(responseFileHolder, "file");
                }
                return;
            }
            Object resultObject = result.getResultObject();
            if (!(resultObject instanceof IFileHolder)) {
                throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
            }
            IFileHolder fileHolder = (IFileHolder)resultObject;
            InputStream stream = fileHolder.getStream();
            if (0L == fileHolder.getLength()) {
                Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                this.setDefaulThumbnail(requestData, result);
                return;
            }
            AbstractPreviewResultConverter.Ref<InputStream> ref = new AbstractPreviewResultConverter.Ref<InputStream>();
            if (PreviewImageResultConverter.streamIsEof(stream, ref)) {
                Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                this.setDefaulThumbnail(requestData, result);
                return;
            }
            stream = ref.getValue();
            PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
            DataProperties dataProperties = new DataProperties(9);
            dataProperties.put("com.openexchange.conversion.content-type", this.getContentType(fileHolder, previewService instanceof ContentTypeChecker ? (ContentTypeChecker)previewService : null));
            dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
            dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
            dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
            dataProperties.put("PreviewType", requestData.getModule().equals("files") ? "DetailView" : "Thumbnail");
            dataProperties.put("PreviewWidth", requestData.getParameter("width"));
            dataProperties.put("PreviewHeight", requestData.getParameter("height"));
            dataProperties.put("PreviewDelivery", requestData.getParameter("delivery"));
            dataProperties.put("PreviewScaleType", requestData.getParameter("scaleType"));
            PreviewDocument previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)stream, dataProperties), this.getOutput(), (Session)session, 1);
            requestData.setFormat("file");
            InputStream thumbnail = previewDocument.getThumbnail();
            if (null == thumbnail) {
                throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create();
            }
            if (previewDocument.getClass().getName().equals("com.openexchange.documentpreview.OfficePreviewDocument")) {
                requestData.putParameter("transformationNeeded", "false");
            }
            final String fileName = (String)previewDocument.getMetaData().get("resourcename");
            int size = -1;
            if (null != previewCache && isValidEtag) {
                final byte[] bytes = Streams.stream2bytes((InputStream)thumbnail);
                thumbnail = Streams.newByteArrayInputStream((byte[])bytes);
                size = bytes.length;
                final String cacheKey2 = ResourceCaches.generatePreviewCacheKey(eTag, requestData);
                AbstractTask<Void> task = new AbstractTask<Void>(){

                    public Void call() throws OXException {
                        CachedResource preview = new CachedResource(bytes, fileName, "image/jpeg", (long)bytes.length);
                        previewCache.save(cacheKey2, preview, 0, session.getContextId());
                        return null;
                    }
                };
                ThreadPoolService threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
                if (null == threadPool) {
                    Thread thread = Thread.currentThread();
                    boolean ran = false;
                    task.beforeExecute(thread);
                    try {
                        task.call();
                        ran = true;
                        task.afterExecute(null);
                    }
                    catch (Exception ex) {
                        if (!ran) {
                            task.afterExecute((Throwable)ex);
                        }
                        throw ex instanceof OXException ? (OXException)((Object)ex) : AjaxExceptionCodes.UNEXPECTED_ERROR.create(ex, ex.getMessage());
                    }
                } else {
                    threadPool.submit((Task)task);
                }
            }
            FileHolder responseFileHolder = new FileHolder(thumbnail, (long)size, "image/jpeg", fileName);
            result.setResultObject(responseFileHolder, "file");
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void setDefaulThumbnail(AJAXRequestData requestData, AJAXRequestResult result) {
        requestData.setFormat("file");
        byte[] bytes = PreviewConst.DEFAULT_THUMBNAIL;
        ByteArrayInputStream thumbnail = Streams.newByteArrayInputStream((byte[])bytes);
        requestData.putParameter("transformationNeeded", "false");
        FileHolder responseFileHolder = new FileHolder(thumbnail, (long)bytes.length, "image/jpeg", "thumbs.jpg");
        result.setResultObject(responseFileHolder, "file");
    }

    private String getContentType(IFileHolder fileHolder, ContentTypeChecker checker) {
        String contentType = fileHolder.getContentType();
        if (Strings.isEmpty((String)contentType)) {
            return MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        if (INVALIDS.contains(contentType = this.sanitizeContentType(this.getLowerCaseBaseType(contentType))) || null != checker && !checker.isValid(contentType)) {
            contentType = MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        return contentType == null ? "application/octet-stream" : contentType;
    }

    private String sanitizeContentType(String contentType) {
        if (null == contentType) {
            return null;
        }
        try {
            return new ContentType(contentType).toString();
        }
        catch (OXException e) {
            return contentType;
        }
    }

    private String getLowerCaseBaseType(String contentType) {
        if (null == contentType) {
            return null;
        }
        int pos = contentType.indexOf(59);
        return Strings.toLowerCase((CharSequence)(pos > 0 ? contentType.substring(0, pos) : contentType)).trim();
    }
}

