/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilteredHTMLPreviewResultConverter
extends AbstractPreviewResultConverter {
    private static final String FORMAT = "preview_filtered";

    @Override
    public String getOutputFormat() {
        return FORMAT;
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.HTML;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        super.convert(requestData, result, session, converter);
        Object resultObject = result.getResultObject();
        if (!(resultObject instanceof PreviewDocument)) {
            return;
        }
        PreviewDocument previewDocument = (PreviewDocument)resultObject;
        if (resultObject instanceof SanitizedPreviewDocument) {
            return;
        }
        boolean asDiv = FilteredHTMLPreviewResultConverter.parseBool(requestData.getParameter("previewForceDiv"));
        Map metaData = previewDocument.getMetaData();
        ArrayList<String> sanitizedHtml = new ArrayList<String>();
        UserSettingMail usm = (UserSettingMail)session.getUserSettingMail().clone();
        usm.setNoSave(true);
        boolean edit = FilteredHTMLPreviewResultConverter.parseBool(requestData.getParameter("edit"));
        DisplayMode mode = FilteredHTMLPreviewResultConverter.detectDisplayMode(edit, requestData.getParameter("view"), usm);
        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
        for (String content : previewDocument.getContent()) {
            if (!DisplayMode.RAW.equals((Object)mode)) {
                content = htmlService.dropScriptTagsInHeader(content);
                if (DisplayMode.MODIFYABLE.isIncluded(mode) && usm.isDisplayHtmlInlineContent()) {
                    boolean[] modified = new boolean[1];
                    String cssPrefix = "ox-" + HtmlProcessing.getHash(Long.toString(System.currentTimeMillis()), 10);
                    boolean externalImagesAllowed = usm.isAllowHTMLImages();
                    content = htmlService.checkBaseTag(content, externalImagesAllowed);
                    if (HtmlProcessing.useSanitize()) {
                        content = externalImagesAllowed ? htmlService.sanitize(content, null, false, null, cssPrefix) : htmlService.sanitize(content, null, true, modified, cssPrefix);
                    } else {
                        String charset = (String)metaData.get("charset");
                        content = htmlService.getConformHTML(content, charset == null ? "ISO-8859-1" : charset, false);
                        content = htmlService.filterWhitelist(content);
                        if (!externalImagesAllowed) {
                            content = htmlService.filterExternalImages(content, modified);
                        }
                    }
                    MailMessage mail = (MailMessage)result.getParameter("__mail");
                    if (mail != null) {
                        MailPath mailPath = new MailPath(mail.getAccountId(), mail.getFolder(), mail.getMailId());
                        content = HtmlProcessing.filterInlineImages(content, session, mailPath);
                    }
                    content = HtmlProcessing.saneCss(content, htmlService, cssPrefix);
                    if (asDiv) {
                        content = this.toDiv(content);
                    }
                }
            }
            sanitizedHtml.add(content);
        }
        result.setResultObject(new SanitizedPreviewDocument(metaData, sanitizedHtml, previewDocument.getThumbnail(), previewDocument.isMoreAvailable()), FORMAT);
    }

    private String toDiv(String content) {
        String ret = content;
        ret = ret.replaceAll("<body[^>]*>", "<div>");
        ret = ret.substring(ret.indexOf("<div>"));
        ret = ret.replaceAll("</body[^>]*>", "</div>");
        ret = ret.substring(0, ret.lastIndexOf("</div>") + 6);
        return ret;
    }

    private static final class SanitizedPreviewDocument
    implements PreviewDocument {
        private final Map<String, String> metaData;
        private final List<String> sanitizedHtml;
        private final InputStream thumbnail;
        private final Boolean moreAvailable;

        protected SanitizedPreviewDocument(Map<String, String> metaData, List<String> sanitizedHtml, InputStream thumbnail, Boolean moreAvailable) {
            this.metaData = metaData;
            this.sanitizedHtml = sanitizedHtml;
            this.thumbnail = thumbnail;
            this.moreAvailable = moreAvailable;
        }

        public Map<String, String> getMetaData() {
            return this.metaData;
        }

        public boolean hasContent() {
            return null != this.sanitizedHtml;
        }

        public List<String> getContent() {
            return this.sanitizedHtml;
        }

        public InputStream getThumbnail() {
            return this.thumbnail;
        }

        public Boolean isMoreAvailable() {
            return this.moreAvailable;
        }
    }
}

