/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.SimpleRequest;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;

public abstract class CommonRequest {
    protected JSONWriter w;
    private final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CommonRequest.class));

    public CommonRequest(JSONWriter w) {
        this.w = w;
    }

    private static Locale localeFrom(Session session) {
        if (null == session) {
            return Locale.US;
        }
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        return UserStorage.getStorageUser(session.getUserId(), session.getContextId()).getLocale();
    }

    protected void sendErrorAsJS(String error, String ... errorParams) {
        try {
            this.w.object();
            this.w.key("error").value((Object)error);
            this.w.key("error_params").value((Object)new JSONArray(Arrays.asList(errorParams)));
            this.w.endArray();
        }
        catch (JSONException e) {
            this.LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void handle(Throwable t, Session session) {
        Response res = new Response();
        if (t instanceof OXException) {
            OXException x = (OXException)t;
            x.log(this.LOG);
            res.setException(x);
        } else {
            this.LOG.error((Object)t.getMessage(), t);
            res.setException(new OXException(t));
        }
        try {
            ResponseWriter.write(res, this.w, CommonRequest.localeFrom(session));
        }
        catch (JSONException e) {
            this.LOG.error((Object)"", t);
        }
    }

    protected void invalidParameter(String parameter, String value) {
        this.sendErrorAsJS("Invalid parameter value '%s' for parameter %s", value, parameter);
    }

    protected void unknownColumn(String columnId) {
        this.sendErrorAsJS("Unknown column id: %s", columnId);
    }

    protected boolean checkRequired(SimpleRequest req, String action, String ... parameters) {
        for (String param : parameters) {
            if (req.getParameter(param) != null) continue;
            this.missingParameter(param, action);
            return false;
        }
        return true;
    }

    protected void missingParameter(String parameter, String action) {
        this.sendErrorAsJS("Missing Parameter: %s for action: %s", parameter, action);
    }
}

