/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.CalendarParser;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.participants.AbstractConfirmableParticipant;
import com.openexchange.groupware.container.participants.ConfirmStatus;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.java.Autoboxing;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class ParticipantParser {
    private static final CalendarParser.FieldParser<JSONParticipant> TYPE_PARSER = new CalendarParser.FieldParser<JSONParticipant>(){

        @Override
        public void parse(boolean parseAll, JSONParticipant obj, TimeZone timeZone, JSONObject json) throws JSONException {
            if (json.has("type")) {
                obj.setType(json.getInt("type"));
            }
        }
    };
    private static final CalendarParser.FieldParser<JSONParticipant> MAIL_PARSER = new CalendarParser.FieldParser<JSONParticipant>(){

        @Override
        public void parse(boolean parseAll, JSONParticipant obj, TimeZone timeZone, JSONObject json) {
            if (json.has("mail")) {
                obj.setEmailAddress(json.optString("mail"));
            }
        }
    };
    private static final CalendarParser.FieldParser<JSONParticipant> DISPLAY_NAME_PARSER = new CalendarParser.FieldParser<JSONParticipant>(){

        @Override
        public void parse(boolean parseAll, JSONParticipant obj, TimeZone timeZone, JSONObject json) {
            if (json.has("display_name")) {
                obj.setDisplayName(json.optString("display_name"));
            }
        }
    };
    private static final CalendarParser.FieldParser<ConfirmableParticipant> STATUS_PARSER = new CalendarParser.FieldParser<ConfirmableParticipant>(){

        @Override
        public void parse(boolean parseAll, ConfirmableParticipant obj, TimeZone timeZone, JSONObject json) {
            if (json.has("status")) {
                obj.setStatus(ConfirmStatus.byId(json.optInt("status")));
            } else if (json.has("confirmation")) {
                obj.setStatus(ConfirmStatus.byId(json.optInt("confirmation")));
            }
        }
    };
    private static final CalendarParser.FieldParser<ConfirmableParticipant> MESSAGE_PARSER = new CalendarParser.FieldParser<ConfirmableParticipant>(){

        @Override
        public void parse(boolean parseAll, ConfirmableParticipant obj, TimeZone timeZone, JSONObject json) {
            if (json.has("confirmmessage")) {
                obj.setMessage(json.optString("confirmmessage"));
            } else if (json.has("message")) {
                obj.setMessage(json.optString("message"));
            }
        }
    };
    private static final CalendarParser.FieldParser<Participant>[] PARSERS = new CalendarParser.FieldParser[]{TYPE_PARSER, MAIL_PARSER, DISPLAY_NAME_PARSER, STATUS_PARSER, MESSAGE_PARSER};

    public ConfirmableParticipant parseConfirmation(boolean parseAll, JSONObject json) throws JSONException {
        JSONParticipant parsed = new JSONParticipant();
        this.parseField(parseAll, parsed, null, json);
        return parsed;
    }

    protected void parseField(boolean parseAll, JSONParticipant obj, TimeZone tz, JSONObject json) throws JSONException {
        for (CalendarParser.FieldParser<Participant> parser : PARSERS) {
            parser.parse(parseAll, obj, tz, json);
        }
    }

    private static final class JSONParticipant
    extends AbstractConfirmableParticipant
    implements Comparable<Participant> {
        private static final long serialVersionUID = -3063859164091177034L;
        private int type;
        private int identifier;
        private String emailAddress;
        private String displayName;
        private boolean ignoreNotification;

        JSONParticipant() {
        }

        private JSONParticipant(JSONParticipant copy) {
            super(copy);
            this.type = copy.getType();
            this.identifier = copy.getIdentifier();
            this.emailAddress = copy.getEmailAddress();
            this.displayName = copy.getDisplayName();
            this.ignoreNotification = copy.isIgnoreNotification();
        }

        @Override
        public ConfirmableParticipant getClone() {
            return new JSONParticipant(this);
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getEmailAddress() {
            return this.emailAddress == null ? null : this.emailAddress.toLowerCase();
        }

        @Override
        public int getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public boolean isIgnoreNotification() {
            return this.ignoreNotification;
        }

        @Override
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Deprecated
        public void setIdentifier(int id) {
            this.identifier = id;
        }

        @Override
        public void setIgnoreNotification(boolean ignoreNotification) {
            this.ignoreNotification = ignoreNotification;
        }

        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress == null ? null : emailAddress.toLowerCase();
        }

        public void setType(int type) {
            this.type = type;
        }

        @Override
        public JSONParticipant clone() throws CloneNotSupportedException {
            JSONParticipant retval = (JSONParticipant)super.clone();
            retval.displayName = this.displayName;
            retval.emailAddress = this.emailAddress;
            retval.identifier = this.identifier;
            retval.ignoreNotification = this.ignoreNotification;
            retval.type = this.type;
            return retval;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JSONParticipant other = (JSONParticipant)obj;
            if (this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress)) {
                return false;
            }
            return this.type == other.type;
        }

        @Override
        public int compareTo(Participant part) {
            int retval = 5 == part.getType() ? (null == this.getEmailAddress() ? (null == part.getEmailAddress() ? 0 : -1) : (null == part.getEmailAddress() ? 1 : this.getEmailAddress().compareTo(part.getEmailAddress()))) : Autoboxing.I((int)5).compareTo(Autoboxing.I((int)part.getType()));
            return retval;
        }
    }
}

