/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tokenlogin.TokenLoginSecret;
import com.openexchange.tokenlogin.TokenLoginService;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class RedeemToken
implements LoginRequestHandler {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(RedeemToken.class);
    private final LoginConfiguration conf;

    public RedeemToken(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doRedeemToken(req, resp);
        }
        catch (OXException e) {
            String errorPage = this.conf.getErrorPageTemplate().replace("ERROR_MESSAGE", e.getMessage());
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write(errorPage);
        }
    }

    private void doRedeemToken(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        Session session;
        String token = LoginTools.parseToken(req);
        String appSecret = LoginTools.parseAppSecret(req);
        if (null == token || null == appSecret) {
            resp.sendError(400);
            return;
        }
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        TokenLoginService service = ServerServiceRegistry.getInstance().getService(TokenLoginService.class);
        String client = LoginTools.parseClient(req, true, "");
        String hash = HashCalculator.getInstance().getHash(req, LoginTools.parseUserAgent(req), client);
        try {
            String authId = LoginTools.parseAuthId(req, true);
            session = service.redeemToken(token, appSecret, client, authId, hash);
        }
        catch (OXException e) {
            LoginServlet.logAndSendException(resp, e);
            return;
        }
        TokenLoginSecret tokenLoginSecret = service.getTokenLoginSecret(appSecret);
        Boolean writePassword = (Boolean)tokenLoginSecret.getParameters().get("accessPassword");
        try {
            Context context = ContextStorage.getInstance().getContext(session.getContextId());
            User user = UserStorage.getInstance().getUser(session.getUserId(), context);
            if (!context.isEnabled() || !user.isMailEnabled()) {
                LOG.info((Object)("Either context " + context.getContextId() + " or user " + user.getId() + " not enabled"));
                resp.sendError(403);
                return;
            }
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Unexpected error occurred during login: " + e.getMessage()), (Throwable)e);
            resp.sendError(403);
            return;
        }
        catch (OXException e) {
            LOG.info((Object)("Couldn't resolve context/user by identifier: " + session.getContextId() + '/' + session.getUserId()), (Throwable)e);
            resp.sendError(403);
            return;
        }
        LoginServlet.writeSecretCookie(req, resp, session, hash, req.isSecure(), req.getServerName(), this.conf);
        try {
            JSONObject json = new JSONObject(12);
            LoginWriter.write(session, json);
            if (null != writePassword && writePassword.booleanValue()) {
                String password = session.getPassword();
                json.put("password", null == password ? JSONObject.NULL : password);
            }
            json.write((Writer)resp.getWriter());
        }
        catch (JSONException e) {
            LOG.info((Object)e.getMessage(), (Throwable)e);
            resp.sendError(500);
        }
    }
}

