/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.authentication.Cookie;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.login.Interface;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public final class LoginTools {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(LoginTools.class);
    private static final Pattern PATTERN_CRLF = Pattern.compile("\r?\n|(?:%0[aA])?%0[dD]");
    private static final Pattern PATTERN_DSLASH = Pattern.compile("(?:/|%2[fF]){2}");

    private LoginTools() {
    }

    public static String encodeUrl(String s, boolean forAnchor) {
        return AJAXServlet.encodeUrl(s, forAnchor);
    }

    public static String generateRedirectURL(String uiWebPathParam, String shouldStore, String sessionId, String uiWebPath) {
        String retval = uiWebPathParam;
        if (null == retval) {
            retval = uiWebPath;
        }
        retval = PATTERN_CRLF.matcher(retval).replaceAll("");
        retval = PATTERN_DSLASH.matcher(retval).replaceAll("/");
        retval = LoginTools.addFragmentParameter(retval, "session", sessionId);
        if (shouldStore != null) {
            retval = LoginTools.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }

    public static String addFragmentParameter(String usedUIWebPath, String param, String value) {
        String retval = usedUIWebPath;
        int fragIndex = retval.indexOf(35);
        int questionMarkIndex = retval.indexOf(63, fragIndex);
        String query = "";
        if (questionMarkIndex > 0) {
            query = retval.substring(questionMarkIndex);
            retval = retval.substring(0, questionMarkIndex);
        }
        if (retval.indexOf(35) < 0) {
            return retval + '#' + param + '=' + value + query;
        }
        return retval + '&' + param + '=' + value + query;
    }

    public static String parseAuthId(HttpServletRequest req, boolean strict) throws OXException {
        return LoginTools.parseParameter(req, "authId", strict, UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
    }

    public static String parseClient(HttpServletRequest req, boolean strict, String defaultClient) throws OXException {
        return LoginTools.parseParameter(req, "client", strict, defaultClient);
    }

    public static String parseToken(HttpServletRequest req) throws OXException {
        return LoginTools.parseParameter(req, "token");
    }

    public static String parseAppSecret(HttpServletRequest req) throws OXException {
        return LoginTools.parseParameter(req, "secret");
    }

    public static String parseParameter(HttpServletRequest req, String paramName, boolean strict, String fallback) throws OXException {
        String value = req.getParameter(paramName);
        if (null == value) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(paramName);
            }
            return fallback;
        }
        return value;
    }

    public static String parseParameter(HttpServletRequest req, String paramName, String fallback) {
        String value = req.getParameter(paramName);
        if (null == value) {
            return fallback;
        }
        return value;
    }

    public static String parseParameter(HttpServletRequest req, String paramName) throws OXException {
        String value = req.getParameter(paramName);
        if (null == value) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(paramName);
        }
        return value;
    }

    public static String parseClientIP(HttpServletRequest req) {
        return LoginTools.parseParameter(req, "clientIP", req.getRemoteAddr());
    }

    public static String parseUserAgent(HttpServletRequest req) {
        return LoginTools.parseParameter(req, "clientUserAgent", req.getHeader("user-agent"));
    }

    public static LoginRequestImpl parseLogin(HttpServletRequest req, String login, String password, boolean strict, String defaultClient, boolean forceHTTPS, boolean requiredAuthId) throws OXException {
        String version2;
        String authId = LoginTools.parseAuthId(req, requiredAuthId);
        String client = LoginTools.parseClient(req, strict, defaultClient);
        if (null == req.getParameter("version")) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("version");
            }
            version2 = null;
        } else {
            version2 = req.getParameter("version");
        }
        String clientIP = LoginTools.parseClientIP(req);
        String userAgent = LoginTools.parseUserAgent(req);
        Map<String, List<String>> headers = Tools.copyHeaders(req);
        Cookie[] cookies = Tools.getCookieFromHeader(req);
        String httpSessionId = req.getSession(true).getId();
        Props props = LogProperties.getLogProperties();
        props.put(LogProperties.Name.LOGIN_LOGIN, (Object)ForceLog.valueOf((Object)Strings.abbreviate((String)login, (int)256)));
        props.put(LogProperties.Name.LOGIN_CLIENT_IP, (Object)ForceLog.valueOf((Object)clientIP));
        props.put(LogProperties.Name.LOGIN_USER_AGENT, (Object)ForceLog.valueOf((Object)userAgent));
        props.put(LogProperties.Name.LOGIN_AUTH_ID, (Object)ForceLog.valueOf((Object)authId));
        props.put(LogProperties.Name.LOGIN_CLIENT, (Object)ForceLog.valueOf((Object)client));
        props.put(LogProperties.Name.LOGIN_VERSION, (Object)ForceLog.valueOf((Object)version2));
        return new LoginRequestImpl(login, password, clientIP, userAgent, authId, client, version2, HashCalculator.getInstance().getHash(req, userAgent, client), Interface.HTTP_JSON, headers, cookies, Tools.considerSecure(req, forceHTTPS), req.getServerName(), req.getServerPort(), httpSessionId);
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    public static LoginRequestImpl parseLogin(HttpServletRequest req, String loginParamName, boolean strict, String defaultClient, boolean forceHTTPS, boolean disableTrimLogin, boolean requiredAuthId) throws OXException {
        String password;
        String login = req.getParameter(loginParamName);
        if (null == login) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(loginParamName);
        }
        if (!disableTrimLogin) {
            login = login.trim();
        }
        if (null == (password = req.getParameter("password"))) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
        return LoginTools.parseLogin(req, login, password, strict, defaultClient, forceHTTPS, requiredAuthId);
    }

    public static void updateIPAddress(LoginConfiguration conf, String newIP, Session session) {
        if (conf.isInsecure()) {
            String oldIP = session.getLocalIp();
            if (null != newIP && !newIP.equals(oldIP)) {
                LOG.info((Object)("Updating sessions IP address. authID: " + session.getAuthId() + ", sessionID: " + session.getSessionID() + ", old ip: " + oldIP + ", new ip: " + newIP));
                session.setLocalIp(newIP);
            }
        }
    }
}

