/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.HashUtility;
import com.openexchange.tools.encoding.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HashCalculator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(HashCalculator.class));
    private static final String USER_AGENT = "clientUserAgent";
    private static final String CLIENT_PARAM = "client";
    private static final Pattern PATTERN_NON_WORD_CHAR = Pattern.compile("\\W");
    private static final HashCalculator SINGLETON = new HashCalculator();
    private volatile String[] fields = new String[0];
    private volatile String salt = "";

    public static HashCalculator getInstance() {
        return SINGLETON;
    }

    private HashCalculator() {
    }

    public void configure(ConfigurationService service) {
        if (null != service) {
            String fieldList = service.getProperty("com.openexchange.cookie.hash.fields", "");
            this.fields = Pattern.compile("\\s*,\\s*").split(fieldList, 0);
            this.salt = service.getProperty("com.openexchange.cookie.hash.salt", "replaceMe1234567890");
        }
    }

    public String getHash(HttpServletRequest req, String client) {
        return this.getHash(req, HashCalculator.getUserAgent(req), client);
    }

    public String getHash(HttpServletRequest req, String userAgent, String client) {
        try {
            String salt;
            String[] fields;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((null == userAgent ? HashCalculator.parseClientUserAgent(req, "") : userAgent).getBytes(Charsets.UTF_8));
            if (null != client) {
                md.update(client.getBytes(Charsets.UTF_8));
            }
            if (null != (fields = this.fields)) {
                for (String field : fields) {
                    String header = req.getHeader(field);
                    if (Strings.isEmpty((String)header)) continue;
                    md.update(header.getBytes(Charsets.UTF_8));
                }
            }
            if (null != (salt = this.salt)) {
                md.update(salt.getBytes());
            }
            return PATTERN_NON_WORD_CHAR.matcher(Base64.encode(md.digest())).replaceAll("");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.fatal((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getHash(HttpServletRequest req) {
        return this.getHash(req, HashCalculator.getClient(req));
    }

    public static String getClient(HttpServletRequest req) {
        String parameter = req.getParameter(CLIENT_PARAM);
        return Strings.isEmpty((String)parameter) ? "default" : parameter;
    }

    public String getUserAgentHash(HttpServletRequest req) {
        return this.getUserAgentHash(req, null);
    }

    public String getUserAgentHash(HttpServletRequest req, String userAgent) {
        String sha256 = HashUtility.getSha256(null == userAgent ? HashCalculator.getUserAgent(req) : userAgent, "hex");
        return null == sha256 ? "" : sha256;
    }

    private static String parseClientUserAgent(HttpServletRequest req, String defaultValue) {
        String parameter = req.getParameter(USER_AGENT);
        return Strings.isEmpty((String)parameter) ? defaultValue : parameter;
    }

    private static String getUserAgent(HttpServletRequest req) {
        String header = req.getHeader("user-agent");
        if (header == null) {
            return "";
        }
        return header;
    }
}

