/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.ConfigMenu;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.Multiple;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.login.LoginClosure;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResultCode;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.login.LoginResult;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractLoginRequestHandler
implements LoginRequestHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractLoginRequestHandler.class));

    public boolean loginOperation(HttpServletRequest req, HttpServletResponse resp, LoginClosure login, LoginConfiguration conf) throws IOException, OXException {
        Session session;
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        LoginResult result = null;
        try {
            result = login.doLogin(req);
            if (null == result) {
                return true;
            }
            session = result.getSession();
            LogProperties.putSessionProperties((Session)session);
            Future<Object> optModules = this.getModulesAsync(session, req);
            LoginServlet.addHeadersAndCookies(result, resp);
            ResultCode code = result.getCode();
            if (null != code) {
                switch (code) {
                    case FAILED: {
                        return true;
                    }
                    case REDIRECT: {
                        throw LoginExceptionCodes.REDIRECT.create(new Object[]{result.getRedirect()});
                    }
                }
            }
            session.setParameter("user-agent", (Object)req.getHeader("user-agent"));
            JSONObject json = new JSONObject(8);
            LoginWriter.write(result, json);
            String multipleRequest = req.getParameter("multiple");
            if (multipleRequest != null) {
                JSONArray dataArray = new JSONArray(multipleRequest);
                if (dataArray.length() > 0) {
                    JSONArray responses = Multiple.perform(dataArray, req, ServerSessionAdapter.valueOf(session));
                    json.put("multiple", (Object)responses);
                } else {
                    json.put("multiple", (Object)new JSONArray(0));
                }
            }
            if (null != optModules) {
                try {
                    Object oModules = optModules.get();
                    if (null != oModules) {
                        json.put("modules", oModules);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + cause.getMessage()), cause);
                }
            }
            response.setData(json);
        }
        catch (OXException e) {
            if ("SVL".equals(e.getPrefix())) {
                throw e;
            }
            if (LoginExceptionCodes.NOT_SUPPORTED.equals(e)) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
            }
            if (LoginExceptionCodes.REDIRECT.equals(e)) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        try {
            if (response.hasError() || null == result) {
                Locale loc;
                String sLocale = req.getParameter("language");
                Locale locale = null == sLocale ? this.bestGuessLocale(result, req) : (null == (loc = LocaleTools.getLocale((String)sLocale)) ? this.bestGuessLocale(result, req) : loc);
                ResponseWriter.write(response, resp.getWriter(), locale);
                return false;
            }
            session = result.getSession();
            SessionServlet.rememberSession(req, new ServerSessionAdapter(session, result.getContext(), result.getUser()));
            LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), conf);
            if (req.getParameter("callback") != null && "login".equals(req.getParameter("action"))) {
                APIResponseRenderer.writeResponse(response, "login", req, resp);
            } else {
                ((JSONObject)response.getData()).write((Writer)resp.getWriter());
            }
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error((Object)"Error while writing response object.", (Throwable)e);
            LoginServlet.sendError(resp);
            return false;
        }
        return false;
    }

    private Locale bestGuessLocale(LoginResult result, HttpServletRequest req) {
        User user;
        Locale locale = null == result ? Tools.getLocaleByAcceptLanguage(req, null) : (null == (user = result.getUser()) ? Tools.getLocaleByAcceptLanguage(req, null) : user.getLocale());
        return locale;
    }

    public Future<Object> getModulesAsync(final Session session, HttpServletRequest req) {
        String modules = "modules";
        if (!LoginServlet.parseBoolean(req.getParameter("modules"))) {
            return null;
        }
        return ThreadPools.getThreadPool().submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    Setting setting = ConfigTree.getInstance().getSettingByPath("modules");
                    SettingStorage.getInstance(session).readValues(setting);
                    return ConfigMenu.convert2JS(setting);
                }
                catch (OXException e) {
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
                }
                catch (JSONException e) {
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
                }
                return null;
            }
        });
    }
}

