/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.ImageTypeDetector;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.encoding.URLCoder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public final class DownloadUtility {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DownloadUtility.class));
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final Pattern PAT_BSLASH = Pattern.compile("\\\\");
    private static final Pattern PAT_QUOTE = Pattern.compile("\"");
    private static final String DEFAULT_FILENAME = "file.dat";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String MIME_TEXT_HTML = "text/htm";

    private DownloadUtility() {
    }

    public static CheckedDownload checkInlineDownload(InputStream inputStream, String fileName, String contentTypeStr, String userAgent) throws OXException {
        return DownloadUtility.checkInlineDownload(inputStream, fileName, contentTypeStr, null, userAgent);
    }

    public static CheckedDownload checkInlineDownload(InputStream inputStream, String fileName, String sContentType, String overridingDisposition, String userAgent) throws OXException {
        return DownloadUtility.checkInlineDownload(inputStream, -1L, fileName, sContentType, overridingDisposition, userAgent);
    }

    public static CheckedDownload checkInlineDownload(InputStream inputStream, long sizer, String fileName, String sContentType, String overridingDisposition, String userAgent) throws OXException {
        try {
            CheckedDownload retval;
            byte[] bytes;
            HtmlService htmlService;
            ByteArrayOutputStream baos;
            ContentType contentType = new ContentType(sContentType);
            if (null != fileName && contentType.startsWith(MIME_APPL_OCTET)) {
                String ct = MimeType2ExtMap.getContentType(fileName);
                int pos = ct.indexOf(47);
                contentType.setPrimaryType(ct.substring(0, pos));
                contentType.setSubType(ct.substring(pos + 1));
            }
            String sContentDisposition = overridingDisposition;
            long sz = sizer;
            InputStream in = inputStream;
            String fn = fileName;
            if (contentType.startsWithAny(MIME_TEXT_HTML, "text/xhtm")) {
                if (null == sContentDisposition) {
                    sContentDisposition = "attachment";
                } else if (DownloadUtility.toLowerCase(sContentDisposition).startsWith("inline")) {
                    baos = Streams.stream2ByteArrayOutputStream((InputStream)in);
                    HtmlService htmlService2 = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    String cs = contentType.getCharsetParameter();
                    if (!CharsetDetector.isValid((String)cs) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.asInputStream((ByteArrayOutputStream)baos)))) {
                        cs = "ISO-8859-1";
                    }
                    String htmlContent = baos.toString(cs);
                    htmlContent = htmlService2.sanitize(htmlContent, null, true, null, null);
                    byte[] tmp = htmlContent.getBytes(Charsets.forName((String)cs));
                    sz = tmp.length;
                    in = Streams.newByteArrayInputStream((byte[])tmp);
                }
            } else if (contentType.startsWith("text/xml")) {
                if (null == sContentDisposition) {
                    sContentDisposition = "attachment";
                } else if (DownloadUtility.toLowerCase(sContentDisposition).startsWith("inline")) {
                    htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    ByteArrayOutputStream baos2 = Streams.stream2ByteArrayOutputStream((InputStream)in);
                    String cs = contentType.getCharsetParameter();
                    if (!CharsetDetector.isValid((String)cs)) {
                        cs = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.asInputStream((ByteArrayOutputStream)baos2));
                        if ("US-ASCII".equalsIgnoreCase(cs)) {
                            cs = "ISO-8859-1";
                        }
                        contentType.setCharsetParameter(cs);
                    }
                    String xmlContent = baos2.toString(cs);
                    xmlContent = htmlService.htmlFormat(xmlContent);
                    contentType.setPrimaryType("text").setSubType("html");
                    byte[] tmp = xmlContent.getBytes(Charsets.forName((String)cs));
                    sz = tmp.length;
                    in = Streams.newByteArrayInputStream((byte[])tmp);
                }
            } else if (contentType.startsWith(MIME_TEXT_PLAIN)) {
                byte[] tmp;
                String cs;
                if (null == contentType.getCharsetParameter()) {
                    baos = Streams.stream2ByteArrayOutputStream((InputStream)in);
                    cs = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.asInputStream((ByteArrayOutputStream)baos));
                    if ("US-ASCII".equalsIgnoreCase(cs)) {
                        cs = "ISO-8859-1";
                    }
                    contentType.setCharsetParameter(cs);
                    String textContent = baos.toString(cs);
                    tmp = textContent.getBytes(Charsets.forName((String)cs));
                    sz = tmp.length;
                    in = Streams.newByteArrayInputStream((byte[])tmp);
                }
                if (null == sContentDisposition) {
                    sContentDisposition = "attachment";
                } else if (DownloadUtility.toLowerCase(sContentDisposition).startsWith("inline")) {
                    baos = Streams.stream2ByteArrayOutputStream((InputStream)in);
                    cs = contentType.getCharsetParameter();
                    if (!CharsetDetector.isValid((String)cs) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.asInputStream((ByteArrayOutputStream)baos)))) {
                        cs = "ISO-8859-1";
                    }
                    String content = MessageUtility.readStream(Streams.asInputStream((ByteArrayOutputStream)baos), cs);
                    tmp = content.getBytes(Charsets.UTF_8);
                    contentType.setCharsetParameter("UTF-8");
                    sz = tmp.length;
                    in = Streams.newByteArrayInputStream((byte[])tmp);
                }
            } else if (contentType.startsWith("image/") || DownloadUtility.fileNameImpliesImage(fileName)) {
                BrowserDetector browserDetector = new BrowserDetector(userAgent);
                boolean msieOnWindows = browserDetector.isMSIE() && browserDetector.isWindows();
                ThresholdFileHolder tmp = new ThresholdFileHolder();
                tmp.write(in);
                String preparedFileName = DownloadUtility.getSaveAsFileName(fileName, msieOnWindows, sContentType);
                String fileExtension = DownloadUtility.getFileExtension(fn);
                if (Strings.isEmpty((String)fileExtension)) {
                    if (HTMLDetector.containsHTMLTags((byte[])tmp.toByteArray())) {
                        return DownloadUtility.asAttachment(tmp.getClosingStream(), preparedFileName, tmp.getLength());
                    }
                } else {
                    HashSet<String> extensions;
                    if ('.' == fileExtension.charAt(0)) {
                        fileExtension = fileExtension.substring(1);
                    }
                    if ((extensions = new HashSet<String>(MimeType2ExtMap.getFileExtensions(contentType.getBaseType()))).isEmpty() || extensions.size() == 1 && extensions.contains("dat")) {
                        String ct = MimeType2ExtMap.getContentType(fn);
                        if (MIME_APPL_OCTET.equals(ct)) {
                            if (HTMLDetector.containsHTMLTags((byte[])tmp.toByteArray())) {
                                return DownloadUtility.asAttachment(tmp.getClosingStream(), preparedFileName, tmp.getLength());
                            }
                        } else {
                            int pos = ct.indexOf(47);
                            contentType.setPrimaryType(ct.substring(0, pos));
                            contentType.setSubType(ct.substring(pos + 1));
                        }
                    } else if (!extensions.contains(fileExtension)) {
                        fn = DownloadUtility.addFileExtension(fileExtension, (String)extensions.iterator().next());
                        preparedFileName = DownloadUtility.getSaveAsFileName(fn, msieOnWindows, contentType.getBaseType());
                    }
                    String detectedCT = ImageTypeDetector.getMimeType(tmp.toByteArray());
                    if (MIME_APPL_OCTET.equals(detectedCT)) {
                        if (HTMLDetector.containsHTMLTags((byte[])tmp.toByteArray())) {
                            return DownloadUtility.asAttachment(tmp.getClosingStream(), preparedFileName, tmp.getLength());
                        }
                    } else if (!contentType.isMimeType(detectedCT)) {
                        contentType.setBaseType(detectedCT);
                    }
                }
                in = tmp.getClosingStream();
            } else if (DownloadUtility.fileNameImpliesHtml(fileName) && HTMLDetector.containsHTMLTags((byte[])(bytes = Streams.stream2bytes((InputStream)in)), (boolean)true)) {
                if (null == sContentDisposition) {
                    sContentDisposition = "attachment";
                } else if (DownloadUtility.toLowerCase(sContentDisposition).startsWith("inline")) {
                    htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    String cs = contentType.getCharsetParameter();
                    if (!CharsetDetector.isValid((String)cs) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.newByteArrayInputStream((byte[])bytes)))) {
                        cs = "ISO-8859-1";
                    }
                    String htmlContent = new String(bytes, Charsets.forName((String)cs));
                    htmlContent = htmlService.sanitize(htmlContent, null, true, null, null);
                    byte[] tmp = htmlContent.getBytes(Charsets.forName((String)cs));
                    sz = tmp.length;
                    in = Streams.newByteArrayInputStream((byte[])tmp);
                }
            }
            if (sContentDisposition == null) {
                StringAllocator builder = new StringAllocator(32).append("inline");
                DownloadUtility.appendFilenameParameter(fileName, contentType.isBaseType("application", "octet-stream") ? null : contentType.toString(), userAgent, builder);
                contentType.removeParameter("name");
                retval = new CheckedDownload(contentType.toString(), builder.toString(), in, sz);
            } else if (sContentDisposition.indexOf(59) < 0) {
                StringAllocator builder = new StringAllocator(32).append(sContentDisposition);
                DownloadUtility.appendFilenameParameter(fileName, contentType.isBaseType("application", "octet-stream") ? null : contentType.toString(), userAgent, builder);
                contentType.removeParameter("name");
                retval = new CheckedDownload(contentType.toString(), builder.toString(), in, sz);
            } else {
                contentType.removeParameter("name");
                retval = new CheckedDownload(contentType.toString(), sContentDisposition, in, sz);
            }
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static boolean fileNameImpliesHtml(String fileName) {
        return null != fileName && MimeType2ExtMap.getContentType(fileName).startsWith(MIME_TEXT_HTML);
    }

    private static boolean fileNameImpliesImage(String fileName) {
        return null != fileName && MimeType2ExtMap.getContentType(fileName).startsWith("image/");
    }

    public static void appendFilenameParameter(String fileName, String userAgent, StringBuilder appendTo) {
        DownloadUtility.appendFilenameParameter(fileName, null, userAgent, appendTo);
    }

    public static void appendFilenameParameter(String fileName, String baseCT, String userAgent, StringBuilder appendTo) {
        boolean isAndroid;
        if (null == fileName) {
            appendTo.append("; filename=\"").append(DEFAULT_FILENAME).append('\"');
            return;
        }
        String fn = fileName;
        if (null != baseCT && null == DownloadUtility.getFileExtension(fn)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                fn = fn + ".txt";
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                fn = fn + ".html";
            }
        }
        fn = DownloadUtility.escapeBackslashAndQuote(fn);
        if (null != userAgent && new BrowserDetector(userAgent).isMSIE()) {
            appendTo.append("; filename=\"").append(Helper.encodeFilenameForIE(fn, Charsets.UTF_8)).append('\"');
            return;
        }
        String foo = new String(fn.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
        boolean bl = isAndroid = null != userAgent && DownloadUtility.toLowerCase(userAgent).indexOf("android") >= 0;
        if (isAndroid) {
            int pos = foo.lastIndexOf(46);
            if (pos >= 0) {
                foo = foo.substring(0, pos) + DownloadUtility.toUpperCase(foo.substring(pos));
            }
        } else {
            appendTo.append("; filename*=UTF-8''").append(URLCoder.encode(fn));
        }
        appendTo.append("; filename=\"").append(foo).append('\"');
    }

    public static void appendFilenameParameter(String fileName, String userAgent, StringAllocator appendTo) {
        DownloadUtility.appendFilenameParameter(fileName, null, userAgent, appendTo);
    }

    public static void appendFilenameParameter(String fileName, String baseCT, String userAgent, StringAllocator appendTo) {
        boolean isAndroid;
        if (null == fileName) {
            appendTo.append("; filename=\"").append(DEFAULT_FILENAME).append('\"');
            return;
        }
        String fn = fileName;
        if (null != baseCT && null == DownloadUtility.getFileExtension(fn)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length())) {
                fn = fn + ".txt";
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length())) {
                fn = fn + ".html";
            }
        }
        fn = DownloadUtility.escapeBackslashAndQuote(fn);
        if (null != userAgent && new BrowserDetector(userAgent).isMSIE()) {
            appendTo.append("; filename=\"").append(Helper.encodeFilenameForIE(fn, Charsets.UTF_8)).append('\"');
            return;
        }
        String foo = new String(fn.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
        boolean bl = isAndroid = null != userAgent && DownloadUtility.toLowerCase(userAgent).indexOf("android") >= 0;
        if (isAndroid) {
            int pos = foo.lastIndexOf(46);
            if (pos >= 0) {
                foo = foo.substring(0, pos).replaceAll("\\s+", "_") + DownloadUtility.toUpperCase(foo.substring(pos));
            }
        } else {
            appendTo.append("; filename*=UTF-8''").append(URLCoder.encode(fn));
        }
        appendTo.append("; filename=\"").append(foo).append('\"');
    }

    private static String escapeBackslashAndQuote(String str) {
        return PAT_QUOTE.matcher(PAT_BSLASH.matcher(str).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"");
    }

    private static CheckedDownload asAttachment(InputStream inputStream, String preparedFileName, long size) {
        return new CheckedDownload(MIME_APPL_OCTET, new StringBuilder(64).append("attachment; filename=\"").append(preparedFileName).append('\"').toString(), inputStream, size);
    }

    private static String getFileExtension(String fileName) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos <= 0 || pos >= fileName.length()) {
            return null;
        }
        return fileName.substring(pos);
    }

    private static String addFileExtension(String fileName, String ext) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.indexOf(46);
        if (-1 == pos) {
            return new StringAllocator(fileName).append('.').append(ext).toString();
        }
        return new StringAllocator(fileName.substring(0, pos)).append('.').append(ext).toString();
    }

    public static final String getSaveAsFileName(String fileName, boolean internetExplorer, String baseCT) {
        if (null == fileName) {
            return DEFAULT_FILENAME;
        }
        StringBuilder tmp = new StringBuilder(32);
        try {
            if (fileName.indexOf(32) >= 0) {
                tmp.append(Helper.encodeFilename(fileName.replaceAll(" ", "_"), "UTF-8", internetExplorer));
            } else {
                tmp.append(Helper.encodeFilename(fileName, "UTF-8", internetExplorer));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return fileName;
        }
        if (null != baseCT && null == DownloadUtility.getFileExtension(fileName)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                tmp.append(".txt");
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                tmp.append(".html");
            }
        }
        return tmp.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    public static final class CheckedDownload {
        private final String contentType;
        private final String contentDisposition;
        private final InputStream inputStream;
        private final long size;

        CheckedDownload(String contentType, String contentDisposition, InputStream inputStream, long size) {
            this.contentType = contentType;
            this.contentDisposition = contentDisposition;
            this.inputStream = inputStream;
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public boolean isAttachment() {
            return null != this.contentDisposition && Strings.toLowerCase((CharSequence)this.contentDisposition).startsWith("attachment");
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

