/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;

public abstract class PermissionServlet
extends SessionServlet {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(PermissionServlet.class));
    private static final long serialVersionUID = -1496492688713194989L;

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Tools.disableCaching(resp);
        ServerSession session = null;
        try {
            this.initializeSession(req, resp);
            session = PermissionServlet.getSessionObject((ServletRequest)req);
            if (null != session && !this.hasModulePermission(session)) {
                LOG.info((Object)"Status code 403 (FORBIDDEN): No permission to access module.");
                resp.sendError(403, "No Permission");
                return;
            }
            super.service(req, resp);
        }
        catch (OXException e) {
            if (SessionExceptionCodes.getErrorPrefix().equals(e.getPrefix())) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.handleSessiondException(e, req, resp);
                Response response = new Response();
                response.setException(e);
                resp.setContentType("text/javascript; charset=UTF-8");
                PrintWriter writer = resp.getWriter();
                try {
                    ResponseWriter.write(response, writer, PermissionServlet.localeFrom(session));
                    writer.flush();
                }
                catch (JSONException e1) {
                    this.log("Error while writing response object.", e1);
                    PermissionServlet.sendError(resp);
                }
            }
            e.log(LOG);
            Response response = new Response(PermissionServlet.getSessionObject((ServletRequest)req));
            response.setException(e);
            resp.setContentType("text/javascript; charset=UTF-8");
            PrintWriter writer = resp.getWriter();
            try {
                ResponseWriter.write(response, writer, PermissionServlet.localeFrom(session));
                writer.flush();
            }
            catch (JSONException e1) {
                this.log("Error while writing response object.", e1);
                PermissionServlet.sendError(resp);
            }
        }
    }

    protected abstract boolean hasModulePermission(ServerSession var1);
}

