/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum PublicationErrorMessage implements OXExceptionCode
{
    SQLException(CATEGORY_ERROR, 1, "A SQL error occurred."),
    ParseException(CATEGORY_ERROR, 2, "A parsing error occurred: %1$s."),
    NoLoaderFound(CATEGORY_ERROR, 3, "Could not load publications of type %1$s"),
    IDGiven(CATEGORY_ERROR, 4, "Unable to save a given ID."),
    PublicationNotFound(CATEGORY_USER_INPUT, 5, "Cannot find the publication site."),
    UniquenessConstraintViolation(CATEGORY_USER_INPUT, 6, "%1$s has already been taken (field: %2$s)"),
    AccessDenied(CATEGORY_PERMISSION_DENIED, 7, "You do not have the permissions to perform the chosen action (%s)"),
    NotExist(CATEGORY_PERMISSION_DENIED, 8, "The published document has been deleted in the meantime and therefore is no longer available.");

    private Category category;
    private int errorCode;
    private String message;

    private PublicationErrorMessage(Category category, int errorCode, String message) {
        this.category = category;
        this.errorCode = errorCode;
        this.message = message;
    }

    public String getPrefix() {
        return "PUB";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

