/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Strings {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern P_SPLIT_COMMA = Pattern.compile("\\s*,\\s*");
    private static final Pattern P_SPLIT_CRLF = Pattern.compile("\r?\n");
    private static final Pattern P_SPLIT_WHITESPACE = Pattern.compile("\\s+");
    private static final CharsetDecoder UTF8_CHARSET_DECODER;

    private Strings() {
    }

    public static String concat(Object ... objects) {
        if (null == objects || 0 == objects.length) {
            return "";
        }
        StringAllocator sb = new StringAllocator(2048);
        for (Object object : objects) {
            sb.append(String.valueOf(object));
        }
        return sb.toString();
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u000e': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static byte[] toAsciiBytes(CharSequence cs) {
        return Charsets.toAsciiBytes(cs);
    }

    public static byte[] toAsciiBytes(String str) {
        return Charsets.toAsciiBytes(str);
    }

    public static void writeAsciiBytes(String str, OutputStream out) throws IOException {
        Charsets.writeAsciiBytes(str, out);
    }

    public static String[] splitByComma(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_COMMA.split(s, 0);
    }

    public static String[] splitByCRLF(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_CRLF.split(s, 0);
    }

    public static String[] splitByWhitespaces(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_WHITESPACE.split(s, 0);
    }

    public static String replaceWhitespacesWith(String s, String replacement) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_WHITESPACE.matcher(s).replaceAll(null == replacement ? "" : Strings.quoteReplacement(replacement));
    }

    public static String quoteReplacement(String s) {
        if (Strings.isEmpty(s) || s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        int length = s.length();
        StringAllocator sb = new StringAllocator(length << 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public static String fixCharsetProblem(String s) {
        if (Strings.isEmpty(s)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes(Charsets.ISO_8859_1);
            if (Strings.isUTF8Bytes(bytes)) {
                return new String(bytes, Charsets.UTF_8);
            }
            return s;
        }
        catch (UnsupportedCharsetException e) {
            return s;
        }
    }

    public static boolean isUTF8Bytes(byte[] bytes) {
        try {
            UTF8_CHARSET_DECODER.decode(ByteBuffer.wrap(bytes));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static String join(Collection<? extends Object> coll, String connector) {
        if (coll == null) {
            return null;
        }
        if (coll.size() == 0) {
            return "";
        }
        StringAllocator builder = new StringAllocator();
        for (Object object : coll) {
            if (object == null) {
                builder.append("null");
            } else {
                builder.append(object.toString());
            }
            builder.append(connector);
        }
        return builder.substring(0, builder.length() - connector.length());
    }

    public static <T> String join(T[] arr, String connector) {
        return Strings.join(Arrays.asList(arr), connector);
    }

    public static String join(int[] arr, String connector) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i : arr) {
            list.add(Autoboxing.I(i));
        }
        return Strings.join(list, connector);
    }

    public static String join(byte[] arr, String connector) {
        LinkedList<Byte> list = new LinkedList<Byte>();
        byte[] arr$ = arr;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte i = arr$[i$];
            list.add(i);
        }
        return Strings.join(list, connector);
    }

    public static String trimBOM(String str) {
        byte[][] byteOrderMarks = new byte[][]{{0, 0, -2, -1}, {-1, -2, 0, 0}, {-17, -69, -65}, {-2, -1}, {-2, -1}};
        byte[] bytes = str.getBytes();
        for (byte[] bom : byteOrderMarks) {
            String pattern;
            if (bom.length > bytes.length || !str.startsWith(pattern = new String(bom))) continue;
            int bomLen = new String(bom).getBytes().length;
            int len = bytes.length - bomLen;
            byte[] trimmed = new byte[len];
            for (int i = 0; i < len; ++i) {
                trimmed[i] = bytes[i + bomLen];
            }
            return new String(trimmed);
        }
        return str;
    }

    public static String abbreviate(String str, int maxWidth) {
        return Strings.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        int off = offset;
        if (off > str.length()) {
            off = str.length();
        }
        if (str.length() - off < maxWidth - 3) {
            off = str.length() - (maxWidth - 3);
        }
        if (off <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (off + (maxWidth - 3) < str.length()) {
            return "..." + Strings.abbreviate(str.substring(off), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String unquote(String s) {
        if (!Strings.isEmpty(s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String unparenthize(String s) {
        if (!Strings.isEmpty(s) && s.startsWith("(") && s.endsWith(")")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String toCodePoints(String str) {
        if (null == str) {
            return null;
        }
        int length = str.length();
        StringAllocator sb = new StringAllocator(length << 1);
        for (int i = 0; i < length; ++i) {
            sb.append(' ').append(str.codePointAt(i));
        }
        return sb.deleteCharAt(0).toString();
    }

    public static void outCodePoints(String str, PrintStream out) {
        if (null == out) {
            System.out.println(Strings.toCodePoints(str));
        } else {
            out.println(Strings.toCodePoints(str));
        }
    }

    public static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    public static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    public static List<String> splitAndTrim(String input, String separator) {
        if (input == null) {
            throw new IllegalArgumentException("Missing input");
        }
        if (Strings.isEmpty(input)) {
            return Collections.emptyList();
        }
        if (Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("Missing separator");
        }
        ArrayList<String> trimmedSplits = new ArrayList<String>();
        try {
            String[] splits;
            for (String string : splits = input.split(separator)) {
                trimmedSplits.add(string.trim());
            }
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Illegal pattern syntax");
        }
        return trimmedSplits;
    }

    static {
        CharsetDecoder utf8Decoder = Charsets.UTF_8.newDecoder();
        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
        utf8Decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        UTF8_CHARSET_DECODER = utf8Decoder;
    }
}

