/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Streams;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.universalchardet.UniversalDetector;

public final class CharsetDetector {
    private static final Log LOG = LogFactory.getLog(CharsetDetector.class);
    private static final String FALLBACK = "ISO-8859-1";

    private CharsetDetector() {
    }

    public static String getFallback() {
        return FALLBACK;
    }

    public static boolean isValid(String charset) {
        try {
            return null != charset && CharsetDetector.checkName(charset) && Charset.isSupported(charset);
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)("RuntimeException while checking charset: " + charset), (Throwable)rte);
            return false;
        }
        catch (Error e) {
            CharsetDetector.handleThrowable(e);
            LOG.warn((Object)("Error while checking charset: " + charset), (Throwable)e);
            return false;
        }
        catch (Throwable t) {
            CharsetDetector.handleThrowable(t);
            LOG.warn((Object)("Unexpected error while checking charset: " + charset), t);
            return false;
        }
    }

    private static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            LOG.fatal((Object)" ---=== /!\\ ===--- Thread death ---=== /!\\ ===--- ", t);
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            LOG.fatal((Object)" ---=== /!\\ ===--- The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating. ---=== /!\\ ===--- ", t);
            throw (VirtualMachineError)t;
        }
    }

    public static boolean checkName(String s) {
        if (s == null) {
            throw new NullPointerException("name is null");
        }
        int n = s.length();
        if (n == 0) {
            return false;
        }
        boolean legal = true;
        for (int i = 0; legal && i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == ':' || c == '_' || c == '.') continue;
            legal = false;
        }
        return legal;
    }

    public static String detectPartCharset(Part p) throws MessagingException {
        try {
            return CharsetDetector.detectCharset(p.getInputStream());
        }
        catch (IOException e) {
            InputStream rawIn;
            if (p instanceof MimeBodyPart) {
                rawIn = ((MimeBodyPart)p).getRawInputStream();
            } else if (p instanceof MimeMessage) {
                rawIn = ((MimeMessage)p).getRawInputStream();
            } else {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return FALLBACK;
            }
            return CharsetDetector.detectCharset(rawIn);
        }
    }

    public static String detectCharset(byte[] in) {
        return CharsetDetector.detectCharset(in, in.length);
    }

    public static String detectCharset(byte[] in, int len) {
        if (null == in) {
            throw new NullPointerException("byte array input stream is null");
        }
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(in, 0, len);
        detector.dataEnd();
        return CharsetDetector.getResultingCharset(detector);
    }

    public static String detectCharset(ByteArrayInputStream in) {
        return CharsetDetector.detectCharset((InputStream)in);
    }

    public static String detectCharset(InputStream in) {
        try {
            return CharsetDetector.detectCharsetFailOnError(in);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return FALLBACK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectCharsetFailOnError(InputStream in) throws IOException {
        if (null == in) {
            throw new NullPointerException("input stream is null");
        }
        UniversalDetector detector = new UniversalDetector(null);
        try {
            int read;
            byte[] buffer = new byte[4096];
            while (0 < (read = in.read(buffer)) && !detector.isDone()) {
                detector.handleData(buffer, 0, read);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            Streams.close((Closeable)in);
        }
        detector.dataEnd();
        return CharsetDetector.getResultingCharset(detector);
    }

    private static String getResultingCharset(UniversalDetector detector) {
        String detectedCharset = detector.getDetectedCharset();
        if (null == detectedCharset || !CharsetDetector.isValid(detectedCharset)) {
            return FALLBACK;
        }
        return detectedCharset;
    }
}

