/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.List;

public class ArrayIterator<T>
implements SearchIterator<T> {
    private int index;
    private final T[] array;
    private final List<OXException> warnings = new ArrayList<OXException>();

    public ArrayIterator(T[] array) {
        this.array = Arrays.clone(array);
    }

    @Override
    public boolean hasNext() throws OXException {
        return this.index < this.array.length;
    }

    @Override
    public T next() throws OXException {
        return this.array[this.index++];
    }

    @Override
    public void close() throws OXException {
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    @Override
    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }
}

