/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json.cache;

import com.openexchange.java.Charsets;
import com.openexchange.json.cache.JsonCacheService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class JsonCaches {
    private static final String ALGORITHM_MD5 = "MD5";
    private static final String ALGORITHM_SHA1 = "SHA1";
    public static final AtomicReference<JsonCacheService> CACHE_REFERENCE = new AtomicReference();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private JsonCaches() {
    }

    public static JsonCacheService getCache() {
        return CACHE_REFERENCE.get();
    }

    public static String getMD5Sum(String ... args) {
        if (null == args || 0 == args.length) {
            return "";
        }
        return JsonCaches.getCheckSum(ALGORITHM_MD5, args);
    }

    public static String getSHA1Sum(String ... args) {
        if (null == args || 0 == args.length) {
            return "";
        }
        return JsonCaches.getCheckSum(ALGORITHM_SHA1, args);
    }

    private static String getCheckSum(String algorithm, String[] args) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            for (String arg : args) {
                if (null == arg) continue;
                md.update(arg.getBytes(Charsets.UTF_8));
            }
            return JsonCaches.asHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static String asHex(byte[] hash) {
        int length = hash.length;
        char[] buf = new char[length * 2];
        int x = 0;
        for (int i = 0; i < length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    public static boolean areEqual(JSONValue a, JSONValue b) {
        try {
            int bLen;
            if (a == b) {
                return true;
            }
            if (null == a) {
                return null == b;
            }
            if (null == b) {
                return false;
            }
            int aLen = a.length();
            if (aLen != (bLen = b.length())) {
                return false;
            }
            if (a.isArray()) {
                if (!b.isArray()) {
                    return false;
                }
                JSONArray aj = a.toArray();
                JSONArray bj = b.toArray();
                boolean bool = true;
                for (int i = 0; bool && i < aLen; ++i) {
                    Object bo;
                    Object ao = aj.get(i);
                    bool = JsonCaches.areJSONArrays(ao, bo = bj.get(i)) ? JsonCaches.areEqual((JSONValue)((JSONArray)ao), (JSONValue)((JSONArray)bo)) : (JsonCaches.areJSONObjects(ao, bo) ? JsonCaches.areEqual((JSONValue)((JSONObject)ao), (JSONValue)((JSONObject)bo)) : ao.equals(bo));
                }
                return bool;
            }
            if (!b.isObject()) {
                return false;
            }
            JSONObject aj = a.toObject();
            JSONObject bj = b.toObject();
            for (Map.Entry entry : aj.entrySet()) {
                Object bo;
                String name = (String)entry.getKey();
                if (!bj.has(name)) {
                    return false;
                }
                Object ao = entry.getValue();
                if (!(JsonCaches.areJSONArrays(ao, bo = bj.get(name)) ? !JsonCaches.areEqual((JSONValue)((JSONArray)ao), (JSONValue)((JSONArray)bo)) : (JsonCaches.areJSONObjects(ao, bo) ? !JsonCaches.areEqual((JSONValue)((JSONObject)ao), (JSONValue)((JSONObject)bo)) : !ao.equals(bo)))) continue;
                return false;
            }
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private static boolean areJSONArrays(Object ... objects) {
        boolean b = true;
        for (int i = 0; b && i < objects.length; ++i) {
            b = objects[i] instanceof JSONArray;
        }
        return b;
    }

    private static boolean areJSONObjects(Object ... objects) {
        boolean b = true;
        for (int i = 0; b && i < objects.length; ++i) {
            b = objects[i] instanceof JSONObject;
        }
        return b;
    }
}

