/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.AppointmentTest;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DeleteTest
extends AppointmentTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testDelete() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testDelete");
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = DeleteTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = DeleteTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.appointmentFolderId}, {objectId2, this.appointmentFolderId}};
        DeleteTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteConcurentConflict() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentConcurentConflict");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DeleteTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            DeleteTest.deleteAppointment(this.webCon, objectId, this.appointmentFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            DeleteTest.fail((String)"expected concurent modification exception!");
        }
        catch (OXException exc) {
            DeleteTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1000);
        }
        DeleteTest.deleteAppointment(this.webCon, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteNotFound() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentNotFound");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DeleteTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            DeleteTest.deleteAppointment(this.webCon, objectId + 1000, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
            DeleteTest.fail((String)"expected object not found exception!");
        }
        catch (OXException exc) {
            DeleteTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        DeleteTest.deleteAppointment(this.webCon, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteRecurrenceWithDatePosition() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        int changeExceptionPosition = 3;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteRecurrenceWithDatePosition");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DeleteTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DeleteTest.loadAppointment(this.webCon, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        DeleteTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        DeleteTest.deleteAppointment(this.webCon, objectId, this.appointmentFolderId, modified, new Date(c.getTimeInMillis() + 259200000L), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        DeleteTest.assertEqualsAndNotNull("delete exception is not equals", loadAppointment.getDeleteException(), new Date[]{new Date(c.getTimeInMillis() + 259200000L)});
        DeleteTest.deleteAppointment(this.webCon, new int[][]{{objectId, this.appointmentFolderId}}, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteRecurrenceWithDeleteExceptions() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        int changeExceptionPosition = 3;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteRecurrenceWithDeleteExceptions");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DeleteTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DeleteTest.loadAppointment(this.webCon, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = DeleteTest.loadAppointment(this.webCon, objectId, this.appointmentFolderId, DeleteTest.decrementDate(modified), "http://" + this.hostName, this.login, this.password, this.context);
        DeleteTest.compareObject(appointmentObj, loadAppointment);
        appointmentObj.setDeleteExceptions(new Date[]{new Date(c.getTimeInMillis() + 259200000L)});
        DeleteTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        loadAppointment = DeleteTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, DeleteTest.decrementDate(modified), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        DeleteTest.compareObject(appointmentObj, loadAppointment);
        DeleteTest.deleteAppointment(this.webCon, new int[][]{{objectId, this.appointmentFolderId}}, "http://" + this.hostName, this.login, this.password, this.context);
    }
}

