/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.webdav.xml.AppointmentTest;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug6535Test
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(Bug6535Test.class);

    public Bug6535Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug6535() throws Exception {
        TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
        Calendar calendar = Calendar.getInstance(timeZoneUTC);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 2);
        Date recurrenceDatePosition = calendar.getTime();
        calendar.add(5, 3);
        Date until = calendar.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug6535");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        UserParticipant[] users = new UserParticipant[]{new UserParticipant(this.userId)};
        users[0].setConfirm(1);
        appointmentObj.setUsers(users);
        int objectId = Bug6535Test.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment recurrenceUpdate = new Appointment();
        recurrenceUpdate.setTitle("testBug6535 - exception");
        recurrenceUpdate.setStartDate(new Date(this.startTime.getTime() + 600000L));
        recurrenceUpdate.setEndDate(new Date(this.endTime.getTime() + 600000L));
        recurrenceUpdate.setRecurrenceDatePosition(recurrenceDatePosition);
        recurrenceUpdate.setShownAs(3);
        recurrenceUpdate.setParentFolderID(this.appointmentFolderId);
        recurrenceUpdate.setIgnoreConflicts(true);
        recurrenceUpdate.setUsers(users);
        Bug6535Test.updateAppointment(this.getWebConversation(), recurrenceUpdate, objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = Bug6535Test.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug6535Test.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = Bug6535Test.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, Bug6535Test.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug6535Test.compareObject(appointmentObj, loadAppointment);
        Bug6535Test.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

