/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.TestInit;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class AbstractInfostoreTest
extends TestCase {
    protected InfostoreFacade infostore;
    protected Context ctx = null;
    protected User user = null;
    protected User user2 = null;
    protected UserPermissionBits userConfig = null;
    protected UserPermissionBits userConfig2 = null;
    protected int folderId;
    protected int folderId2;
    protected ServerSession session;
    protected ServerSession session2;
    protected List<DocumentMetadata> clean;
    protected List<FolderObject> cleanFolders = null;
    protected DBProvider provider = null;

    public void setUp() throws Exception {
        this.clean = new ArrayList<DocumentMetadata>();
        this.cleanFolders = new ArrayList<FolderObject>();
        TestInit.loadTestProperties();
        Init.startServer();
        ContextStorage.getInstance();
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        String userName2 = config.getSecondUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.user = UserStorage.getInstance().getUser(tools.resolveUser(userName, this.ctx), this.ctx);
        this.user2 = UserStorage.getInstance().getUser(tools.resolveUser(userName2, this.ctx), this.ctx);
        this.session = ServerSessionFactory.createServerSession(this.user.getId(), this.ctx, "blupp");
        this.session2 = ServerSessionFactory.createServerSession(this.user2.getId(), this.ctx, "blupp2");
        this.userConfig = this.session.getUserPermissionBits();
        this.userConfig2 = this.session2.getUserPermissionBits();
        this.folderId = this.getPrivateInfostoreFolder(this.ctx, this.user, this.session);
        this.folderId2 = this.getPrivateInfostoreFolder(this.ctx, this.user2, this.session2);
        this.provider = new DBPoolProvider();
        this.infostore = new InfostoreFacadeImpl(this.provider);
    }

    public int getPrivateInfostoreFolder(Context context, User usr, ServerSession sess) throws OXException {
        OXFolderAccess oxfa = new OXFolderAccess(context);
        return oxfa.getDefaultFolder(usr.getId(), 8).getObjectID();
    }

    public void tearDown() throws Exception {
        for (DocumentMetadata dm : this.clean) {
            this.infostore.removeDocument(new int[]{dm.getId()}, System.currentTimeMillis(), this.session);
        }
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        for (FolderObject folder : this.cleanFolders) {
            oxma.deleteFolder(folder, false, System.currentTimeMillis());
        }
        Init.stopServer();
    }

    protected InfostoreFacade getInfostore() {
        return this.infostore;
    }

    protected ServerSession getSession() {
        return this.session;
    }

    public ServerSession getSession2() {
        return this.session2;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public User getUser() {
        return this.user;
    }

    public User getUser2() {
        return this.user2;
    }

    public UserPermissionBits getUserPermissionBits() {
        return this.userConfig;
    }

    public UserPermissionBits getUserPermissionBits2() {
        return this.userConfig2;
    }

    public int getFolderId2() {
        return this.folderId2;
    }

    public DBProvider getProvider() {
        return this.provider;
    }
}

