/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.AbstractContactTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.importers.ICalImporter;
import com.openexchange.java.Charsets;
import com.openexchange.session.Session;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.session.ServerSessionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Bug7470Test
extends AbstractContactTest {
    public final Format format = Format.ICAL;
    private static Context ctx;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(Bug7470Test.class);
    }

    @BeforeClass
    public static void initialize() throws Exception {
        Init.startServer();
        UserStorage uStorage = UserStorage.getInstance();
        ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId("defaultcontext"));
        userId = uStorage.getUserId(AjaxInit.getAJAXProperty("login"), ctx);
        sessObj = ServerSessionFactory.createServerSession(userId, 1, "csv-tests");
        userId = sessObj.getUserId();
        imp = new ICalImporter(null);
    }

    @AfterClass
    public static void shutdown() throws Exception {
        Init.stopServer();
    }

    @After
    public void cleanUpAfterTest() throws OXException {
        Bug7470Test.deleteTestFolder(folderId);
    }

    @Test
    public void test7470() throws SQLException, UnsupportedEncodingException, OXException, NumberFormatException, OXException, OXException {
        folderId = Bug7470Test.createTestFolder(2, sessObj, ctx, "ical7470Folder");
        String email = "cbartkowiak@oxhemail.open-xchange.com";
        String cn = "Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)";
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:REQUEST\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP\n\n=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDESCRIPTION:Hallo Hallo\n\n\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nLAST-MODIFIED:20070521T150327Z\nLOCATION:Location here\nORGANIZER;CN=Tobias:mailto:tfriedrich@oxhemail.open-xchange.com\nPRIORITY:5\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E0080000000060565ABBC99BC701000000000000000\n\t010000000E4B2BA931D32B84DAFB227C9E0CA348C\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-DISALLOW-COUNTER:FALSE\nX-MS-OLK-ALLOWEXTERNCHECK:TRUE\nX-MS-OLK-AUTOFILLLOCATION:FALSE\nX-MS-OLK-CONFTYPE:0\nBEGIN:VALARM\nTRIGGER:PT0M\nACTION:DISPLAY\nDESCRIPTION:Reminder\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR";
        Assert.assertTrue((String)"Can import?", (boolean)imp.canImport(sessObj, this.format, this._folders(), null));
        List results = imp.importData(sessObj, this.format, (InputStream)new ByteArrayInputStream("BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:REQUEST\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP\n\n=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDESCRIPTION:Hallo Hallo\n\n\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nLAST-MODIFIED:20070521T150327Z\nLOCATION:Location here\nORGANIZER;CN=Tobias:mailto:tfriedrich@oxhemail.open-xchange.com\nPRIORITY:5\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E0080000000060565ABBC99BC701000000000000000\n\t010000000E4B2BA931D32B84DAFB227C9E0CA348C\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-DISALLOW-COUNTER:FALSE\nX-MS-OLK-ALLOWEXTERNCHECK:TRUE\nX-MS-OLK-AUTOFILLLOCATION:FALSE\nX-MS-OLK-CONFTYPE:0\nBEGIN:VALARM\nTRIGGER:PT0M\nACTION:DISPLAY\nDESCRIPTION:Reminder\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR".getBytes(Charsets.UTF_8)), this._folders(), null);
        Assert.assertEquals((String)"One import?", (long)1L, (long)results.size());
        ImportResult res = (ImportResult)results.get(0);
        Assert.assertEquals((String)"Shouldn't have error", null, (Object)((Object)res.getException()));
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(Integer.parseInt(res.getObjectId()), folderId);
        Assert.assertTrue((String)"Exists", (appointmentObj != null ? 1 : 0) != 0);
        Participant[] participants = appointmentObj.getParticipants();
        Assert.assertEquals((String)"Number of attendees?", (long)2L, (long)participants.length);
        boolean containsAttendee = false;
        for (Participant p : participants) {
            if (!"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)".equals(p.getDisplayName()) || !"cbartkowiak@oxhemail.open-xchange.com".equals(p.getEmailAddress())) continue;
            containsAttendee = true;
        }
        Assert.assertTrue((String)"Found attendee?", (boolean)containsAttendee);
    }
}

