/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class NewTest
extends CalDAVTest {
    public NewTest(String name) {
        super(name);
    }

    public void testCreateSimpleOnClient() throws Exception {
        String uid = NewTest.randomUID();
        String summary = "test";
        String location = "testcity";
        Date start = TimeTools.D("tomorrow at 3pm");
        Date end = TimeTools.D("tomorrow at 4pm");
        String iCal = NewTest.generateICal(start, end, uid, summary, location);
        NewTest.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        NewTest.assertEquals(appointment, start, end, uid, summary, location);
        ICalResource iCalResource = super.get(uid, null);
        NewTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        NewTest.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        NewTest.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        NewTest.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
    }

    public void testCreateSimpleOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = NewTest.randomUID();
        String summary = "hallo";
        String location = "achtung";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = NewTest.generateAppointment(start, end, uid, summary, location);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = NewTest.assertContains(uid, calendarData);
        NewTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        NewTest.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        NewTest.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
    }

    public void testCreateAllDayOnClient() throws Exception {
        String uid = NewTest.randomUID();
        String summary = "test all day";
        Date start = TimeTools.D("midnight");
        Date end = TimeTools.D("tomorrow at midnight");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//iCal 5.0.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VEVENT\r\nCREATED:" + NewTest.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND;VALUE=DATE:" + NewTest.formatAsDate(end) + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:" + summary + "\r\n" + "LAST-MODIFIED:" + NewTest.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + NewTest.formatAsUTC(new Date()) + "\r\n" + "DTSTART;VALUE=DATE:" + NewTest.formatAsDate(start) + "\r\n" + "SEQUENCE:0" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        NewTest.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        NewTest.assertNotNull((String)"appointmnet not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        NewTest.assertEquals((String)"title wrong", (String)summary, (String)appointment.getTitle());
        NewTest.assertTrue((String)"full time wrong", (boolean)appointment.getFullTime());
        ICalResource iCalResource = super.get(uid, null);
        NewTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        NewTest.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        NewTest.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        NewTest.assertEquals((String)"START wrong", (Object)start, (Object)iCalResource.getVEvent().getDTStart());
        NewTest.assertEquals((String)"END wrong", (Object)end, (Object)iCalResource.getVEvent().getDTEnd());
    }

    public void testAllDayOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = NewTest.randomUID();
        String summary = "all day";
        String location = "testing";
        Date start = TimeTools.D("next monday at midnight");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(6, 1);
        Date end = calendar.getTime();
        Appointment appointment = NewTest.generateAppointment(start, end, uid, summary, location);
        appointment.setFullTime(true);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = NewTest.assertContains(uid, calendarData);
        NewTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        NewTest.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        NewTest.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
        NewTest.assertEquals((String)"START wrong", (Object)start, (Object)iCalResource.getVEvent().getDTStart());
        NewTest.assertEquals((String)"END wrong", (Object)end, (Object)iCalResource.getVEvent().getDTEnd());
    }

    public void testCreateWithDifferentName() throws Exception {
        String resourceName = NewTest.randomUID();
        String uid = NewTest.randomUID();
        String summary = "test with filename";
        String location = "loco";
        Date start = TimeTools.D("last sunday at 2am");
        Date end = TimeTools.D("last sunday at 7am");
        String iCal = NewTest.generateICal(start, end, uid, summary, location);
        NewTest.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(resourceName, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        NewTest.assertEquals(appointment, start, end, uid, summary, location);
        ICalResource iCalResource = super.get(resourceName, null);
        NewTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        NewTest.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        NewTest.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        NewTest.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
    }
}

