/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.writer.TaskWriter;
import com.openexchange.groupware.tasks.Task;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractTaskRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<T> {
    public static final String TASKS_URL = "/ajax/tasks";
    public static final int[] GUI_COLUMNS = new int[]{1, 20};

    protected AbstractTaskRequest() {
    }

    @Override
    public String getServletPath() {
        return TASKS_URL;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    protected JSONObject convert(Task task, TimeZone timeZone) throws JSONException {
        JSONObject retval = new JSONObject();
        new TaskWriter(timeZone).writeTask(task, retval);
        if (task.getStartDate() == null && task.containsStartDate()) {
            retval.put("start_date", JSONObject.NULL);
        }
        if (task.getEndDate() == null && task.containsEndDate()) {
            retval.put("end_date", JSONObject.NULL);
        }
        return retval;
    }

    public static int[] addGUIColumns(int[] columns) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < columns.length; ++i) {
            list.add(columns[i]);
        }
        for (i = 0; i < GUI_COLUMNS.length; ++i) {
            Integer column = GUI_COLUMNS[i];
            if (list.contains(column)) continue;
            list.add(column);
        }
        int[] retval = new int[list.size()];
        for (int i2 = 0; i2 < retval.length; ++i2) {
            retval[i2] = (Integer)list.get(i2);
        }
        return retval;
    }
}

