/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug26217Test
extends AbstractTaskTest {
    private AJAXClient client;
    private Task task;
    private TimeZone tz;
    private FolderObject moveTo;

    public Bug26217Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.getTimeZone();
        this.task = com.openexchange.groupware.tasks.Create.createWithDefaults(this.getPrivateFolder(), "Task to test for bug 26217");
        Calendar cal = TimeTools.createCalendar(TimeZones.UTC);
        cal.set(10, 0);
        this.task.setStartDate(cal.getTime());
        this.task.setEndDate(cal.getTime());
        InsertRequest request = new InsertRequest(this.task, this.tz);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
        this.moveTo = Create.createPrivateFolder("Bug 26217 test", 1, this.client.getValues().getUserId());
        this.moveTo.setParentFolderID(1);
        com.openexchange.ajax.folder.actions.InsertResponse response2 = this.client.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.moveTo));
        this.moveTo.setObjectID(response2.getId());
        this.moveTo.setLastModified(response2.getTimestamp());
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        this.client.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.moveTo));
        super.tearDown();
    }

    @Test
    public void testForBug() throws OXException, IOException, JSONException {
        Task update = TaskTools.valuesForUpdate(this.task);
        update.setParentFolderID(this.moveTo.getObjectID());
        UpdateResponse response = this.client.execute(new UpdateRequest(this.getPrivateFolder(), update, this.tz));
        if (response.hasError()) {
            Bug26217Test.fail((String)("Moving task failed: " + response.getErrorMessage()));
        }
        update.setLastModified(response.getTimestamp());
        update.setParentFolderID(this.getPrivateFolder());
        GetResponse testResponse = this.client.execute(new GetRequest(this.moveTo.getObjectID(), this.task.getObjectID()));
        if (testResponse.hasError()) {
            Bug26217Test.fail((String)("Reading task after moving failed: " + testResponse.getErrorMessage()));
        }
        if ((response = this.client.execute(new UpdateRequest(this.moveTo.getObjectID(), update, this.tz))).hasError()) {
            Bug26217Test.fail((String)("Moving task failed: " + response.getErrorMessage()));
        }
        update.setLastModified(response.getTimestamp());
        this.task.setLastModified(response.getTimestamp());
        testResponse = this.client.execute(new GetRequest(this.getPrivateFolder(), this.task.getObjectID()));
        if (testResponse.hasError()) {
            Bug26217Test.fail((String)("Reading task after moving failed: " + testResponse.getErrorMessage()));
        }
    }
}

