/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.actions.AllRequest;
import com.openexchange.ajax.mail.filter.actions.AllResponse;
import com.openexchange.ajax.mail.filter.actions.DeleteRequest;
import com.openexchange.ajax.mail.filter.actions.InsertRequest;
import com.openexchange.ajax.mail.filter.actions.InsertResponse;
import com.openexchange.ajax.mail.filter.actions.UpdateRequest;
import com.openexchange.ajax.mail.filter.parser.action.ActionParserFactory;
import com.openexchange.ajax.mail.filter.parser.action.AddFlagsParserImpl;
import com.openexchange.ajax.mail.filter.parser.action.MoveParserImpl;
import com.openexchange.ajax.mail.filter.parser.action.RedirectParserImpl;
import com.openexchange.ajax.mail.filter.parser.action.RejectParserImpl;
import com.openexchange.ajax.mail.filter.parser.action.SimpleActionParserImpl;
import com.openexchange.ajax.mail.filter.parser.action.VacationParserImpl;
import com.openexchange.ajax.mail.filter.parser.comparison.ComparisonParserFactory;
import com.openexchange.ajax.mail.filter.parser.comparison.ContainsParserImpl;
import com.openexchange.ajax.mail.filter.parser.comparison.IsParserImpl;
import com.openexchange.ajax.mail.filter.parser.comparison.MatchesParserImpl;
import com.openexchange.ajax.mail.filter.parser.comparison.RegexParserImpl;
import com.openexchange.ajax.mail.filter.parser.comparison.SizeComparisonParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.AddressParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.AllOfParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.AnyOfParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.EnvelopeParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.HeaderParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.NotParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.SizeTestParserImpl;
import com.openexchange.ajax.mail.filter.parser.test.TestParserFactory;
import com.openexchange.ajax.mail.filter.parser.test.TrueParserImpl;
import com.openexchange.ajax.mail.filter.test.AbstractTest;
import com.openexchange.ajax.mail.filter.writer.action.ActionWriterFactory;
import com.openexchange.ajax.mail.filter.writer.action.AddFlagsWriterImpl;
import com.openexchange.ajax.mail.filter.writer.action.MoveWriterImpl;
import com.openexchange.ajax.mail.filter.writer.action.RedirectWriterImpl;
import com.openexchange.ajax.mail.filter.writer.action.RejectWriterImpl;
import com.openexchange.ajax.mail.filter.writer.action.SimpleActionWriterImpl;
import com.openexchange.ajax.mail.filter.writer.action.VacationWriterImpl;
import com.openexchange.ajax.mail.filter.writer.comparison.ComparisonWriterFactory;
import com.openexchange.ajax.mail.filter.writer.comparison.ContainsWriterImpl;
import com.openexchange.ajax.mail.filter.writer.comparison.IsWriterImpl;
import com.openexchange.ajax.mail.filter.writer.comparison.MatchesWriterImpl;
import com.openexchange.ajax.mail.filter.writer.comparison.RegexWriterImpl;
import com.openexchange.ajax.mail.filter.writer.comparison.SizeComparisonWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.AddressWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.AllOfWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.AnyOfWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.EnvelopeWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.HeaderWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.NotWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.SizeTestWriterImpl;
import com.openexchange.ajax.mail.filter.writer.test.TestWriterFactory;
import com.openexchange.ajax.mail.filter.writer.test.TrueWriterImpl;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.AjaxInit;
import com.openexchange.test.OXTestToolkit;
import java.util.Date;

public class AbstractMailFilterTest
extends AbstractAJAXSession {
    public static final int[] cols = new int[]{1};
    protected static final String HOSTNAME = "hostname";
    protected String hostname = null;

    public AbstractMailFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.hostname = AjaxInit.getAJAXProperty(HOSTNAME);
        ActionParserFactory.addParser("addflags", new AddFlagsParserImpl());
        ActionParserFactory.addParser("discard", new SimpleActionParserImpl());
        ActionParserFactory.addParser("keep", new SimpleActionParserImpl());
        ActionParserFactory.addParser("move", new MoveParserImpl());
        ActionParserFactory.addParser("redirect", new RedirectParserImpl());
        ActionParserFactory.addParser("reject", new RejectParserImpl());
        ActionParserFactory.addParser("stop", new SimpleActionParserImpl());
        ActionParserFactory.addParser("vacation", new VacationParserImpl());
        TestParserFactory.addParser("address", new AddressParserImpl());
        TestParserFactory.addParser("allof", new AllOfParserImpl());
        TestParserFactory.addParser("anyof", new AnyOfParserImpl());
        TestParserFactory.addParser("envelope", new EnvelopeParserImpl());
        TestParserFactory.addParser("header", new HeaderParserImpl());
        TestParserFactory.addParser("not", new NotParserImpl());
        TestParserFactory.addParser("true", new TrueParserImpl());
        TestParserFactory.addParser("size", new SizeTestParserImpl());
        ComparisonParserFactory.addParser("is", new IsParserImpl());
        ComparisonParserFactory.addParser("matches", new MatchesParserImpl());
        ComparisonParserFactory.addParser("contains", new ContainsParserImpl());
        ComparisonParserFactory.addParser("regex", new RegexParserImpl());
        ComparisonParserFactory.addParser("size", new SizeComparisonParserImpl());
        ActionWriterFactory.addWriter("addflags", new AddFlagsWriterImpl());
        ActionWriterFactory.addWriter("discard", new SimpleActionWriterImpl());
        ActionWriterFactory.addWriter("keep", new SimpleActionWriterImpl());
        ActionWriterFactory.addWriter("move", new MoveWriterImpl());
        ActionWriterFactory.addWriter("redirect", new RedirectWriterImpl());
        ActionWriterFactory.addWriter("reject", new RejectWriterImpl());
        ActionWriterFactory.addWriter("stop", new SimpleActionWriterImpl());
        ActionWriterFactory.addWriter("vacation", new VacationWriterImpl());
        TestWriterFactory.addWriter("address", new AddressWriterImpl());
        TestWriterFactory.addWriter("allof", new AllOfWriterImpl());
        TestWriterFactory.addWriter("anyof", new AnyOfWriterImpl());
        TestWriterFactory.addWriter("envelope", new EnvelopeWriterImpl());
        TestWriterFactory.addWriter("header", new HeaderWriterImpl());
        TestWriterFactory.addWriter("not", new NotWriterImpl());
        TestWriterFactory.addWriter("true", new TrueWriterImpl());
        TestWriterFactory.addWriter("size", new SizeTestWriterImpl());
        ComparisonWriterFactory.addWriter("is", new IsWriterImpl());
        ComparisonWriterFactory.addWriter("matches", new MatchesWriterImpl());
        ComparisonWriterFactory.addWriter("contains", new ContainsWriterImpl());
        ComparisonWriterFactory.addWriter("regex", new RegexWriterImpl());
        ComparisonWriterFactory.addWriter("size", new SizeComparisonWriterImpl());
    }

    public String getHostName() {
        return this.hostname;
    }

    public static void deleteAllExistingRules(String forUser, AJAXSession ajaxSession) throws Exception {
        String[] idArray = AbstractMailFilterTest.getIdArray(forUser, ajaxSession);
        if (idArray != null) {
            for (int a = 0; a < idArray.length; ++a) {
                AbstractMailFilterTest.deleteRule(idArray[a], forUser, ajaxSession);
            }
        }
    }

    public static String insertRule(Rule rule, String forUser, AJAXSession ajaxSession) throws Exception {
        InsertRequest insertRequest = new InsertRequest(rule, forUser);
        InsertResponse insertResponse = (InsertResponse)((Object)Executor.execute(ajaxSession, insertRequest));
        return insertResponse.getId();
    }

    public static void updateRule(Rule rule, String forUser, AJAXSession ajaxSession) throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(rule, forUser);
        Executor.execute(ajaxSession, updateRequest);
    }

    public static void deleteRule(String id, String forUser, AJAXSession ajaxSession) throws Exception {
        DeleteRequest deleteRequest = new DeleteRequest(id);
        Executor.execute(ajaxSession, deleteRequest);
    }

    public static String[] getIdArray(String forUser, AJAXSession ajaxSession) throws Exception {
        AllRequest allRequest = new AllRequest("/ajax/mailfilter");
        AllResponse allResponse = (AllResponse)((Object)Executor.execute(ajaxSession, allRequest));
        allResponse.getTimestamp();
        Rule[] ruleArray = allResponse.getRules();
        String[] idArray = new String[ruleArray.length];
        for (int a = 0; a < ruleArray.length; ++a) {
            idArray[a] = ruleArray[a].getId();
        }
        return idArray;
    }

    public static Date getLastModified(AJAXSession ajaxSession) throws Exception {
        AllRequest allRequest = new AllRequest("/ajax/mailfilter");
        AllResponse allResponse = (AllResponse)((Object)Executor.execute(ajaxSession, allRequest));
        return allResponse.getTimestamp();
    }

    public static Rule loadRules(String forUser, String id, AJAXSession ajaxSession) throws Exception {
        Rule[] rules = AbstractMailFilterTest.listRules(ajaxSession);
        for (int a = 0; a < rules.length; ++a) {
            if (!rules[a].getId().equals(id)) continue;
            return rules[a];
        }
        return null;
    }

    public static Rule[] listRules(AJAXSession ajaxSession) throws Exception {
        AllRequest allRequest = new AllRequest("/ajax/mailfilter");
        AllResponse allResponse = (AllResponse)((Object)Executor.execute(ajaxSession, allRequest));
        return allResponse.getRules();
    }

    public static Rule[] listRulesForUser(AJAXSession ajaxSession, String userName) throws Exception {
        AllRequest allRequest = new AllRequest("/ajax/mailfilter", userName);
        AllResponse allResponse = (AllResponse)((Object)Executor.execute(ajaxSession, allRequest));
        return allResponse.getRules();
    }

    public static void compareRule(Rule rule1, Rule rule2) throws Exception {
        OXTestToolkit.assertEqualsAndNotNull("id is not equals", rule1.getId(), rule2.getId());
        OXTestToolkit.assertEqualsAndNotNull("name is not equals", rule1.getName(), rule2.getName());
        AbstractMailFilterTest.assertEquals((String)"active is not equals", (boolean)rule1.isActive(), (boolean)rule2.isActive());
        OXTestToolkit.assertEqualsAndNotNull("position is not equals", Autoboxing.I((int)rule1.getPosition()), Autoboxing.I((int)rule2.getPosition()));
        AbstractMailFilterTest.compareFlags(rule1.getFlags(), rule2.getFlags());
        AbstractMailFilterTest.compareActionCmds(rule1.getActioncmds(), rule2.getActioncmds());
        AbstractMailFilterTest.compareTest(rule1.getTest(), rule2.getTest());
    }

    public static void compareFlags(String[] flags1, String[] flags2) throws Exception {
        if (flags1 != null) {
            AbstractMailFilterTest.assertNotNull((String)"flags are null", (Object)flags2);
            AbstractMailFilterTest.assertEquals((String)"flags size is not equals", (int)flags1.length, (int)flags2.length);
            for (int a = 0; a < flags1.length; ++a) {
                OXTestToolkit.assertEqualsAndNotNull("flag at position " + a + " is not equals", flags1[a], flags2[a]);
            }
        }
    }

    public static void compareActionCmds(AbstractAction[] abstractAction1, AbstractAction[] abstractAction2) throws Exception {
        if (abstractAction1 != null) {
            AbstractMailFilterTest.assertNotNull((String)"abstract action array null", (Object)abstractAction2);
            AbstractMailFilterTest.assertEquals((String)"abstract action size is not equals", (int)abstractAction1.length, (int)abstractAction2.length);
            for (int a = 0; a < abstractAction1.length; ++a) {
                OXTestToolkit.assertEqualsAndNotNull("abstract action at position " + a + " is not equals", abstractAction1[a], abstractAction2[a]);
            }
        }
    }

    public static void compareTest(AbstractTest abstractTest1, AbstractTest abstractTest2) throws Exception {
        OXTestToolkit.assertEqualsAndNotNull("abstract test is not equals", abstractTest1, abstractTest2);
    }
}

