/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.links;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.links.actions.AbstractLinkRequest;
import com.openexchange.ajax.links.actions.AllRequest;
import com.openexchange.ajax.links.actions.AllResponse;
import com.openexchange.ajax.links.actions.DeleteRequest;
import com.openexchange.ajax.links.actions.InsertRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class LinkTools
extends Assert {
    private static final Log LOG = LogFactory.getLog(LinkTools.class);
    private static final String ENCODING = "UTF-8";
    private static final String LINK_URL = "/ajax/link";

    private LinkTools() {
    }

    public static Response insertLink(WebConversation conv, String host, String session, LinkObject link) throws JSONException, IOException, SAXException {
        LOG.trace((Object)"Inserting link.");
        JSONObject json = AbstractLinkRequest.convert(link);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        ByteArrayInputStream bais = new ByteArrayInputStream(json.toString().getBytes(ENCODING));
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + host + LINK_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conv.getResponse((WebRequest)req);
        LinkTools.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace((Object)("Response body: " + body));
        return Response.parse((String)body);
    }

    public static void extractInsertId(Response response) {
        LinkTools.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
    }

    public static CommonInsertResponse insert(AJAXClient client, InsertRequest request) throws OXException, IOException, SAXException, JSONException {
        return (CommonInsertResponse)((Object)Executor.execute(client, request));
    }

    public static AllResponse all(AJAXClient client, AllRequest request) throws OXException, IOException, SAXException, JSONException {
        return Executor.execute(client, request);
    }

    public static CommonDeleteResponse delete(AJAXClient client, DeleteRequest request) throws OXException, IOException, SAXException, JSONException {
        return (CommonDeleteResponse)((Object)Executor.execute(client, request));
    }
}

