/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.contacts;

import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.kata.AbstractStep;
import com.openexchange.ajax.kata.IdentitySource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.test.ContactTestManager;
import java.util.Date;

public class ContactCreateStep
extends AbstractStep
implements IdentitySource<Contact> {
    private final Contact entry;
    private boolean inserted;
    private ContactTestManager manager;

    public ContactCreateStep(Contact entry, String name, String expectedError) {
        super(name, expectedError);
        this.entry = entry;
    }

    @Override
    public void cleanUp() throws Exception {
        if (this.inserted) {
            this.entry.setLastModified(new Date(Long.MAX_VALUE));
            this.manager.setFailOnError(false);
            this.manager.deleteAction(this.entry);
        }
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.client = client;
        this.manager = new ContactTestManager(client);
        InsertRequest insertRequest = new InsertRequest(this.entry, false);
        InsertResponse insertResponse = this.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.entry);
        this.inserted = !insertResponse.hasError();
        this.checkError(insertResponse);
    }

    @Override
    public void assumeIdentity(Contact contact) {
        contact.setObjectID(this.entry.getObjectID());
        contact.setParentFolderID(this.entry.getParentFolderID());
        contact.setLastModified(this.entry.getLastModified());
    }

    @Override
    public void rememberIdentityValues(Contact contact) {
        contact.setLastModified(this.entry.getLastModified());
        contact.setParentFolderID(this.entry.getParentFolderID());
    }

    @Override
    public void forgetIdentity(Contact entry) {
        this.inserted = false;
    }

    @Override
    public Class<Contact> getType() {
        return Contact.class;
    }
}

