/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.HasRequest;
import com.openexchange.ajax.appointment.action.HasResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Bug13027Test
extends AbstractAJAXSession {
    public Bug13027Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNegativeTimeZone() throws Exception {
        String formerTimeZone;
        AJAXClient client;
        block3: {
            DeleteRequest deleteRequest;
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = TimeZone.getTimeZone("America/New York");
            formerTimeZone = "Europe/Berlin";
            Appointment appointment = new Appointment();
            int objectId = 0;
            Date lastModified = null;
            try {
                GetRequest getRequest = new GetRequest(Tree.TimeZone);
                GetResponse getResponse = this.getClient().execute(getRequest);
                formerTimeZone = getResponse.getString();
                SetRequest setRequest = new SetRequest(Tree.TimeZone, "America/New_York");
                client.execute(setRequest);
                this.clear(tz, folderId, client);
                appointment.setTitle("Bug 13027 Test");
                appointment.setParentFolderID(folderId);
                appointment.setIgnoreConflicts(true);
                Calendar calendar = TimeTools.createCalendar(tz);
                calendar.set(1, 2009);
                calendar.set(5, 1);
                calendar.set(2, 0);
                appointment.setStartDate(calendar.getTime());
                appointment.setEndDate(calendar.getTime());
                appointment.setFullTime(true);
                InsertRequest insertRequest = new InsertRequest(appointment, tz, false);
                AppointmentInsertResponse insertResponse = client.execute(insertRequest);
                appointment.setObjectID(insertResponse.getId());
                appointment.setLastModified(insertResponse.getTimestamp());
                objectId = appointment.getObjectID();
                appointment.setObjectID(objectId);
                lastModified = appointment.getLastModified();
                HasRequest hasRequest = new HasRequest(new Date(1230508800000L), new Date(1230854400000L), tz);
                HasResponse hasResponse = client.execute(hasRequest);
                boolean[] values = hasResponse.getValues();
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[1]);
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[2]);
                Bug13027Test.assertTrue((String)"Appointment expected.", (boolean)values[3]);
                if (objectId == 0 || lastModified == null) break block3;
                deleteRequest = new DeleteRequest(objectId, folderId, lastModified);
            }
            catch (Throwable throwable) {
                if (objectId != 0 && lastModified != null) {
                    DeleteRequest deleteRequest2 = new DeleteRequest(objectId, folderId, lastModified);
                    client.execute(deleteRequest2);
                }
                SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
                client.execute(setRequest);
                throw throwable;
            }
            client.execute(deleteRequest);
        }
        SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
        client.execute(setRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPositiveTimeZone() throws Exception {
        String formerTimeZone;
        AJAXClient client;
        block3: {
            DeleteRequest deleteRequest;
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = TimeZone.getTimeZone("Europe/Berlin");
            formerTimeZone = "Europe/Berlin";
            Appointment appointment = new Appointment();
            int objectId = 0;
            Date lastModified = null;
            try {
                GetRequest getRequest = new GetRequest(Tree.TimeZone);
                GetResponse getResponse = this.getClient().execute(getRequest);
                formerTimeZone = getResponse.getString();
                SetRequest setRequest = new SetRequest(Tree.TimeZone, "Europe/Berlin");
                client.execute(setRequest);
                this.clear(tz, folderId, client);
                appointment.setTitle("Bug 13027 Test");
                appointment.setParentFolderID(folderId);
                appointment.setIgnoreConflicts(true);
                Calendar calendar = TimeTools.createCalendar(TimeZone.getTimeZone("UTC"));
                calendar.set(1, 2009);
                calendar.set(5, 1);
                calendar.set(2, 0);
                appointment.setStartDate(calendar.getTime());
                appointment.setEndDate(calendar.getTime());
                appointment.setFullTime(true);
                InsertRequest insertRequest = new InsertRequest(appointment, tz, false);
                AppointmentInsertResponse insertResponse = client.execute(insertRequest);
                appointment.setObjectID(insertResponse.getId());
                appointment.setLastModified(insertResponse.getTimestamp());
                objectId = appointment.getObjectID();
                appointment.setObjectID(objectId);
                lastModified = appointment.getLastModified();
                HasRequest hasRequest = new HasRequest(new Date(1230508800000L), new Date(1230854400000L), tz);
                HasResponse hasResponse = client.execute(hasRequest);
                boolean[] values = hasResponse.getValues();
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[1]);
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[2]);
                Bug13027Test.assertTrue((String)"Appointment expected.", (boolean)values[3]);
                if (objectId == 0 || lastModified == null) break block3;
                deleteRequest = new DeleteRequest(objectId, folderId, lastModified);
            }
            catch (Throwable throwable) {
                if (objectId != 0 && lastModified != null) {
                    DeleteRequest deleteRequest2 = new DeleteRequest(objectId, folderId, lastModified);
                    client.execute(deleteRequest2);
                }
                SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
                client.execute(setRequest);
                throw throwable;
            }
            client.execute(deleteRequest);
        }
        SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
        client.execute(setRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUTC() throws Exception {
        String formerTimeZone;
        AJAXClient client;
        block3: {
            DeleteRequest deleteRequest;
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = TimeZone.getTimeZone("UTC");
            formerTimeZone = "Europe/Berlin";
            Appointment appointment = new Appointment();
            int objectId = 0;
            Date lastModified = null;
            try {
                GetRequest getRequest = new GetRequest(Tree.TimeZone);
                GetResponse getResponse = this.getClient().execute(getRequest);
                formerTimeZone = getResponse.getString();
                SetRequest setRequest = new SetRequest(Tree.TimeZone, "Europe/London");
                client.execute(setRequest);
                this.clear(tz, folderId, client);
                appointment.setTitle("Bug 13027 Test");
                appointment.setParentFolderID(folderId);
                appointment.setIgnoreConflicts(true);
                Calendar calendar = TimeTools.createCalendar(tz);
                calendar.set(1, 2009);
                calendar.set(5, 1);
                calendar.set(2, 0);
                appointment.setStartDate(calendar.getTime());
                appointment.setEndDate(calendar.getTime());
                appointment.setFullTime(true);
                InsertRequest insertRequest = new InsertRequest(appointment, tz, false);
                AppointmentInsertResponse insertResponse = client.execute(insertRequest);
                appointment.setObjectID(insertResponse.getId());
                appointment.setLastModified(insertResponse.getTimestamp());
                objectId = appointment.getObjectID();
                appointment.setObjectID(objectId);
                lastModified = appointment.getLastModified();
                HasRequest hasRequest = new HasRequest(new Date(1230508800000L), new Date(1230854400000L), tz);
                HasResponse hasResponse = client.execute(hasRequest);
                boolean[] values = hasResponse.getValues();
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[1]);
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[2]);
                Bug13027Test.assertTrue((String)"Appointment expected.", (boolean)values[3]);
                if (objectId == 0 || lastModified == null) break block3;
                deleteRequest = new DeleteRequest(objectId, folderId, lastModified);
            }
            catch (Throwable throwable) {
                if (objectId != 0 && lastModified != null) {
                    DeleteRequest deleteRequest2 = new DeleteRequest(objectId, folderId, lastModified);
                    client.execute(deleteRequest2);
                }
                SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
                client.execute(setRequest);
                throw throwable;
            }
            client.execute(deleteRequest);
        }
        SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
        client.execute(setRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBugAsWritten() throws Exception {
        String formerTimeZone;
        AJAXClient client;
        block3: {
            DeleteRequest deleteRequest;
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = TimeZone.getTimeZone("America/New York");
            formerTimeZone = "Europe/Berlin";
            Appointment appointment = new Appointment();
            int objectId = 0;
            Date lastModified = null;
            try {
                GetRequest getRequest = new GetRequest(Tree.TimeZone);
                GetResponse getResponse = this.getClient().execute(getRequest);
                formerTimeZone = getResponse.getString();
                SetRequest setRequest = new SetRequest(Tree.TimeZone, "America/New_York");
                client.execute(setRequest);
                this.clear(tz, folderId, client);
                appointment.setTitle("Bug 13027 Test");
                appointment.setParentFolderID(folderId);
                appointment.setIgnoreConflicts(true);
                Calendar calendar = TimeTools.createCalendar(tz);
                calendar.set(1, 2009);
                calendar.set(5, 1);
                calendar.set(2, 0);
                appointment.setStartDate(calendar.getTime());
                appointment.setEndDate(calendar.getTime());
                appointment.setFullTime(true);
                InsertRequest insertRequest = new InsertRequest(appointment, tz, false);
                AppointmentInsertResponse insertResponse = client.execute(insertRequest);
                appointment.setObjectID(insertResponse.getId());
                appointment.setLastModified(insertResponse.getTimestamp());
                objectId = appointment.getObjectID();
                appointment.setObjectID(objectId);
                lastModified = appointment.getLastModified();
                HasRequest hasRequest = new HasRequest(new Date(1230508800000L), new Date(1230854400000L), tz);
                HasResponse hasResponse = client.execute(hasRequest);
                boolean[] values = hasResponse.getValues();
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[1]);
                Bug13027Test.assertFalse((String)"No appointment expected.", (boolean)values[2]);
                Bug13027Test.assertTrue((String)"Appointment expected.", (boolean)values[3]);
                if (objectId == 0 || lastModified == null) break block3;
                deleteRequest = new DeleteRequest(objectId, folderId, lastModified);
            }
            catch (Throwable throwable) {
                if (objectId != 0 && lastModified != null) {
                    DeleteRequest deleteRequest2 = new DeleteRequest(objectId, folderId, lastModified);
                    client.execute(deleteRequest2);
                }
                SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
                client.execute(setRequest);
                throw throwable;
            }
            client.execute(deleteRequest);
        }
        SetRequest setRequest = new SetRequest(Tree.TimeZone, formerTimeZone);
        client.execute(setRequest);
    }

    private void clear(TimeZone tz, int folderId, AJAXClient client) throws Exception {
        Object[][] responseColumns;
        GregorianCalendar start = new GregorianCalendar();
        ((Calendar)start).setTimeZone(tz);
        start.set(1, 2008);
        start.set(2, 11);
        start.set(5, 30);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        GregorianCalendar end = new GregorianCalendar();
        ((Calendar)end).setTimeZone(tz);
        end.set(1, 2009);
        end.set(2, 0);
        end.set(5, 2);
        end.set(11, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 0);
        AllRequest request = new AllRequest(folderId, new int[]{1, 5}, start.getTime(), end.getTime(), tz);
        CommonAllResponse response = client.execute(request);
        for (Object[] obj : responseColumns = response.getArray()) {
            client.execute(new DeleteRequest((Integer)obj[0], folderId, new Date(Long.MAX_VALUE)));
        }
    }
}

